/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.EditPartNavigationHandlerUtil;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.Annotation;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.model.Compartment;
import org.eclipse.wst.xsd.ui.internal.adt.design.editpolicies.KeyBoardAccessibilityEditPolicy;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.ICompartmentFigure;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;

public class CompartmentEditPart
extends BaseEditPart {
    protected Annotation annotation = new Annotation();

    protected IFigure createFigure() {
        ICompartmentFigure figure = this.getFigureFactory().createCompartmentFigure(this.getModel());
        return figure;
    }

    public IFigure getContentPane() {
        return this.getCompartmentFigure().getContentPane();
    }

    public boolean hasContent() {
        return this.getChildren().size() > 1;
    }

    List getChildrenSansAnnotation() {
        ArrayList children = new ArrayList();
        children.addAll(this.getChildren());
        Iterator i = children.iterator();
        while (i.hasNext()) {
            EditPart child = (EditPart)i.next();
            if (child.getModel() != this.annotation) continue;
            i.remove();
            break;
        }
        return children;
    }

    public EditPart doGetRelativeEditPart(EditPart editPart, int direction) {
        EditPart result = null;
        List children = this.getChildrenSansAnnotation();
        if (children.contains(editPart)) {
            if (direction == KeyBoardAccessibilityEditPolicy.OUT_TO_PARENT) {
                Compartment compartment = (Compartment)this.getModel();
                EditPart parent = editPart.getParent();
                while (parent != null) {
                    if (parent.getModel() == compartment.getOwner()) {
                        result = parent;
                        break;
                    }
                    parent = parent.getParent();
                }
            } else if (direction == 4) {
                int size = children.size();
                if (size > 0 && children.get(size - 1) == editPart) {
                    CompartmentEditPart nextCompartment = (CompartmentEditPart)EditPartNavigationHandlerUtil.getNextSibling((EditPart)this);
                    result = nextCompartment != null && nextCompartment.getChildrenSansAnnotation().size() > 0 ? EditPartNavigationHandlerUtil.getFirstChild((EditPart)nextCompartment) : editPart;
                }
                if (result == null) {
                    result = EditPartNavigationHandlerUtil.getNextSibling(editPart);
                }
            } else if (direction == 1) {
                List prevCompListChildren;
                int size;
                EditPart prevCompartment;
                if (EditPartNavigationHandlerUtil.getFirstChild((EditPart)this) == editPart && (prevCompartment = EditPartNavigationHandlerUtil.getPrevSibling((EditPart)this)) instanceof CompartmentEditPart && (size = (prevCompListChildren = ((CompartmentEditPart)prevCompartment).getChildrenSansAnnotation()).size()) > 0) {
                    result = (EditPart)prevCompartment.getChildren().get(size - 1);
                }
                if (result == null) {
                    result = EditPartNavigationHandlerUtil.getPrevSibling(editPart);
                }
            }
        }
        return result;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        Object model = childEditPart.getModel();
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (model instanceof IField) {
            this.getCompartmentFigure().getContentPane().add(child, index);
            return;
        }
        if (model instanceof Annotation) {
            this.getCompartmentFigure().getAnnotationPane().add(child);
            return;
        }
        super.addChildVisual(childEditPart, index);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        Object model = childEditPart.getModel();
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        if (model instanceof IField) {
            this.getCompartmentFigure().getContentPane().remove(child);
            return;
        }
        if (model instanceof Annotation) {
            this.getCompartmentFigure().getAnnotationPane().remove(child);
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected Compartment getCompartment() {
        return (Compartment)this.getModel();
    }

    protected List getModelChildren() {
        List children = this.getCompartment().getChildren();
        children.add(this.annotation);
        return children;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.annotation.setCompartment(this.getCompartment());
    }

    protected void refreshChildren() {
        super.refreshChildren();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
    }

    public void addFeedback() {
        this.getFigure().repaint();
    }

    public void removeFeedback() {
        this.getFigure().repaint();
    }

    public ICompartmentFigure getCompartmentFigure() {
        return (ICompartmentFigure)this.figure;
    }

    public void addNotify() {
        super.addNotify();
        this.getCompartmentFigure().editPartAttached((EditPart)this);
    }
}

