/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.XSDSelectionDispatchAction;
import org.eclipse.wst.xsd.ui.internal.refactor.structure.MakeAnonymousTypeGlobalCommand;
import org.eclipse.wst.xsd.ui.internal.refactor.structure.MakeTypeGlobalProcessor;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RefactoringWizardMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.wizard.RenameRefactoringWizard;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Node;

public class MakeAnonymousTypeGlobalAction
extends XSDSelectionDispatchAction {
    private String fParentName;
    private boolean isComplexType = true;
    private XSDTypeDefinition fSelectedComponent;

    public MakeAnonymousTypeGlobalAction(ISelection selection, XSDSchema schema) {
        super(selection, schema);
        this.setText(RefactoringWizardMessages.MakeAnonymousTypeGlobalAction_text);
    }

    public boolean canRun() {
        return this.fSelectedComponent != null;
    }

    private String getNewDefaultName() {
        if (this.fParentName != null && !"".equals(this.fParentName)) {
            if (this.isComplexType) {
                return String.valueOf(this.fParentName) + "ComplexType";
            }
            return String.valueOf(this.fParentName) + "SimpleType";
        }
        if (this.isComplexType) {
            return "NewComplexType";
        }
        return "NewSimpleType";
    }

    private boolean canEnable(XSDConcreteComponent xsdComponent) {
        if (xsdComponent instanceof XSDComplexTypeDefinition) {
            this.fSelectedComponent = (XSDComplexTypeDefinition)xsdComponent;
            this.isComplexType = true;
            XSDComplexTypeDefinition typeDef = (XSDComplexTypeDefinition)xsdComponent;
            XSDConcreteComponent parent = typeDef.getContainer();
            if (parent instanceof XSDElementDeclaration) {
                this.fParentName = ((XSDElementDeclaration)parent).getName();
                return true;
            }
        } else if (xsdComponent instanceof XSDSimpleTypeDefinition) {
            this.fSelectedComponent = (XSDSimpleTypeDefinition)xsdComponent;
            this.isComplexType = false;
            XSDSimpleTypeDefinition typeDef = (XSDSimpleTypeDefinition)xsdComponent;
            XSDConcreteComponent parent = typeDef.getContainer();
            if (parent instanceof XSDElementDeclaration) {
                this.fParentName = ((XSDElementDeclaration)parent).getName();
                return true;
            }
            if (parent instanceof XSDAttributeDeclaration) {
                this.fParentName = ((XSDAttributeDeclaration)parent).getName();
                return true;
            }
        }
        return false;
    }

    protected boolean canEnable(Object selectedObject) {
        if (selectedObject instanceof XSDConcreteComponent) {
            return this.canEnable((XSDConcreteComponent)selectedObject) && super.canEnable(selectedObject);
        }
        if (selectedObject instanceof Node) {
            Node node = (Node)selectedObject;
            XSDConcreteComponent concreteComponent = this.getSchema().getCorrespondingComponent(node);
            return this.canEnable(concreteComponent) && super.canEnable(concreteComponent);
        }
        return false;
    }

    public void run1() {
        if (this.fSelectedComponent == null) {
            return;
        }
        if (this.fSelectedComponent.getSchema() == null) {
            this.getSchema().updateElement(true);
        }
        MakeTypeGlobalProcessor processor = new MakeTypeGlobalProcessor(this.fSelectedComponent, this.getNewDefaultName());
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        try {
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)refactoring, RefactoringWizardMessages.RenameComponentWizard_defaultPageTitle, RefactoringWizardMessages.RenameComponentWizard_inputPage_description, null);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            op.run(XSDEditorPlugin.getShell(), wizard.getDefaultPageTitle());
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run() {
        if (this.fSelectedComponent == null) {
            return;
        }
        if (this.fSelectedComponent.getSchema() == null) {
            this.getSchema().updateElement(true);
        }
        DocumentImpl doc = (DocumentImpl)this.fSelectedComponent.getElement().getOwnerDocument();
        doc.getModel().beginRecording((Object)this, RefactoringWizardMessages.MakeAnonymousTypeGlobalAction_text);
        MakeAnonymousTypeGlobalCommand command = new MakeAnonymousTypeGlobalCommand((XSDConcreteComponent)this.fSelectedComponent, this.getNewDefaultName());
        command.run();
        doc.getModel().endRecording((Object)this);
    }
}

