/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.universal.miners.command.patterns;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rse.internal.dstore.universal.miners.command.patterns.ParsedOutput;

public class OutputPattern {
    private Pattern _pattern;
    private String _objType;
    private ArrayList _matchOrder;

    public OutputPattern(String objType, String matchOrder, Pattern thePattern) {
        this._objType = objType;
        this._pattern = thePattern;
        this._matchOrder = new ArrayList();
        this._matchOrder.add(null);
        int index = 0;
        int nextSpace = 0;
        while ((nextSpace = matchOrder.indexOf(" ", index)) > 0) {
            this._matchOrder.add(matchOrder.substring(index, nextSpace).toLowerCase());
            index = nextSpace;
            while (index < matchOrder.length() && matchOrder.charAt(index) == ' ') {
                ++index;
            }
        }
        this._matchOrder.add(matchOrder.substring(index, matchOrder.length()).toLowerCase());
    }

    public ParsedOutput matchLine(String theLine) {
        Matcher matcher = null;
        try {
            matcher = this._pattern.matcher(theLine);
            if (!matcher.matches()) {
                return null;
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
            return null;
        }
        String fileString = "";
        String lineString = "";
        int i = 1;
        while (i < this._matchOrder.size()) {
            String mStr = (String)this._matchOrder.get(i);
            if (mStr.equals("file")) {
                fileString = matcher.group(i);
            } else if (mStr.equals("line")) {
                lineString = matcher.group(i);
            }
            ++i;
        }
        int line = 1;
        if (lineString.length() > 0) {
            try {
                line = Integer.parseInt(lineString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return new ParsedOutput(this._objType, theLine, fileString, line, 1);
    }
}

