/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.objfac.util.Local;
import com.objfac.util.Misc;
import com.objfac.walker.EmptyWalker;
import com.objfac.walker.Entity;
import com.objfac.walker.IWalker;
import com.objfac.xml.XMLCharacter;
import com.thaiopensource.relaxng.impl.BooleanFunction;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DTDWalker;
import com.thaiopensource.relaxng.impl.EmptyPattern;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternPool;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.ValuePattern;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DTDWalkerFactory {
    private RefPattern fAny;
    private Entity fEnt;
    private String sysid;
    private String pubid;
    private DTDWalker walker;
    private char[] externalSubset;
    private char[] internalSubset;
    private ErrorHandler errorHandler;
    private EntityResolver entityResolver;
    private String dtdUrl;
    private String docUrl;
    private Pattern start;
    private PatternPool pool;
    private Context validationContext = new Context();
    private static final IWalker EMPTY_WALKER = new EmptyWalker();
    private boolean fInternal;
    private char[] fBuf;
    private int fBeg;
    private int fPos;
    private int fEnd;
    private int fLin;
    private HashMap fPEs;
    private LinkedList fStack;
    private String fValue;
    private String fString;
    private int fToken;
    private int fTokBeg;
    private int fTokEnd;
    private int fBad;
    private String fRefValue;
    private int fInclude = 0;
    private HashMap fElements;
    private static HashMap fPredef = new HashMap();
    private int fMal;
    private static final int MALMAX = 5;
    private int fNon;
    private static final int NONMAX = 5;
    private static final int BAD = 1;
    private static final int EOF = 2;
    private static final int LT = 4;
    private static final int GT = 8;
    private static final int QUESTION = 16;
    private static final int ID = 32;
    private static final int STRING = 64;
    private static final int COMMENT = 128;
    private static final int ENTITY = 256;
    private static final int ELEMENT = 512;
    private static final int ATTLIST = 1024;
    private static final int INCBEG = 2048;
    private static final int INCEND = 4096;
    private static final int LBRACKET = 8192;
    private static final int KEYWORD = 16384;
    private static final int LPAREN = 32768;
    private static final int RPAREN = 65536;
    private static final int COMMA = 131072;
    private static final int OR = 262144;
    private static final int STAR = 524288;
    private static final int PLUS = 0x100000;
    private static final int NM = 0x200000;
    private static final int RBRACKET = 0x400000;
    private static final int EQ = 0x800000;
    private static final int NOTATION = 0x1000000;
    private static final int PE = 0x2000000;
    private static char[] fOne;
    private static final String XML_STR = " <?xml";
    private static final int XML_LEN;
    private static final String VALUE_AFTER_EQ = "dtdparser_Value_required_after___24";
    private static char[] fCharArray;
    private boolean fIgnoreMissing = true;
    private boolean fEof;
    private String fNam;
    private static final int CHOICE = 0;
    private static final int SEQUENCE = 1;
    private static final int UNKNOWN = 2;
    public static final String TYPE_CDATA = "CDATA";
    public static final String TYPE_ID = "ID";
    public static final String TYPE_IDREF = "IDREF";
    public static final String TYPE_IDREFS = "IDREFS";
    public static final String TYPE_ENTITY = "ENTITY";
    public static final String TYPE_ENTITIES = "ENTITIES";
    public static final String TYPE_NMTOKEN = "NMTOKEN";
    public static final String TYPE_NMTOKENS = "NMTOKENS";
    public static final String TYPE_NOTATION = "NOTATION";
    public static final String TYPE_ENUMERATION = "ENUMERATION";
    private static final EnumFinder enumFinder;

    static {
        fPredef.put("&lt;", "&#60;");
        fPredef.put("&amp;", "&#38;");
        fPredef.put("&gt;", ">");
        fPredef.put("&quot;", "\"");
        fPredef.put("&apos;", "'");
        fOne = new char[1];
        XML_LEN = XML_STR.length();
        fCharArray = new char[1];
        enumFinder = new EnumFinder();
    }

    public static IWalker makeDtdWalker(char[] cArray, String string, char[] cArray2, String string2, String string3, EntityResolver entityResolver, ErrorHandler errorHandler) throws SAXException {
        DTDWalkerFactory dTDWalkerFactory = new DTDWalkerFactory(cArray, string, cArray2, string2, string3, entityResolver, errorHandler);
        return dTDWalkerFactory.generateWalker();
    }

    private DTDWalkerFactory(char[] cArray, String string, char[] cArray2, String string2, String string3, EntityResolver entityResolver, ErrorHandler errorHandler) {
        this.docUrl = string;
        this.pubid = string2;
        this.sysid = string3;
        this.entityResolver = entityResolver;
        this.errorHandler = errorHandler;
        this.internalSubset = cArray;
        this.externalSubset = cArray2;
        this.pool = new PatternPool();
        this.start = this.pool.makeNotAllowed();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IWalker generateWalker() throws SAXException {
        DTDWalker dTDWalker;
        block9: {
            try {
                IWalker iWalker;
                block8: {
                    try {
                        this.initMemory();
                        this.walker = null;
                        PatternPool patternPool = new PatternPool();
                        if (this.internalSubset != null) {
                            this.walker = new DTDWalker(patternPool);
                            this.parseInternal(this.internalSubset, 0, this.internalSubset.length);
                        }
                        if (this.externalSubset != null) {
                            if (this.walker == null) {
                                this.walker = new DTDWalker(patternPool);
                            }
                            this.parseExternal(this.externalSubset, 0, this.externalSubset.length);
                        }
                        if (this.walker == null) {
                            iWalker = EMPTY_WALKER;
                            Object var2_5 = null;
                            break block8;
                        }
                        this.fixupPatterns();
                        dTDWalker = this.walker;
                        break block9;
                    }
                    catch (WrapException wrapException) {
                        throw wrapException.getException();
                    }
                }
                this.freeMemory();
                return iWalker;
            }
            catch (Throwable throwable) {
                Object var2_7 = null;
                this.freeMemory();
                throw throwable;
            }
        }
        Object var2_6 = null;
        this.freeMemory();
        return dTDWalker;
    }

    private void initMemory() {
        this.fElements = new HashMap();
    }

    private void freeMemory() {
        this.fElements = null;
        this.fAny = null;
        this.fEnt = null;
        this.sysid = null;
        this.pubid = null;
        this.walker = null;
        this.externalSubset = null;
        this.internalSubset = null;
        this.errorHandler = null;
        this.entityResolver = null;
        this.dtdUrl = null;
        this.docUrl = null;
        this.start = null;
        this.pool = null;
    }

    public void parseInternal(char[] cArray, int n, int n2) {
        this.fInternal = true;
        this.fEnt = new Entity(null, this.docUrl);
        this.fEnt.setAbsUrl(this.docUrl);
        this.parse(cArray, n, n2);
    }

    public void parseExternal(char[] cArray, int n, int n2) {
        this.fInternal = false;
        this.fEnt = new Entity(this.pubid, this.sysid);
        this.fEnt.setAbsUrl(this.sysid);
        this.parse(cArray, n, n2);
    }

    public void setIgnoreMissingEntities(boolean bl) {
        this.fIgnoreMissing = bl;
    }

    public boolean ignoreMissingEntities() {
        return this.fIgnoreMissing;
    }

    private int nextToken() {
        int n;
        this.fToken = 1;
        while (true) {
            n = this.skipWS();
            this.fTokBeg = this.fTokEnd = this.fPos - 1;
            if (n < 0) {
                this.fTokBeg = this.fTokEnd = this.fPos;
                break;
            }
            if (n != 37 || this.fInternal) break;
            this.expandPE();
        }
        if (n < 0) {
            this.fToken = 2;
        } else {
            switch (XMLCharacter.charType((int)n)) {
                case 11: {
                    n = this.nextChar();
                    if (n == 33) {
                        n = this.nextChar();
                        if (n == 91) {
                            this.fValue = "<![";
                            this.fToken = 2048;
                            break;
                        }
                        this.pushChar();
                    }
                    this.pushChar();
                    this.fValue = "<";
                    this.fToken = 4;
                    break;
                }
                case 12: {
                    this.fValue = ">";
                    this.fToken = 8;
                    break;
                }
                case 8: {
                    this.fValue = "=";
                    this.fToken = 0x800000;
                    break;
                }
                case 19: {
                    this.fValue = "?";
                    this.fToken = 16;
                    break;
                }
                case 15: {
                    this.fValue = "(";
                    this.fToken = 32768;
                    break;
                }
                case 16: {
                    this.fValue = ")";
                    this.fToken = 65536;
                    break;
                }
                case 26: {
                    this.fValue = ",";
                    this.fToken = 131072;
                    break;
                }
                case 27: {
                    this.fValue = "|";
                    this.fToken = 262144;
                    break;
                }
                case 9: 
                case 10: {
                    DTDWalkerFactory.fOne[0] = (char)n;
                    this.fValue = new String(fOne);
                    this.collectString(n);
                    return 64;
                }
                case 14: {
                    n = this.nextChar();
                    if (n == 45) {
                        n = this.nextChar();
                        if (n == 45) {
                            this.scanComment();
                            this.fValue = "!--";
                            this.fToken = 128;
                            break;
                        }
                        this.pushChar();
                        break;
                    }
                    if (n == 91) {
                        this.fValue = "![";
                        this.fToken = 2048;
                        break;
                    }
                    if (XMLCharacter.isIDStart((char)((char)n))) {
                        this.fValue = this.collectId(n);
                        if (this.fValue.equals("ELEMENT")) {
                            this.fToken = 512;
                            break;
                        }
                        if (this.fValue.equals(TYPE_ENTITY)) {
                            this.fToken = 256;
                            break;
                        }
                        if (this.fValue.equals("ATTLIST")) {
                            this.fToken = 1024;
                            break;
                        }
                        if (!this.fValue.equals(TYPE_NOTATION)) break;
                        this.fToken = 0x1000000;
                        break;
                    }
                    this.pushChar();
                    break;
                }
                case 17: {
                    this.fValue = "[";
                    this.fToken = 8192;
                    break;
                }
                case 18: {
                    n = this.nextChar();
                    if (n == 93) {
                        n = this.nextChar();
                        if (n == 62) {
                            this.fValue = "]]>";
                            this.fToken = 4096;
                            break;
                        }
                        this.pushChar();
                    }
                    this.pushChar();
                    this.fValue = "]";
                    this.fToken = 0x400000;
                    break;
                }
                case 24: {
                    this.fValue = "*";
                    this.fToken = 524288;
                    break;
                }
                case 25: {
                    this.fValue = "+";
                    this.fToken = 0x100000;
                    break;
                }
                case 22: {
                    this.fValue = this.collectId(n);
                    this.fToken = 16384;
                    break;
                }
                case 23: {
                    this.fValue = this.parsePE();
                    if (this.fValue.length() <= 0) break;
                    this.fToken = 0x2000000;
                    break;
                }
                case 0: {
                    if (this.nextChar() < 0) {
                        this.malformedError(n);
                        this.pushChar();
                        break;
                    }
                    this.error("dtdparser_illegal_token_4", 0x100000 + n);
                    break;
                }
                case 2: {
                    this.malformedError(n);
                    break;
                }
                case 1: {
                    this.nonXmlError(n);
                    break;
                }
                case 6: {
                    this.fValue = this.collectId(n);
                    this.fToken = 32;
                    break;
                }
                case 7: {
                    this.fValue = this.collectId(n);
                    this.fToken = 0x200000;
                    break;
                }
                default: {
                    this.error("dtdparser_illegal_token_5");
                }
            }
        }
        this.fTokEnd = this.fPos;
        return this.fToken;
    }

    private boolean getContents(Entity entity, StringBuffer stringBuffer) {
        String string = entity.getAbsUrl();
        if (string == null && entity.getSysid() != null) {
            string = Misc.getAbsUrl((String)this.fEnt.getAbsUrl(), (String)entity.getSysid());
        }
        InputSource inputSource = null;
        try {
            inputSource = this.entityResolver.resolveEntity(entity.getPubid(), string);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        if (inputSource == null) {
            if (!this.fIgnoreMissing) {
                this.error("dtdparser_Entity_not_found_at_{0}_19", this.sysid);
            }
            return false;
        }
        String string2 = inputSource.getSystemId();
        try {
            if (!this.isRecursive(string2)) {
                Reader reader = inputSource.getCharacterStream();
                if (reader == null) {
                    return false;
                }
                Misc.readContents((Reader)reader, (StringBuffer)stringBuffer);
                entity.setAbsUrl(string2);
                return true;
            }
        }
        catch (IOException iOException) {
            this.error("Error reading entity {0} [{1}]", string2, iOException.toString());
        }
        return false;
    }

    private boolean isRecursive(String string) {
        if (this.fStack == null) {
            return false;
        }
        Iterator iterator = this.fStack.iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            if (!Misc.equalUrls((String)string, (String)entry.fEnt.getAbsUrl())) continue;
            return true;
        }
        return false;
    }

    private void parse(char[] cArray, int n, int n2) {
        this.fBuf = cArray;
        this.fBeg = this.fPos = n;
        this.fEnd = n2;
        this.fLin = 1;
        this.fNon = -1;
        this.fMal = -1;
        this.fPEs = new HashMap();
        this.fStack = new LinkedList();
        this.parse();
        this.fPEs = null;
        this.fBuf = null;
        this.fStack = null;
    }

    private void fixupPatterns() {
        Iterator iterator = this.fElements.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String string = (String)entry.getKey();
            Element element = (Element)entry.getValue();
            Pattern pattern = this.pool.makeGroup(element.attributes, element.elements);
            Pattern pattern2 = this.pool.makeElement(this.pool.makeName("", string), pattern);
            element.ref.setPattern(pattern2);
            this.start = this.pool.makeChoice(this.start, element.ref);
        }
        this.anyContent().setPattern(this.start);
        this.walker.setStartPattern(this.start);
    }

    private void parse() {
        if (!this.fInternal && this.fEnd - this.fPos >= "<?xml".length() && this.fBuf[this.fPos] == '<' && this.fBuf[this.fPos + 1] == '?' && this.fBuf[this.fPos + 2] == 'x' && this.fBuf[this.fPos + 3] == 'm' && this.fBuf[this.fPos + 4] == 'l') {
            this.fPos += XML_LEN;
            this.parseXML(false);
        }
        while (true) {
            boolean bl;
            if (Thread.currentThread().isInterrupted()) {
                throw new WrapException(new SAXException(Local.getString((String)"parser interrupted")));
            }
            int n = this.nextToken();
            if (n == 2) break;
            switch (n) {
                case 4: {
                    bl = this.parseTag();
                    break;
                }
                case 2048: {
                    bl = this.beginInclude();
                    break;
                }
                case 4096: {
                    bl = this.endInclude();
                    break;
                }
                case 0x2000000: {
                    bl = this.expandStmtPE();
                    break;
                }
                default: {
                    bl = this.invalidToken(n);
                }
            }
            if (bl) continue;
            this.skipToLT();
        }
    }

    private int nextChar() {
        this.fEof = false;
        while (true) {
            if (this.fPos < this.fEnd) {
                char c;
                if ((c = this.fBuf[this.fPos++]) == '\n' || c == '\r' && this.fPos < this.fEnd && this.fBuf[this.fPos] != '\n') {
                    ++this.fLin;
                }
                return c;
            }
            if (this.fStack.size() <= 0) break;
            this.popPE();
        }
        this.fEof = true;
        return -1;
    }

    private void pushChar() {
        if (this.fPos == this.fBeg) {
            throw new IllegalStateException("dtdparser_internal_pushChar()_before_start_7");
        }
        if (!this.fEof && this.fBuf[--this.fPos] == '\n') {
            --this.fLin;
        }
    }

    private String collectId(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append((char)n);
        } while (XMLCharacter.isIDPart((char)((char)(n = this.nextChar()))));
        this.pushChar();
        return stringBuffer.toString();
    }

    private String collectId() {
        int n = this.nextChar();
        if (XMLCharacter.isIDStart((char)((char)n))) {
            return this.collectId(n);
        }
        this.pushChar();
        return "";
    }

    private String parsePE() {
        String string = this.collectId();
        if (string.length() == 0) {
            this.error("dtdparser_pe_name_expected_9");
        } else {
            int n = this.nextChar();
            if (n != 59) {
                this.error("dtdparser_;_expected_after_pe_name_10");
                string = "";
                this.pushChar();
            }
        }
        return string;
    }

    private void collectString(int n) {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if (!this.goodChar(n)) continue;
            stringBuffer.append((char)n);
        } while ((n = this.nextChar()) >= 0 && n != n2);
        if (n < 0) {
            this.fValue = stringBuffer.toString();
            if (stringBuffer.length() > 0) {
                stringBuffer.deleteCharAt(0);
            }
            this.fString = stringBuffer.toString();
        } else {
            stringBuffer.append((char)n);
            this.fValue = stringBuffer.toString();
            stringBuffer.deleteCharAt(0);
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            this.fString = stringBuffer.toString();
        }
    }

    private boolean scanComment() {
        block4: {
            while (true) {
                int n;
                if (this.goodChar(n = this.nextChar())) {
                    if (n != 45) continue;
                    n = this.nextChar();
                    if (n == 45) {
                        n = this.nextChar();
                        if (n != 62) {
                            return this.error("dtdparser_--_not_fol_by_>_12");
                        }
                        break block4;
                    }
                    this.pushChar();
                    continue;
                }
                if (n < 0) break;
            }
            return this.error("dtdparser_unterminated_comment_13");
        }
        return true;
    }

    private boolean error(String string) {
        return this.internalError(Local.getString((String)string));
    }

    private boolean error(String string, int n) {
        return this.internalError(Local.format((String)string, (int)n));
    }

    private boolean error(String string, String string2) {
        return this.internalError(Local.format((String)string, (Object)string2));
    }

    private boolean error(String string, String string2, String string3) {
        return this.internalError(Local.format((String)string, (Object)string2, (Object)string3));
    }

    private boolean internalError(String string) {
        int n;
        int n2;
        this.fEnt.getAbsUrl();
        Entity entity = this.fEnt;
        int n3 = this.fPos;
        int n4 = this.fBeg;
        int n5 = this.fEnd;
        char[] cArray = this.fBuf;
        if (this.fStack != null) {
            Entry[] entryArray = this.fStack.toArray(new Entry[this.fStack.size()]);
            n = n2 = entryArray.length;
            int n6 = entryArray.length - 1;
            while (n6 >= 0) {
                if (entryArray[n6].fEnt != entity) {
                    n = n6 + 1;
                    break;
                }
                --n6;
            }
            if (n != n2) {
                Entry entry = entryArray[n];
                entity = entry.fEnt;
                cArray = entry.fBuf;
                n3 = entry.fPos;
                n4 = entry.fBeg;
                n5 = entry.fEnd;
            }
        } else if (this.fEnt == null) {
            try {
                this.errorHandler.error(new SAXParseException(string, "", "", -1, -1));
            }
            catch (SAXException sAXException) {
                throw new WrapException(sAXException);
            }
            return false;
        }
        int n7 = 1;
        n2 = n4;
        n = 0;
        while (n < n5 && n < n3) {
            if (cArray[n] == '\n') {
                ++n7;
                n2 = n + 1;
            }
            ++n;
        }
        try {
            this.errorHandler.error(new SAXParseException(string, entity.getPubid(), entity.getAbsUrl(), n7, n3 - n2));
        }
        catch (SAXException sAXException) {
            throw new WrapException(sAXException);
        }
        return false;
    }

    private boolean malformedError(int n) {
        if (++this.fMal <= 5) {
            if (this.fMal == 5) {
                return this.error("dtdparser_too_many_malformed_characters_17");
            }
            return this.error("dtdparser_malformed_character_{0}_18", "[" + Integer.toHexString(n) + "]");
        }
        return false;
    }

    private boolean nonXmlError(int n) {
        if (++this.fNon <= 5) {
            if (this.fNon == 5) {
                return this.error("dtdparser_too_many_non-XML_characters_21");
            }
            return this.error("dtdparser_non-XML_character_{0}_22", "[" + Integer.toHexString(n) + "]");
        }
        return false;
    }

    private boolean goodChar(int n) {
        switch (XMLCharacter.charType((int)n)) {
            case 2: {
                return this.malformedError(n);
            }
            case 1: {
                return this.nonXmlError(n);
            }
            case 0: {
                if (this.nextChar() >= 0) break;
                this.malformedError(n);
                this.pushChar();
                return false;
            }
        }
        return true;
    }

    private void pushPE(String string, Object object) {
        char[] cArray;
        Entity entity = this.fEnt;
        StringBuffer stringBuffer = null;
        if (object instanceof Entity) {
            entity = (Entity)object;
            stringBuffer = new StringBuffer();
            stringBuffer.append(' ');
            if (!this.getContents(entity, stringBuffer)) {
                return;
            }
            stringBuffer.append(' ');
            cArray = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray, 0);
        } else {
            cArray = (" " + (String)object + ' ').toCharArray();
        }
        Entry entry = new Entry();
        entry.fBuf = this.fBuf;
        entry.fPos = this.fPos;
        entry.fBeg = this.fBeg;
        entry.fEnd = this.fEnd;
        entry.fLin = this.fLin;
        entry.fEnt = this.fEnt;
        entry.fNam = this.fNam;
        this.fStack.addLast(entry);
        this.fBuf = cArray;
        this.fBeg = 0;
        this.fPos = 0;
        this.fEnd = this.fBuf.length;
        this.fEnt = entity;
        this.fNam = string;
        if (stringBuffer != null && stringBuffer.length() >= XML_LEN && stringBuffer.substring(0, XML_LEN).equals(XML_STR)) {
            this.fPos = XML_LEN;
            this.parseXML(true);
            this.fBuf[--this.fPos] = 32;
        }
    }

    private boolean parseXML(boolean bl) {
        int n = this.nextToken();
        if (n != 32) {
            return this.error("dtdparser_Expecting_version_or_encoding_in_xml_decl,_found_{0}_25", this.fValue);
        }
        if (this.fValue.equals("version")) {
            if (this.nextToken() != 0x800000) {
                return this.error("dtdparser_Expecting___after_version_27");
            }
            if (this.nextToken() != 64) {
                return this.error(VALUE_AFTER_EQ);
            }
            if (!this.fString.equals("1.0")) {
                return this.error("dtdparser_Version_must_be_1.0_29");
            }
            n = this.nextToken();
        } else if (!bl) {
            return this.error("dtdparser_version_is_required_in_xml_decl_30");
        }
        if (n == 32 && this.fValue.equals("encoding")) {
            if (this.nextToken() != 0x800000) {
                return this.error("dtdparser_Expecting___after_encoding_32");
            }
            if (this.nextToken() != 64) {
                return this.error(VALUE_AFTER_EQ);
            }
            n = this.nextToken();
        } else if (bl) {
            this.error("dtdparser_Missing_required_encoding_param_33");
        }
        if (n == 32 && this.fValue.equals("standalone")) {
            if (bl) {
                this.error("dtdparser_standalone_not_permitted_in_external_entity_35");
            }
            if (this.nextToken() != 0x800000) {
                return this.error("dtdparser_Expecting___after_standalone_36");
            }
            if (this.nextToken() != 64) {
                return this.error(VALUE_AFTER_EQ);
            }
            if (!this.fString.equals("yes") && !this.fString.equals("no")) {
                return this.error("dtdparser_standalone_value_must_be_yes_or_no_39");
            }
            this.nextToken();
        }
        if (n != 16) {
            return this.error("dtdparser__>_required_at_end_of_xml_decl_40");
        }
        this.noWS("dtdparser_no_space_allowed_between___and_>_41");
        return this.parseEndTag();
    }

    private void popPE() {
        Entry entry = (Entry)this.fStack.removeLast();
        this.fBuf = entry.fBuf;
        this.fPos = entry.fPos;
        this.fBeg = entry.fBeg;
        this.fEnd = entry.fEnd;
        this.fLin = entry.fLin;
        this.fEnt = entry.fEnt;
        this.fNam = entry.fNam;
    }

    private void skipToLT() {
        int n;
        while ((n = this.nextToken()) != 2 && n != 4) {
        }
        this.pushToken();
    }

    private boolean parseTag() {
        int n = this.nextToken();
        switch (n) {
            case 128: {
                return true;
            }
            case 256: {
                return this.parseEntity();
            }
            case 512: {
                return this.parseElement();
            }
            case 1024: {
                return this.parseAttlist();
            }
            case 0x1000000: {
                return this.parseNotation();
            }
            case 16: {
                return this.parsePI();
            }
        }
        return this.error("dtdparser_expect_tag_begin_26");
    }

    private boolean parsePI() {
        if (!(this.fPos + 2 >= this.fEnd || this.fBuf[this.fPos] != 'x' && this.fBuf[this.fPos] != 'X' || this.fBuf[this.fPos + 1] != 'm' && this.fBuf[this.fPos + 1] != 'M' || this.fBuf[this.fPos + 2] != 'l' && this.fBuf[this.fPos + 2] != 'L')) {
            return this.error("xml may not be used as target of PI");
        }
        this.noWS("S after <?");
        int n = this.nextToken();
        if (n != 32) {
            return this.error("no PI target after <?");
        }
        this.requireWS("no S after PI target");
        while (this.fPos < this.fEnd && XMLCharacter.isWhitespace((char)this.fBuf[this.fPos])) {
            ++this.fPos;
        }
        while (this.fPos < this.fEnd) {
            if (this.fBuf[this.fPos] == '?' && this.fPos + 1 < this.fEnd && this.fBuf[this.fPos + 1] == '>') {
                ++this.fPos;
                break;
            }
            ++this.fPos;
        }
        if (this.fPos == this.fEnd) {
            return this.error("EOF in PI looking for ?>");
        }
        return this.parseEndTag();
    }

    private boolean parseNotation() {
        boolean bl;
        int n = this.nextToken();
        if (n != 32) {
            return this.error("dtdparser_expect_notation_name_1");
        }
        String string = this.fValue;
        this.requireWS("dtdparser_S_after_notation_name_2");
        n = this.nextToken();
        boolean bl2 = n == 32 && this.fValue.equals("PUBLIC");
        boolean bl3 = bl = n == 32 && this.fValue.equals("SYSTEM");
        if (!bl2 && !bl) {
            return this.error("dtdparser_require_PUBLIC_or_SYSTEM_after_notation_name_3");
        }
        String string2 = null;
        String string3 = null;
        if (bl2) {
            if (this.nextToken() != 64) {
                return this.error("dtdparser_PUBLIC_must_be_followed_by_public_id_4");
            }
            string2 = this.fString;
            if (this.nextToken() == 64) {
                string3 = this.fString;
            } else {
                this.pushToken();
            }
        } else {
            if (this.nextToken() != 64) {
                return this.error("dtdparser_SYSTEM_must_be_followed_by_system_id_5");
            }
            string3 = this.fString;
        }
        if (this.walker.addNotation(string, new Entity(string2, string3))) {
            return this.error("dtdparser_notation_{0}_already_defined_6", string);
        }
        return this.parseEndTag();
    }

    private boolean parseEntity() {
        boolean bl;
        int n = this.skipWS();
        boolean bl2 = bl = n == 37;
        if (!bl) {
            this.pushChar();
        } else {
            this.requireWS("dtdparser_S_after_%_27");
        }
        int n2 = this.nextToken();
        if (n2 != 32) {
            return this.error("dtdparser_expect_entity_name_28");
        }
        String string = this.fValue;
        this.requireWS("dtdparser_S_after_entity_name_29");
        n2 = this.nextToken();
        if (n2 == 64) {
            if (bl) {
                this.walker.addPE(string, this.peValue());
            } else {
                this.walker.addGE(string, this.geValue());
            }
        } else if (n2 == 32) {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (this.fValue.equals("PUBLIC")) {
                this.requireWS("dtdparser_S_after_PUBLIC_31");
                n2 = this.nextToken();
                if (n2 != 64) {
                    return this.error("dtdparser_expect_string_after_PUBLIC_32");
                }
                string2 = this.fString;
                this.requireWS("dtdparser_S_after_public_id_33");
                n2 = this.nextToken();
                if (n2 != 64) {
                    return this.error("dtdparser_expect_system_id_after_public_id_34");
                }
                string3 = this.fString;
            } else if (this.fValue.equals("SYSTEM")) {
                this.requireWS("dtdparser_S_after_SYSTEM_36");
                n2 = this.nextToken();
                if (n2 != 64) {
                    return this.error("dtdparser_expect_string_after_SYSTEM_37");
                }
                string3 = this.fString;
            } else {
                return this.error("dtdparser_expect_PUBLIC_or_SYSTEM_38");
            }
            if (!bl) {
                boolean bl3 = this.peekWS();
                n2 = this.nextToken();
                if (n2 == 32 && this.fValue.equals("NDATA")) {
                    if (!bl3) {
                        this.error("dtdparser_S_after_id_string_40");
                    }
                    if ((n2 = this.nextToken()) != 64) {
                        return this.error("dtdparser_expect_string_after_NDATA_41");
                    }
                    string4 = this.fString;
                } else {
                    this.pushToken();
                }
            }
            if (bl) {
                this.walker.addPE(string, new Entity(string2, string3));
            } else {
                this.walker.addGE(string, new Entity(string2, string3, string4));
            }
        } else {
            return this.error("dtdparser_expect_entity_def_42");
        }
        return this.parseEndTag();
    }

    private boolean parseEndTag() {
        int n = this.nextToken();
        if (n == 8) {
            return true;
        }
        if (n == 4 || n == 2) {
            this.pushToken();
        }
        return this.error("dtdparser_expect_end_of_tag_43");
    }

    private void pushToken() {
        this.fPos = this.fTokBeg;
    }

    private String peValue() {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = this.fString.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            char c = cArray[n];
            if (c == '%') {
                n = this.paramRef(cArray, n, n2);
                stringBuffer.append(this.fRefValue);
            } else if (c == '&') {
                n = this.charRef(cArray, n, n2);
                stringBuffer.append(this.fRefValue);
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private int paramRef(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        ++n;
        while (n < n2 && cArray[n] != ';') {
            stringBuffer.append(cArray[n++]);
        }
        String string = stringBuffer.toString();
        if (n == n2) {
            this.error("dtdparser_undefined_param_ref_%{0};_44", string);
            this.fRefValue = "";
        } else {
            this.fRefValue = this.getPEContents(string);
        }
        return n;
    }

    private String getPEContents(String string) {
        Object object = this.walker.getPE(string);
        if (object instanceof Entity) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.getContents((Entity)object, stringBuffer)) {
                this.error("dtdparser_error_getting_value_of_%{0};_-_{1}_46", string, this.fEnt.getAbsUrl());
                return "";
            }
            return stringBuffer.toString();
        }
        return (String)object;
    }

    /*
     * Unable to fully structure code
     */
    private int charRef(char[] var1_1, int var2_2, int var3_3) {
        block12: {
            block14: {
                block15: {
                    block17: {
                        block16: {
                            block13: {
                                var4_4 = var2_2++;
                                var5_5 = 0;
                                var6_6 = true;
                                var7_7 = false;
                                if (var2_2 != var3_3) break block13;
                                var6_6 = this.error("dtdparser_incomplete_entity_reference_{0}_11", new String(var1_1, var4_4, var2_2 - var4_4));
                                break block12;
                            }
                            if ((var8_8 = var1_1[var2_2++]) != 35) break block14;
                            var7_7 = true;
                            if (var2_2 >= var3_3) break block15;
                            if ((var8_8 = var1_1[var2_2++]) == 120 || var8_8 >= 48 || var8_8 <= 57) break block16;
                            var2_2 = this.collect(var4_4, var1_1, var2_2, var3_3);
                            var6_6 = false;
                            break block12;
                        }
                        if (var8_8 != 120) break block17;
                        while (var2_2 < var3_3) {
                            block20: {
                                block19: {
                                    block18: {
                                        var8_8 = var1_1[var2_2];
                                        var9_9 = 0;
                                        if (48 > var8_8 || var8_8 > 57) break block18;
                                        var9_9 = var8_8 - 48;
                                        ** GOTO lbl-1000
                                    }
                                    if (97 > var8_8 || var8_8 > 102) break block19;
                                    var9_9 = var8_8 - 97 + 10;
                                    ** GOTO lbl-1000
                                }
                                if (65 > var8_8 || var8_8 > 70) break block20;
                                var9_9 = var8_8 - 65 + 10;
                                ** GOTO lbl-1000
                            }
                            if (var8_8 != 59) {
                                ++var2_2;
                                var2_2 = this.collect(var4_4, var1_1, var2_2, var3_3);
                                var6_6 = false;
                            } else if (var8_8 != 59) {
                                var5_5 = var5_5 * 16 + var9_9;
                                ++var2_2;
                                continue;
                            }
                            break block12;
                        }
                        break block12;
                    }
                    var5_5 = var8_8 - 48;
                    while (var2_2 < var3_3) {
                        var8_8 = var1_1[var2_2];
                        if (var8_8 != 59 && (var8_8 < 48 || var8_8 > 57)) {
                            ++var2_2;
                            var2_2 = this.collect(var4_4, var1_1, var2_2, var3_3);
                            var6_6 = false;
                        } else if (var8_8 != 59) {
                            var5_5 = var5_5 * 10 + var8_8 - 48;
                            ++var2_2;
                            continue;
                        }
                        break block12;
                    }
                    break block12;
                }
                var2_2 = this.collect(var4_4, var1_1, var2_2, var3_3);
                var6_6 = false;
                break block12;
            }
            var2_2 = this.collect(var4_4, var1_1, var2_2, var3_3);
        }
        var8_8 = var2_2 - (var2_2 == var3_3 ? var4_4 : var4_4 - 1);
        if (var6_6) {
            if (var7_7) {
                DTDWalkerFactory.fCharArray[0] = (char)var5_5;
                this.fRefValue = new String(DTDWalkerFactory.fCharArray);
            } else {
                this.fRefValue = new String(var1_1, var4_4, var8_8);
            }
        } else {
            this.fRefValue = new String(var1_1, var4_4, var8_8);
            this.error("dtdparser_ill-formed_numeric_character_reference_{0}_12", this.fRefValue);
        }
        return var2_2;
    }

    private int collect(int n, char[] cArray, int n2, int n3) {
        while (n2 < n3) {
            if (cArray[n2] == ';') break;
            ++n2;
        }
        if (n2 == n3) {
            this.error("dtdparser_incomplete_entity_ref_{0}_13", new String(cArray, n, n2 - n));
        }
        return n2;
    }

    private String geValue() {
        return this.peValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseElement() {
        int n = this.nextToken();
        if (n != 32) {
            return this.error("dtdparser_expect_element_name_50");
        }
        String string = this.fValue;
        Element element = this.getElement(string);
        if (!element.undefined) {
            return this.error("dtdparser_element_{0}_already_declared_51", string);
        }
        element.undefined = false;
        this.requireWS("dtdparser_S_after_element_name_52");
        n = this.nextToken();
        if (n == 32) {
            boolean bl = this.fValue.equals("ANY");
            boolean bl2 = this.fValue.equals("EMPTY");
            if (!bl && !bl2) {
                return this.error("dtdparser_expect_ANY_or_EMPTY_55");
            }
            element.elements = bl ? this.anyContent() : this.pool.makeEmpty();
            return this.parseEndTag();
        } else if (n == 32768) {
            boolean bl = false;
            boolean bl3 = false;
            n = this.nextToken();
            if (n == 16384 && this.fValue.equals("#PCDATA")) {
                bl = true;
                n = this.nextToken();
                if (n == 65536) {
                    n = this.nextToken();
                    if (n != 524288) {
                        this.pushToken();
                    }
                    bl3 = true;
                } else if (n != 262144) {
                    return this.error("dtdparser_expect_)_or_|_after__#PCDATA_58");
                }
            } else {
                this.pushToken();
            }
            if (bl) {
                element.elements = this.pool.makeText();
            }
            if (bl3) return this.parseEndTag();
            Pattern[] patternArray = new Pattern[]{element.elements};
            if (!this.parseModel(patternArray, bl, bl ? 0 : 2)) return false;
            if (bl && !this.isZeroOrMore(patternArray[0])) {
                return this.error("dtdparser_mixed_model_must_use_*_59");
            }
            element.elements = bl ? this.pool.makeMixed(patternArray[0]) : patternArray[0];
            return this.parseEndTag();
        } else {
            this.error("dtdparser_expect_ANY,_EMPTY_or_(_60");
        }
        return this.parseEndTag();
    }

    private boolean isZeroOrMore(Pattern pattern) {
        if (pattern != null && pattern instanceof ChoicePattern && ((ChoicePattern)pattern).p1 instanceof OneOrMorePattern && ((ChoicePattern)pattern).p2 instanceof EmptyPattern) {
            return true;
        }
        return pattern != null && pattern instanceof OneOrMorePattern && ((OneOrMorePattern)pattern).getOperand().isNullable();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseModel(Pattern[] patternArray, boolean bl, int n) {
        HashSet<String> hashSet;
        int n2 = this.nextToken();
        HashSet<String> hashSet2 = hashSet = bl ? new HashSet<String>() : null;
        do {
            Pattern pattern;
            Pattern[] patternArray2;
            if (n2 == 32) {
                if (bl) {
                    if (hashSet.contains(this.fValue)) {
                        return this.error("dtdparser_duplicate_type_{0}_in_mixed_model_1", this.fValue);
                    }
                    hashSet.add(this.fValue);
                }
                patternArray2 = this.getElement(this.fValue);
                pattern = this.parseQualifier(patternArray2.ref);
            } else {
                if (n2 != 32768) return this.error("dtdparser_expect_id_or_(_in_model_62");
                if (bl) {
                    return this.error("dtdparser_mixed_model_can__t_have_submodels_61");
                }
                patternArray2 = new Pattern[]{this.pool.makeNotAllowed()};
                if (!this.parseModel(patternArray2, false, 2)) return false;
                pattern = patternArray2[0];
            }
            patternArray[0] = patternArray[0].isNotAllowed() ? pattern : (n == 0 ? this.pool.makeChoice(patternArray[0], pattern) : (patternArray[0].isNotAllowed() ? pattern : this.pool.makeGroup(patternArray[0], pattern)));
            n2 = this.nextToken();
            if (n2 == 262144 || n2 == 131072) {
                int n3;
                int n4 = n3 = n2 == 262144 ? 0 : 1;
                if (n != 2 && n != n3) {
                    return this.error("dtdparser_unlike_operators_in_model_63");
                }
                n = n3;
                n2 = this.nextToken();
                continue;
            }
            if (n2 == 65536) continue;
            return this.error("dtdparser_model_operator_not_|_or_,_-_found_{0}_64", this.fValue);
        } while (n2 != 65536);
        patternArray[0] = this.parseQualifier(patternArray[0]);
        return true;
    }

    public Pattern parseQualifier(Pattern pattern) {
        int n = this.nextToken();
        if (n == 524288) {
            return this.pool.makeZeroOrMore(pattern);
        }
        if (n == 0x100000) {
            return this.pool.makeOneOrMore(pattern);
        }
        if (n == 16) {
            return this.pool.makeOptional(pattern);
        }
        this.pushToken();
        return pattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean parseAttlist() {
        int n = this.nextToken();
        if (n != 32) {
            return this.error("dtdparser_expect_element_name_in_attlist_65");
        }
        Element element = this.getElement(this.fValue);
        while (true) {
            Pattern pattern;
            boolean bl = this.peekWS();
            Pattern pattern2 = null;
            String string = null;
            boolean bl2 = false;
            n = this.nextToken();
            if (n == 8) {
                this.pushToken();
                return this.parseEndTag();
            }
            if (!bl) {
                this.error("dtdparser_S_before_AttDef_66");
            }
            if (n != 32) {
                if (n != 8) return this.error("dtdparser_expect_attr_name_or_>_67");
                this.pushToken();
                return this.parseEndTag();
            }
            String string2 = this.fValue;
            n = this.nextToken();
            if (n == 32768) {
                pattern = this.pool.makeNotAllowed();
                string = TYPE_ENUMERATION;
                do {
                    if ((n = this.nextToken()) != 32 && n != 0x200000) {
                        return this.error("dtdparser_expect_enumeration_NMTOKEN_68");
                    }
                    pattern = this.pool.makeChoice(pattern, this.createValue(string, this.fValue));
                } while ((n = this.nextToken()) == 262144);
                if (n != 65536) {
                    this.error("dtdparser_expect_|_or_)_after_enum_item_1");
                }
                if (pattern.isNotAllowed()) {
                    this.error("dtdparser_empty_enumeration_70");
                }
                pattern2 = pattern;
            } else {
                if (n != 32) return this.error("dtdparser_expect_attr_type_85");
                if (this.fValue.equals(TYPE_NOTATION)) {
                    this.requireWS("dtdparser_S_after_NOTATION_72");
                    if (this.nextToken() != 32768) {
                        return this.error("expect ( after NOTATION");
                    }
                    pattern = this.pool.makeNotAllowed();
                    string = TYPE_NOTATION;
                    do {
                        if ((n = this.nextToken()) != 32) {
                            return this.error("dtdparser_expect_notation_Name_73");
                        }
                        if (this.walker.getNotation(this.fValue) == null) {
                            return this.error("undefined notation name {0}", this.fValue);
                        }
                        pattern = this.pool.makeChoice(pattern, this.createValue(string, this.fValue));
                    } while ((n = this.nextToken()) == 262144);
                    if (n != 65536) {
                        this.error("dtdparser_expect_,_or_)_after_enum_item_74");
                    }
                    if (pattern.isNotAllowed()) {
                        this.error("dtdparser_empty_enumeration_75");
                    }
                    pattern2 = pattern;
                } else {
                    if (!this.fValue.equals(TYPE_CDATA) && !this.fValue.equals(TYPE_ID) && !this.fValue.equals(TYPE_IDREF) && !this.fValue.equals(TYPE_IDREFS) && !this.fValue.equals(TYPE_ENTITY) && !this.fValue.equals(TYPE_ENTITIES) && !this.fValue.equals(TYPE_NMTOKEN) && !this.fValue.equals(TYPE_NMTOKENS)) return this.error("dtdparser_expect_NOTATION_or_attr_type_name_84");
                    string = this.fValue;
                    pattern2 = this.createData(string);
                }
            }
            n = this.nextToken();
            if (n == 16384) {
                if (this.fValue.equals("#IMPLIED")) {
                    bl2 = true;
                } else if (this.fValue.equals("#FIXED")) {
                    this.requireWS("dtdparser_S_after_FIXED_90");
                    n = this.nextToken();
                    if (n != 64) {
                        return this.error("dtdparser_expect_fixed_value_string_91");
                    }
                    pattern2 = this.createValue(string, this.fString);
                    bl2 = true;
                } else if (!this.fValue.equals("#REQUIRED")) {
                    return this.error("dtdparser_unrecognized_keyword_88");
                }
            } else {
                if (n != 64) return this.error("dtdparser_expect__#REQUIRED,__#IMPLIED,_FIXED_or_default_92");
                if (!this.consistentValue(string, pattern2, this.fString)) {
                    return this.error("Default \"{0}\" is not consistent with type", this.fString);
                }
                pattern2 = this.pool.makeChoice(this.createValue(string, this.fString), pattern2);
                bl2 = true;
            }
            pattern = this.pool.makeAttribute("", string2, pattern2);
            if (bl2) {
                pattern = this.pool.makeOptional(pattern);
            }
            element.addAttribute(string2, pattern);
        }
    }

    private boolean consistentValue(String string, Pattern pattern, String string2) {
        if (string.equals(TYPE_ENUMERATION)) {
            return enumFinder.found(string2, pattern);
        }
        if (pattern instanceof Datatype) {
            return ((Datatype)((Object)pattern)).isValid(string2, this.validationContext);
        }
        return true;
    }

    private Element getElement(String string) {
        Element element = (Element)this.fElements.get(string);
        if (element == null) {
            element = new Element(string);
            this.fElements.put(string, element);
        }
        return element;
    }

    private boolean beginInclude() {
        int n = this.nextToken();
        if (n != 32 || !this.fValue.equals("INCLUDE") && !this.fValue.equals("IGNORE")) {
            return this.error("dtdparser_expect_INCLUDE_or_IGNORE_95");
        }
        String string = this.fValue;
        n = this.nextToken();
        if (n != 8192) {
            return this.error("dtdparser_expect_[_after_INCLUDE_or_IGNORE_96");
        }
        if (string.equals("INCLUDE")) {
            ++this.fInclude;
        } else {
            int n2 = 0;
            int n3 = this.fEnd - 2;
            int n4 = this.fPos;
            while (n4 < n3) {
                if (this.fBuf[n4] == '<' && this.fBuf[n4 + 1] == '!' && this.fBuf[n4 + 2] == '[') {
                    ++n2;
                } else if (this.fBuf[n4] == ']' && this.fBuf[n4 + 1] == ']' && this.fBuf[n4 + 2] == '>' && n2-- == 0) break;
                ++n4;
            }
            if (n4 == n3) {
                this.fPos = this.fEnd;
                return this.error("no matching ]]> for ignore");
            }
            this.fPos = n4 + 3;
        }
        return true;
    }

    private boolean endInclude() {
        if (this.fInclude == 0) {
            return this.error("dtdparser_unbalanced_]]>_98");
        }
        --this.fInclude;
        return true;
    }

    private boolean invalidToken(int n) {
        return this.error("dtdparser_invalid_token_99");
    }

    private boolean expandPE() {
        String string = this.parsePE();
        if (string.length() == 0) {
            return false;
        }
        return this.expandPE(string);
    }

    private boolean expandStmtPE() {
        return this.expandPE(this.fValue);
    }

    private boolean expandPE(String string) {
        try {
            Object object = this.walker.getPE(string);
            if (object == null) {
                return this.error("dtdparser_undef_parameter_entity_%{0};_100", string);
            }
            this.pushPE(string, object);
        }
        catch (Exception exception) {
            this.error("dtdparser_Error_getting_value_of_%{0};_-_{1}_101", string, exception.toString());
        }
        return true;
    }

    private int skipWS() {
        int n;
        while ((n = this.nextChar()) >= 0 && XMLCharacter.isWhitespace((int)n)) {
        }
        return n;
    }

    private void requireWS(String string) {
        int n = this.nextChar();
        if (!XMLCharacter.isWhitespace((int)n)) {
            this.error(string);
        }
        this.pushChar();
    }

    private void noWS(String string) {
        int n = this.nextChar();
        if (XMLCharacter.isWhitespace((int)n)) {
            this.error(string);
        }
        this.pushChar();
    }

    private boolean peekWS() {
        int n = this.nextChar();
        boolean bl = XMLCharacter.isWhitespace((int)n);
        this.pushChar();
        return bl;
    }

    public Datatype createDatatype(String string) {
        try {
            if (TYPE_CDATA.equals(string)) {
                return this.pool.makeStringDatatype();
            }
            if (TYPE_ENUMERATION.equals(string)) {
                return this.pool.makeTokenDatatype();
            }
            return this.pool.makeDatatypeMaker("http://www.w3.org/2001/XMLSchema-datatypes", string).createDatatype();
        }
        catch (DatatypeException datatypeException) {
            datatypeException.printStackTrace();
            throw new InternalError();
        }
    }

    private Pattern createData(String string) {
        Datatype datatype = this.createDatatype(string);
        return this.pool.makeData(datatype);
    }

    private Pattern createValue(String string, String string2) {
        Datatype datatype = this.createDatatype(string);
        return this.pool.makeValue(datatype, string2);
    }

    private RefPattern anyContent() {
        if (this.fAny == null) {
            this.fAny = this.pool.makeRef("ANY");
        }
        return this.fAny;
    }

    private static class WrapException
    extends RuntimeException {
        private SAXException e;

        public WrapException(SAXException sAXException) {
            this.e = sAXException;
        }

        public SAXException getException() {
            return this.e;
        }
    }

    private class Element {
        private HashSet attrSet;
        public RefPattern ref;
        public Pattern elements;
        public Pattern attributes;
        public boolean undefined;

        public Element(String string) {
            this.ref = DTDWalkerFactory.this.pool.makeRef(string);
            this.elements = DTDWalkerFactory.this.pool.makeNotAllowed();
            this.attributes = DTDWalkerFactory.this.pool.makeEmpty();
            this.undefined = true;
        }

        public void addAttribute(String string, Pattern pattern) {
            if (this.attrSet == null) {
                this.attrSet = new HashSet();
            }
            if (!this.attrSet.contains(string)) {
                this.attributes = DTDWalkerFactory.this.pool.makeGroup(this.attributes, pattern);
                this.attrSet.add(string);
            }
        }
    }

    private static class Entry {
        public char[] fBuf;
        public int fPos;
        public int fBeg;
        public int fEnd;
        public int fLin;
        public Entity fEnt;
        public String fNam;

        Entry() {
        }
    }

    private static class EnumFinder
    extends BooleanFunction {
        private String value;

        EnumFinder() {
        }

        public boolean found(String string, Pattern pattern) {
            this.value = string;
            return (Boolean)pattern.apply(this);
        }

        public Object caseValue(ValuePattern valuePattern) {
            return this.value.equals(valuePattern.getValue()) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private class Context
    implements ValidationContext {
        Context() {
        }

        public String resolveNamespacePrefix(String string) {
            if ("".equals(string)) {
                return "";
            }
            if ("xml".equals(string)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            return null;
        }

        public String getBaseUri() {
            return DTDWalkerFactory.this.fEnt.getAbsUrl();
        }

        public boolean isUnparsedEntity(String string) {
            Object object = DTDWalkerFactory.this.walker.getGE(string);
            return object != null && object instanceof Entity && ((Entity)object).getNotation() != null;
        }

        public boolean isNotation(String string) {
            return DTDWalkerFactory.this.walker.getNotation(string) != null;
        }
    }
}

