/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.Alphabet;
import com.thaiopensource.relaxng.impl.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.impl.MPatternVisitor;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.PatternVisitor;
import com.thaiopensource.relaxng.impl.RestrictionViolationException;
import org.xml.sax.SAXException;

public class MNPattern
extends Pattern {
    private final Pattern p;
    private final int m;
    private final int n;

    public MNPattern(Pattern pattern, int n, int n2) {
        super(n == 0 || pattern.isNullable(), pattern.getContentType(), MNPattern.combineHashCode(43, pattern.hashCode()));
        this.p = pattern;
        this.m = n;
        this.n = n2;
    }

    boolean samePattern(Pattern pattern) {
        if (!(pattern instanceof MNPattern)) {
            return false;
        }
        MNPattern mNPattern = (MNPattern)pattern;
        return this.p.samePattern(mNPattern.p) && this.m == mNPattern.m && this.n == mNPattern.n;
    }

    void accept(PatternVisitor patternVisitor) {
        if (patternVisitor instanceof MPatternVisitor) {
            ((MPatternVisitor)patternVisitor).visitMN(this.p, this.m, this.n);
        }
    }

    Object apply(PatternFunction patternFunction) {
        return null;
    }

    Pattern getOperand() {
        return this.p;
    }

    int getM() {
        return this.m;
    }

    int getN() {
        return this.n;
    }

    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_one_or_more");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_one_or_more");
            }
        }
        this.p.checkRestrictions(n == 1 ? 2 : n, duplicateAttributeDetector, alphabet);
        if (n != 6 && !MNPattern.contentTypeGroupable(this.p.getContentType(), this.p.getContentType())) {
            throw new RestrictionViolationException("one_or_more_string");
        }
    }
}

