/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.NewTomcatProjectWizardPage;
import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.TomcatProject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class TomcatProjectCreationWizard
extends NewElementWizard
implements IExecutableExtension,
TomcatPluginResources {
    public static final String NEW_PROJECT_WIZARD_ID = "org.eclipse.jdt.ui.wizards.NewProjectCreationWizard";
    private NewTomcatProjectWizardPage fTomcatPage;
    private NewJavaProjectWizardPage fJavaPage;
    private WizardNewProjectCreationPage fMainPage;
    private IConfigurationElement fConfigElement;

    public TomcatProjectCreationWizard() {
        TomcatLauncherPlugin.checkTomcatSettingsAndWarn();
        ImageDescriptor banner = this.getBannerImg();
        if (banner != null) {
            this.setDefaultPageImageDescriptor(banner);
        }
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(WIZARD_PROJECT_TITLE);
    }

    public boolean canFinish() {
        return TomcatLauncherPlugin.isTomcatConfigured();
    }

    private ImageDescriptor getBannerImg() {
        try {
            URL prefix = new URL(TomcatLauncherPlugin.getDefault().getDescriptor().getInstallURL(), "icons/");
            return ImageDescriptor.createFromURL((URL)new URL(prefix, "newjprj_wiz.gif"));
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public void addPages() {
        super.addPages();
        this.fMainPage = new WizardNewProjectCreationPage("Page 1");
        this.fMainPage.setTitle(WIZARD_PROJECT_MAINPAGE_TITLE);
        this.fMainPage.setDescription(WIZARD_PROJECT_MAINPAGE_DESCRIPTION);
        this.addPage((IWizardPage)this.fMainPage);
        this.fTomcatPage = new NewTomcatProjectWizardPage(this, "NewTomcatProjectPage");
        this.fTomcatPage.setTitle(WIZARD_PROJECT_TOMCATPAGE_TITLE);
        this.fTomcatPage.setDescription(WIZARD_PROJECT_TOMCATPAGE_DESCRIPTION);
        this.addPage((IWizardPage)this.fTomcatPage);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.fJavaPage = new NewJavaProjectWizardPage(root, this.fMainPage);
    }

    public boolean performFinish() {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.fJavaPage.getRunnable());
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
            TomcatProject.addTomcatNature(this.fJavaPage.getNewJavaProject());
            TomcatProject tomcatPrj = TomcatProject.create(this.fJavaPage.getNewJavaProject());
            tomcatPrj.setWebPath(this.fTomcatPage.getWebpath());
            tomcatPrj.setUpdateXml(this.fTomcatPage.getUpdateXml());
            tomcatPrj.setRootDir(this.fTomcatPage.getRootDir());
            tomcatPrj.saveProperties();
            tomcatPrj.fullConfiguration();
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.JavaProjectWizard_op_error_title;
            String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (CoreException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        this.selectAndReveal((IResource)this.fJavaPage.getNewJavaProject().getProject());
        return true;
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof WizardNewProjectCreationPage && !this.fTomcatPage.wasDisplayedOnce()) {
            this.fTomcatPage.setWebpath("/" + this.fMainPage.getProjectName());
        }
        return super.getNextPage(page);
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
    }

    protected IConfigurationElement getFConfigElement() {
        return this.fConfigElement;
    }

    protected NewJavaProjectWizardPage getFJavaPage() {
        return this.fJavaPage;
    }

    protected WizardNewProjectCreationPage getFMainPage() {
        return this.fMainPage;
    }

    protected NewTomcatProjectWizardPage getFTomcatPage() {
        return this.fTomcatPage;
    }

    public IJavaElement getCreatedElement() {
        return null;
    }
}

