/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import org.apache.wsil.Abstract;
import org.apache.wsil.Base64Converter;
import org.apache.wsil.Description;
import org.apache.wsil.DocumentReader;
import org.apache.wsil.DocumentWriter;
import org.apache.wsil.Inspection;
import org.apache.wsil.Link;
import org.apache.wsil.Service;
import org.apache.wsil.ServiceName;
import org.apache.wsil.WSILDocumentFactory;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionRegistry;
import org.apache.wsil.xml.XMLReader;
import org.apache.wsil.xml.XMLWriter;

public abstract class WSILDocument {
    protected DocumentReader docReader = new XMLReader();
    protected DocumentWriter docWriter = new XMLWriter();
    protected ExtensionRegistry extRegistry = null;
    protected Inspection inspection = null;
    protected String documentURL = null;

    public abstract Abstract createAbstract();

    public abstract Description createDescription();

    public abstract Link createLink();

    public abstract Service createService();

    public abstract ServiceName createServiceName();

    public ExtensionRegistry getExtensionRegistry() {
        return this.extRegistry;
    }

    public Inspection getInspection() {
        return this.inspection;
    }

    public DocumentReader getReader() {
        return this.docReader;
    }

    public DocumentWriter getWriter() {
        return this.docWriter;
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length == 0) {
            System.out.println("Usage: WSILDocument <filename>");
        } else {
            try {
                string = stringArray[0];
                System.out.println("Reading WS-Inspection document [" + string + "]...");
                WSILDocument wSILDocument = WSILDocument.newInstance();
                wSILDocument.read(string);
                System.out.println(wSILDocument.toString());
            }
            catch (Exception exception) {
                System.out.println("EXCEPTION: Could not process WS-Inspection document [" + string + "].");
                exception.printStackTrace();
            }
        }
        System.exit(0);
    }

    public static WSILDocument newInstance() throws WSILException {
        WSILDocument wSILDocument = null;
        WSILDocumentFactory wSILDocumentFactory = WSILDocumentFactory.newInstance();
        wSILDocument = wSILDocumentFactory.newDocument();
        return wSILDocument;
    }

    public void read(Reader reader) throws WSILException {
        this.docReader.parseDocument(this, reader);
    }

    public void read(String string) throws WSILException {
        try {
            this.read(new URL(string));
        }
        catch (Exception exception) {
            throw new WSILException("Could not read WS-Inspection file URL string: " + string + ".", exception);
        }
    }

    public void read(URL uRL) throws WSILException {
        try {
            InputStream inputStream;
            this.documentURL = uRL.toString();
            String string = System.getProperty("http.proxyUserName");
            String string2 = System.getProperty("http.proxyPassword");
            if (string != null && string2 != null) {
                String string3 = string + ":" + string2;
                String string4 = Base64Converter.encode(string3);
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setRequestProperty("Proxy-authorization", "Basic " + string4);
                inputStream = uRLConnection.getInputStream();
            } else {
                inputStream = uRL.openStream();
            }
            this.read(new InputStreamReader(inputStream));
        }
        catch (Exception exception) {
            throw new WSILException("Could not read WS-Inspection document from: " + uRL.toString(), exception);
        }
    }

    public void setExtensionRegistry(ExtensionRegistry extensionRegistry) throws WSILException {
        if (this.extRegistry != null) {
            throw new WSILException("ExtensionRegistry is already set in WSILDocument.");
        }
        this.extRegistry = extensionRegistry;
    }

    public void setReader(DocumentReader documentReader) {
        this.docReader = documentReader;
    }

    public void setWriter(DocumentWriter documentWriter) {
        this.docWriter = documentWriter;
    }

    public String toString() {
        return "WS-Inspection Document: \n" + this.inspection.toString();
    }

    public void write(Writer writer) throws WSILException {
        this.docWriter.writeDocument(this, writer);
    }

    public void write(String string) throws WSILException {
        try {
            this.write(new FileWriter(string));
        }
        catch (IOException iOException) {
            throw new WSILException("Could not write to " + string + ".", iOException);
        }
    }

    public String resolveURL(String string) {
        String string2 = string;
        if (this.documentURL != null && string != null && string.indexOf("://") == -1) {
            int n = this.documentURL.lastIndexOf(47);
            string2 = this.documentURL.substring(0, n + 1) + string;
        }
        return string2;
    }

    public void setDocumentURL(String string) {
        this.documentURL = string;
    }
}

