/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IExtendedModifier;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaNamedQuery;
import org.eclipse.jpt.jpa.core.context.java.JavaPersistentType;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMapping;
import org.eclipse.jpt.jpa.ui.internal.JptUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlCompletionProposal;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlCompletionProposalComputer;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JpaJpqlJavaCompletionProposalComputer
extends JpqlCompletionProposalComputer<ICompletionProposal>
implements IJavaCompletionProposalComputer {
    @Override
    ICompletionProposal buildProposal(String proposal, String displayString, String additionalInfo, Image image, int cursorOffset) {
        return new JpqlCompletionProposal(this.contentAssistProposals, proposal, displayString, additionalInfo, image, this.namedQuery, this.actualQuery, this.jpqlQuery, this.offset + 1, this.position, cursorOffset, true);
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (context instanceof JavaContentAssistInvocationContext) {
            monitor.beginTask(null, 100);
            try {
                List<ICompletionProposal> list = this.computeCompletionProposals((JavaContentAssistInvocationContext)context, monitor);
                return list;
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.jpt.jpa.ui", JptUiMessages.JpaJpqlJavaCompletionProposalComputer_Error, (Throwable)e);
                JptJpaCorePlugin.log((IStatus)status);
            }
            finally {
                monitor.done();
            }
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context, IProgressMonitor monitor) throws Exception {
        CompletionContext completionContext = context.getCoreContext();
        if (completionContext == null) {
            return Collections.emptyList();
        }
        int tokenStart = completionContext.getTokenStart();
        if (tokenStart == -1) {
            return Collections.emptyList();
        }
        int[] position = new int[]{completionContext.getOffset() - tokenStart - 1};
        if (position[0] < 0) {
            return Collections.emptyList();
        }
        ICompilationUnit compilationUnit = context.getCompilationUnit();
        if (compilationUnit == null) {
            return Collections.emptyList();
        }
        CompilationUnit astRoot = ASTTools.buildASTRoot((ICompilationUnit)compilationUnit);
        IFile file = this.getCorrespondingResource(compilationUnit);
        if (file == null) {
            return Collections.emptyList();
        }
        JpaFile jpaFile = JptJpaCorePlugin.getJpaFile((IFile)file);
        if (jpaFile == null) {
            return Collections.emptyList();
        }
        monitor.worked(80);
        this.checkCanceled(monitor);
        NamedQuery namedQuery = this.namedQuery(astRoot, jpaFile, tokenStart);
        if (namedQuery == null) {
            return Collections.emptyList();
        }
        String jpqlQuery = this.jpqlQuery(astRoot, tokenStart, completionContext.getTokenEnd(), position);
        return this.buildProposals(namedQuery, jpqlQuery, tokenStart, position[0]);
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    private NamedQuery findNamedQuery(JpaStructureNode structureNode, CompilationUnit astRoot, int tokenStart) {
        JavaPersistentType persistentType;
        JavaTypeMapping typeMapping;
        if (structureNode instanceof JavaPersistentType && (typeMapping = (persistentType = (JavaPersistentType)structureNode).getMapping()) instanceof JavaEntity) {
            JavaEntity entity = (JavaEntity)typeMapping;
            ListIterator queries = entity.getQueryContainer().namedQueries();
            while (queries.hasNext()) {
                JavaNamedQuery namedQuery = (JavaNamedQuery)queries.next();
                TextRange textRange = namedQuery.getQueryAnnotation().getQueryTextRange(astRoot);
                if (textRange == null || !textRange.includes(tokenStart)) continue;
                return namedQuery;
            }
        }
        return null;
    }

    private IFile getCorrespondingResource(ICompilationUnit compilationUnit) {
        try {
            return (IFile)compilationUnit.getCorrespondingResource();
        }
        catch (JavaModelException ex) {
            JptJpaCorePlugin.log((Throwable)ex);
            return null;
        }
    }

    private boolean isInsideNode(ASTNode node, int tokenStart, int tokenEnd) {
        int startPosition = node.getStartPosition();
        return startPosition <= tokenStart && startPosition + node.getLength() >= tokenEnd;
    }

    private String jpqlQuery(CompilationUnit astRoot, int tokenStart, int tokenEnd, int[] position) {
        String jpqlQuery = this.retrieveQuery(astRoot, tokenStart, tokenEnd);
        if (jpqlQuery == null) {
            jpqlQuery = "";
        } else if (StringTools.stringIsQuoted((String)jpqlQuery)) {
            jpqlQuery = jpqlQuery.substring(1, jpqlQuery.length() - 1);
        }
        return jpqlQuery;
    }

    @Override
    String modifyJpqlQuery(String jpqlQuery, int[] position) {
        return ExpressionTools.unescape((CharSequence)jpqlQuery, (int[])position);
    }

    private NamedQuery namedQuery(CompilationUnit astRoot, JpaFile jpaFile, int tokenStart) {
        for (JpaStructureNode node : jpaFile.getRootStructureNodes()) {
            NamedQuery namedQuery = this.findNamedQuery(node, astRoot, tokenStart);
            if (namedQuery == null) continue;
            return namedQuery;
        }
        return null;
    }

    private String retrieveQuery(CompilationUnit astRoot, int tokenStart, int tokenEnd) {
        for (AbstractTypeDeclaration type : astRoot.types()) {
            if (!this.isInsideNode((ASTNode)type, tokenStart, tokenEnd)) continue;
            for (IExtendedModifier modifier : type.modifiers()) {
                Annotation annotation;
                if (!modifier.isAnnotation() || !this.isInsideNode((ASTNode)(annotation = (Annotation)modifier), tokenStart, tokenEnd)) continue;
                if (annotation.isSingleMemberAnnotation()) {
                    SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
                    ArrayInitializer array = (ArrayInitializer)singleMemberAnnotation.getValue();
                    for (Expression expression : array.expressions()) {
                        if (!this.isInsideNode((ASTNode)expression, tokenStart, tokenEnd)) continue;
                        return this.retrieveQuery((NormalAnnotation)expression, tokenStart, tokenEnd);
                    }
                    continue;
                }
                if (!annotation.isNormalAnnotation()) continue;
                return this.retrieveQuery((NormalAnnotation)annotation, tokenStart, tokenEnd);
            }
        }
        return null;
    }

    private String retrieveQuery(NormalAnnotation annotation, int tokenStart, int tokenEnd) {
        for (MemberValuePair pair : annotation.values()) {
            Expression expression = pair.getValue();
            if (!this.isInsideNode((ASTNode)expression, tokenStart, tokenEnd)) continue;
            StringLiteral literal = (StringLiteral)pair.getValue();
            return literal.getEscapedValue();
        }
        return null;
    }
}

