/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout.table;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.layout.BoxUtil;
import org.eclipse.jst.pagedesigner.css2.layout.CSSBlockFlowLayout;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigure;

public abstract class CachedTableCellLayout
extends CSSBlockFlowLayout {
    private Dimension _pageSize = new Dimension();
    private boolean _calculatingSize = false;
    private int[] _pageSizeCacheKeys = new int[4];
    private Dimension[] _pageSizeCacheValues = new Dimension[4];
    private int _recommendedWidth;
    private Dimension _cacheMaxWidthSize = null;
    private boolean _isTable;

    public CachedTableCellLayout(CSSFigure cssfigure) {
        super(cssfigure);
    }

    public void figureRevalidate() {
        super.figureRevalidate();
        this._pageSizeCacheKeys = new int[4];
        this._pageSizeCacheValues = new Dimension[4];
        this._pageSize = new Dimension();
        this._recommendedWidth = 0;
        this._cacheMaxWidthSize = null;
        this._isTable = false;
    }

    public void postValidate() {
        if (this._isTable) {
            if (this._calculatingSize) {
                this._pageSize.width = this._blockBox.getWidth();
                this._pageSize.height = this._blockBox.getHeight();
            } else if (this._isTable) {
                Rectangle rect = this.getCellRect();
                this._blockBox.setXYWidthHeight(rect);
                this.getCSSFigure().setBounds(rect);
            }
            List list = this.getCSSFigure().getChildren();
            int i = 0;
            int n = list.size();
            while (i < n) {
                ((FlowFigure)((Object)list.get(i))).postValidate();
                ++i;
            }
        } else {
            super.postValidate();
        }
    }

    protected void preLayout() {
        this._isTable = this.initializeTableInfo();
        if (this._isTable && !this._calculatingSize) {
            this.getCSSFigure().setValid(false);
        }
        super.preLayout();
    }

    protected abstract Rectangle getCellRect();

    protected abstract boolean initializeTableInfo();

    protected void setupBlock() {
        if (this._isTable) {
            this._blockBox.clear();
            if (this._calculatingSize) {
                int recommendedWidth = this.getRecommendedWidth();
                this._blockBox.setRecommendedWidth(recommendedWidth);
                if (recommendedWidth > 0 && recommendedWidth != Integer.MAX_VALUE) {
                    this._blockBox.setWidth(recommendedWidth);
                }
            } else {
                Rectangle rect = this.getCellRect();
                this._blockBox.setWidth(rect.width);
                this._blockBox.setRecommendedWidth(rect.width);
                this._blockBox.setHeight(rect.height);
                this._blockBox.setRecommendedHeight(rect.height);
            }
            BoxUtil.setupBorderPaddingMargin(this._blockBox, this.getCSSStyle());
        } else {
            super.setupBlock();
        }
    }

    public Dimension getPreferredSize(IFigure container, int width, int h) {
        if (this.isCalculatingMaxWidth()) {
            return this.getMaxContentWidthSize(container, width, h);
        }
        try {
            this._calculatingSize = true;
            int i = 0;
            while (i < 4) {
                if (this._pageSizeCacheKeys[i] == width && this._pageSizeCacheValues[i] != null) {
                    if (h > this._pageSizeCacheValues[i].height) {
                        Dimension dimension = new Dimension(this._pageSizeCacheValues[i].width, h);
                        return dimension;
                    }
                    Dimension dimension = this._pageSizeCacheValues[i];
                    return dimension;
                }
                ++i;
            }
            this._pageSizeCacheKeys[3] = this._pageSizeCacheKeys[2];
            this._pageSizeCacheKeys[2] = this._pageSizeCacheKeys[1];
            this._pageSizeCacheKeys[1] = this._pageSizeCacheKeys[0];
            this._pageSizeCacheKeys[0] = width;
            this._pageSizeCacheValues[3] = this._pageSizeCacheValues[2];
            this._pageSizeCacheValues[2] = this._pageSizeCacheValues[1];
            this._pageSizeCacheValues[1] = this._pageSizeCacheValues[0];
            int oldWidth = this.getRecommendedWidth();
            this.setRecommendedWidth(width);
            ((CSSFigure)container).setValid(false);
            container.validate();
            ((CSSFigure)container).postValidate();
            this._pageSizeCacheValues[0] = new Dimension(this._pageSize);
            if (width != oldWidth) {
                this.setRecommendedWidth(oldWidth);
            }
            if (h > this._pageSizeCacheValues[0].height) {
                Dimension dimension = new Dimension(this._pageSizeCacheValues[0].width, h);
                return dimension;
            }
            Dimension dimension = this._pageSizeCacheValues[0];
            return dimension;
        }
        finally {
            this._calculatingSize = false;
        }
    }

    private int getRecommendedWidth() {
        return this._recommendedWidth;
    }

    private void setRecommendedWidth(int width) {
        if (this._recommendedWidth == width) {
            return;
        }
        this._recommendedWidth = width;
    }

    public Dimension getMaxContentWidthSize(IFigure container, int width, int height) {
        try {
            this._calculatingSize = true;
            if (this._cacheMaxWidthSize == null) {
                boolean b = this.getCalcuatingMaxWidth();
                this.setCalculatingMaxWidth(true);
                int oldWidth = this.getRecommendedWidth();
                if (width <= 0) {
                    this.setRecommendedWidth(Integer.MAX_VALUE);
                } else {
                    this.setRecommendedWidth(width);
                }
                ((CSSFigure)container).setValid(false);
                container.validate();
                ((CSSFigure)container).postValidate();
                this._cacheMaxWidthSize = new Dimension(this._pageSize);
                if (height > this._pageSize.height) {
                    this._cacheMaxWidthSize.height = height;
                }
                if (oldWidth != 0) {
                    this.setRecommendedWidth(oldWidth);
                }
                this.setCalculatingMaxWidth(b);
            }
            Dimension dimension = this._cacheMaxWidthSize;
            return dimension;
        }
        finally {
            this._calculatingSize = false;
        }
    }

    protected boolean isTable() {
        return this._isTable;
    }
}

