/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagAttribute;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IWorkspaceContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.internal.IStructuredDocumentContextResolverFactory2;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.designtime.internal.resolver.ITagElementResolver;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.commands.single.ChangeAttributeCommand;
import org.eclipse.jst.pagedesigner.editors.properties.IPropertyPageDescriptor;
import org.eclipse.jst.pagedesigner.properties.ITabbedPropertiesConstants;
import org.eclipse.jst.pagedesigner.properties.PropertyDescriptorWrapper;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributePropertySource
implements IPropertySource {
    private IDOMElement _element;
    private IPropertySource _innerSource;
    private Entity _tagEntity;
    private IStructuredDocumentContext _context;
    private IPropertyDescriptor[] _descriptors;
    private ITaglibDomainMetaDataQuery _query;

    public AttributePropertySource(Element ele, IPropertySource source) {
        this._element = (IDOMElement)ele;
        this._innerSource = source;
        this._tagEntity = this.getTagEntity();
    }

    private Entity getTagEntity() {
        this._context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._element.getStructuredDocument(), (Node)this._element);
        if (this._context == null) {
            return null;
        }
        IWorkspaceContextResolver wsresolver = IStructuredDocumentContextResolverFactory.INSTANCE.getWorkspaceContextResolver(this._context);
        if (wsresolver == null) {
            return null;
        }
        ITaglibContextResolver resolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(this._context);
        if (resolver == null) {
            return null;
        }
        String uri = resolver.getTagURIForNodeName((Node)this._element);
        if (uri == null) {
            uri = this._element.getNamespaceURI() != null && this._element.getNamespaceURI().equals("http://java.sun.com/JSP/Page") ? "JSP11" : "HTML";
        }
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext((IFile)wsresolver.getResource());
        this._query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        return this._query.getQueryHelper().getEntity(uri, this._element.getLocalName());
    }

    public Object getEditableValue() {
        return this._innerSource.getEditableValue();
    }

    public Object getPropertyValue(Object id) {
        if (id == null) {
            return null;
        }
        String name = id.toString();
        String value = this._element.getAttribute(name);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        return this._innerSource.isPropertySet(id);
    }

    public void resetPropertyValue(Object id) {
        this._innerSource.resetPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        Object oldValue = this.getPropertyValue(id);
        if (oldValue == value || oldValue != null && oldValue.equals(value)) {
            return;
        }
        ChangeAttributeCommand c = new ChangeAttributeCommand(PDPlugin.getResourceString("AttributePropertySource.CommandLabel.ChangeAttribute"), this._element, (String)id, (String)value);
        c.execute();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this._descriptors == null) {
            ITagElement tag;
            ArrayList<PropertyDescriptorWrapper> result = new ArrayList<PropertyDescriptorWrapper>();
            ITagElementResolver tagregResolver = (ITagElementResolver)IStructuredDocumentContextResolverFactory2.INSTANCE.getResolver(this._context, ITagElementResolver.class);
            if (tagregResolver != null && (tag = tagregResolver.getTagElement((Node)this._element)) != null) {
                for (ITagAttribute attr : tag.getAttributes().values()) {
                    IPropertyDescriptor pd = this.getAttrPropertyDescriptor(attr.getName());
                    if (pd != null) {
                        result.add(new PropertyDescriptorWrapper(this._element, pd));
                        continue;
                    }
                    TextPropertyDescriptor pd1 = new TextPropertyDescriptor((Object)attr.getName(), attr.getName());
                    pd1.setDescription(attr.getDescription());
                    pd1.setCategory(ITabbedPropertiesConstants.OTHER_CATEGORY);
                    result.add(new PropertyDescriptorWrapper(this._element, (IPropertyDescriptor)pd1));
                }
            }
            if (result.size() == 0) {
                IPropertyDescriptor[] descs = this._innerSource.getPropertyDescriptors();
                int i = 0;
                while (i < descs.length) {
                    IPropertyDescriptor pd = this.getAttrPropertyDescriptor((String)descs[i].getId());
                    if (pd != null) {
                        result.add(new PropertyDescriptorWrapper(this._element, pd));
                    } else {
                        if (descs[i] instanceof PropertyDescriptor) {
                            ((PropertyDescriptor)descs[i]).setCategory(ITabbedPropertiesConstants.OTHER_CATEGORY);
                        }
                        result.add(new PropertyDescriptorWrapper(this._element, descs[i]));
                    }
                    ++i;
                }
            }
            this._descriptors = new IPropertyDescriptor[result.size()];
            result.toArray(this._descriptors);
        }
        return this._descriptors;
    }

    private IPropertyDescriptor getAttrPropertyDescriptor(String attrName) {
        if (this._query != null) {
            Entity attrEntity = this._query.findTagAttributeEntity(this._tagEntity, attrName);
            List ppds = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IPropertyPageDescriptor.class, this._context, attrEntity);
            if (ppds.size() > 0) {
                return (IPropertyDescriptor)((IPropertyPageDescriptor)ppds.get(0)).getAdapter(IPropertyDescriptor.class);
            }
        }
        return null;
    }
}

