/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.common.sash;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.ui.common.sash.SashEditorPart;
import org.eclipse.jst.pagedesigner.ui.common.sash.SashEditorSelectionProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.INestableKeyBindingService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

public class SashEditorSite
implements IEditorSite {
    private IEditorPart _editor;
    private SashEditorPart _sashEditor;
    private ISelectionProvider _selectionProvider = null;
    private ISelectionChangedListener _selectionChangedListener = null;
    private IKeyBindingService _service = null;

    public SashEditorSite(SashEditorPart sashEditor, IEditorPart editor) {
        Assert.isNotNull((Object)((Object)sashEditor));
        Assert.isNotNull((Object)editor);
        this._sashEditor = sashEditor;
        this._editor = editor;
    }

    public void dispose() {
        if (this._service != null) {
            IKeyBindingService parentService = this.getEditor().getSite().getKeyBindingService();
            if (parentService instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableParent = (INestableKeyBindingService)parentService;
                nestableParent.removeKeyBindingService((IWorkbenchSite)this);
            }
            this._service = null;
        }
    }

    public IEditorActionBarContributor getActionBarContributor() {
        return null;
    }

    public IActionBars getActionBars() {
        return this._sashEditor.getEditorSite().getActionBars();
    }

    public ILabelDecorator getDecoratorManager() {
        return this.getWorkbenchWindow().getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    public IEditorPart getEditor() {
        return this._editor;
    }

    public String getId() {
        return "";
    }

    public IKeyBindingService getKeyBindingService() {
        if (this._service == null) {
            this._service = this.getSashEditor().getEditorSite().getKeyBindingService();
            if (this._service instanceof INestableKeyBindingService) {
                INestableKeyBindingService nestableService = (INestableKeyBindingService)this._service;
                this._service = nestableService.getKeyBindingService((IWorkbenchSite)this);
            } else {
                PDPlugin.getLogger(SashEditorSite.class).info("MultiPageEditorSite.getKeyBindingService()   Parent key binding service was not an instance of INestableKeyBindingService.  It was an instance of " + this._service.getClass().getName() + " instead.");
            }
        }
        return this._service;
    }

    public SashEditorPart getSashEditor() {
        return this._sashEditor;
    }

    public IWorkbenchPage getPage() {
        return this.getSashEditor().getSite().getPage();
    }

    public String getPluginId() {
        return "";
    }

    public String getRegisteredName() {
        return "";
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this._selectionChangedListener == null) {
            this._selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    SashEditorSite.this.handleSelectionChanged(event);
                }
            };
        }
        return this._selectionChangedListener;
    }

    public ISelectionProvider getSelectionProvider() {
        return this._selectionProvider;
    }

    public Shell getShell() {
        return this.getSashEditor().getSite().getShell();
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this.getSashEditor().getSite().getWorkbenchWindow();
    }

    public void handleSelectionChanged(SelectionChangedEvent event) {
        ISelectionProvider parentProvider;
        if (this.getSashEditor().getActiveEditor() == this.getPart() && (parentProvider = this.getSashEditor().getSite().getSelectionProvider()) instanceof SashEditorSelectionProvider) {
            SelectionChangedEvent newEvent = new SelectionChangedEvent(parentProvider, event.getSelection());
            ((SashEditorSelectionProvider)parentProvider).fireSelectionChanged(newEvent);
        }
    }

    public void registerContextMenu(String menuID, MenuManager menuMgr, ISelectionProvider selProvider) {
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selProvider) {
        this.getSashEditor().getSite().registerContextMenu(menuManager, selProvider);
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        ISelectionProvider oldSelectionProvider = this._selectionProvider;
        this._selectionProvider = provider;
        if (oldSelectionProvider != null) {
            oldSelectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
        }
        if (this._selectionProvider != null) {
            this._selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
        }
    }

    public void progressEnd(Job job) {
    }

    public void progressStart(Job job) {
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public IWorkbenchPart getPart() {
        return this._editor;
    }

    public void registerContextMenu(MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
    }

    public void registerContextMenu(String menuId, MenuManager menuManager, ISelectionProvider selectionProvider, boolean includeEditorInput) {
    }

    public Object getService(Class api) {
        return null;
    }

    public boolean hasService(Class api) {
        return false;
    }
}

