/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.FileUtil;
import com.sysdeo.eclipse.tomcat.JDTUtil;
import com.sysdeo.eclipse.tomcat.TomcatBootstrap;
import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatProjectZipper;
import com.sysdeo.eclipse.tomcat.WebClassPathEntries;
import com.sysdeo.eclipse.tomcat.editors.ProjectListElement;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class TomcatProject
extends PlatformObject
implements IProjectNature {
    private static final String PROPERTIES_FILENAME = ".tomcatplugin";
    private static final String KEY_WEBPATH = "webPath";
    private static final String KEY_UPDATEXML = "updateXml";
    private static final String KEY_EXPORTSOURCE = "exportSource";
    private static final String KEY_RELOADABLE = "reloadable";
    private static final String KEY_REDIRECTLOGGER = "redirectLogger";
    private static final String KEY_WARLOCATION = "warLocation";
    private static final String KEY_ROOTDIR = "rootDir";
    private static final String KEY_EXTRAINFO = "extraInfo";
    private static final String KEY_WEBCLASSPATH = "webClassPathEntries";
    private static final String extraBeginTag = "<!-- Extra info begin -->";
    private static final String extraEndTag = "<!-- Extra info end -->";
    protected IProject project;
    protected IJavaProject javaProject;
    protected String webPath = "";
    protected String warLocation = "";
    protected String rootDir = "";
    protected String extraInfo = "";
    protected boolean updateXml;
    protected boolean exportSource;
    protected boolean reloadable = true;
    protected boolean redirectLogger = false;
    protected WebClassPathEntries webClassPathEntries;
    protected IFolder rootDirFolder;

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void configure() throws CoreException {
    }

    public void deconfigure() throws CoreException {
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public void setJavaProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.setProject(javaProject.getProject());
    }

    public static void addTomcatNature(IJavaProject project) {
        try {
            JDTUtil.addNatureToProject(project.getProject(), "com.sysdeo.eclipse.tomcat.tomcatnature");
        }
        catch (CoreException ex) {
            TomcatLauncherPlugin.log(ex.getMessage());
        }
    }

    public static void removeTomcatNature(IJavaProject project) {
        try {
            JDTUtil.removeNatureToProject(project.getProject(), "com.sysdeo.eclipse.tomcat.tomcatnature");
        }
        catch (CoreException ex) {
            TomcatLauncherPlugin.log(ex.getMessage());
        }
    }

    public static TomcatProject create(IJavaProject javaProject) {
        TomcatProject result = null;
        try {
            result = (TomcatProject)javaProject.getProject().getNature("com.sysdeo.eclipse.tomcat.tomcatnature");
            if (result != null) {
                result.setJavaProject(javaProject);
            }
        }
        catch (CoreException ex) {
            TomcatLauncherPlugin.log(ex.getMessage());
        }
        return result;
    }

    public static TomcatProject create(IProject project) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject != null) {
            return TomcatProject.create(javaProject);
        }
        return null;
    }

    private File getPropertiesFile() {
        return this.getProject().getLocation().append(PROPERTIES_FILENAME).toFile();
    }

    private String readProperty(String key) {
        String result = null;
        try {
            result = FileUtil.readPropertyInXMLFile(this.getPropertiesFile(), key);
        }
        catch (IOException e) {
            try {
                result = this.getJavaProject().getCorrespondingResource().getPersistentProperty(new QualifiedName("TomcatProject", key));
            }
            catch (Exception e2) {
                TomcatLauncherPlugin.log(e2);
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String getRootDir() {
        return this.readProperty(KEY_ROOTDIR);
    }

    public void setRootDir(String rd) {
        this.rootDir = rd;
        this.rootDirFolder = null;
    }

    public String getWebPath() {
        return this.readProperty(KEY_WEBPATH);
    }

    public void setWebPath(String wp) {
        this.webPath = wp;
    }

    public void updateWebPath(String newWebPath) throws Exception {
        this.setWebPath(newWebPath);
        if (!newWebPath.equals(this.getWebPath()) && this.getUpdateXml()) {
            this.removeContext();
        }
    }

    public String getWarLocation() {
        return this.readProperty(KEY_WARLOCATION);
    }

    public void setWarLocation(String wl) {
        this.warLocation = wl;
    }

    public boolean getUpdateXml() {
        return new Boolean(this.readProperty(KEY_UPDATEXML));
    }

    public void setUpdateXml(boolean updateXml) {
        this.updateXml = updateXml;
    }

    public boolean getExportSource() {
        return new Boolean(this.readProperty(KEY_EXPORTSOURCE));
    }

    public void setExportSource(boolean exportSource) {
        this.exportSource = exportSource;
    }

    public boolean getReloadable() {
        String reloadableProperty = this.readProperty(KEY_RELOADABLE);
        if (reloadableProperty.equals("")) {
            reloadableProperty = "true";
        }
        return new Boolean(reloadableProperty);
    }

    public void setReloadable(boolean reloadable) {
        this.reloadable = reloadable;
    }

    public boolean getRedirectLogger() {
        String redirectLoggerProperty = this.readProperty(KEY_REDIRECTLOGGER);
        if (redirectLoggerProperty.equals("")) {
            redirectLoggerProperty = "false";
        }
        return new Boolean(redirectLoggerProperty);
    }

    public void setRedirectLogger(boolean redirectLogger) {
        this.redirectLogger = redirectLogger;
    }

    public String getExtraInfo() {
        return URLDecoder.decode(this.readProperty(KEY_EXTRAINFO));
    }

    public void setExtraInfo(String extra) {
        this.extraInfo = extra;
    }

    public void setWebClassPathEntries(WebClassPathEntries entries) {
        this.webClassPathEntries = entries;
    }

    public WebClassPathEntries getWebClassPathEntries() {
        try {
            return WebClassPathEntries.xmlUnmarshal(FileUtil.readTextFile(this.getPropertiesFile()));
        }
        catch (IOException ioEx) {
            return null;
        }
    }

    public void saveProperties() {
        try {
            StringBuffer fileContent = new StringBuffer();
            fileContent.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            fileContent.append("<tomcatProjectProperties>\n");
            fileContent.append("    <rootDir>" + this.rootDir + "</rootDir>\n");
            fileContent.append("    <exportSource>" + this.exportSource + "</exportSource>\n");
            fileContent.append("    <reloadable>" + this.reloadable + "</reloadable>\n");
            fileContent.append("    <redirectLogger>" + this.redirectLogger + "</redirectLogger>\n");
            fileContent.append("    <updateXml>" + this.updateXml + "</updateXml>\n");
            fileContent.append("    <warLocation>" + this.warLocation + "</warLocation>\n");
            fileContent.append("    <extraInfo>" + URLEncoder.encode(this.extraInfo) + "</extraInfo>\n");
            fileContent.append("    <webPath>" + this.webPath + "</webPath>\n");
            if (this.webClassPathEntries != null) {
                fileContent.append(this.webClassPathEntries.xmlMarshal(4));
            }
            fileContent.append("</tomcatProjectProperties>\n");
            FileUtil.toTextFile(this.getPropertiesFile(), fileContent.toString());
            this.project.refreshLocal(1, null);
            IFile propertiesIFile = this.getProject().getFile(PROPERTIES_FILENAME);
            ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{propertiesIFile}, null);
        }
        catch (Exception ex) {
            TomcatLauncherPlugin.log(ex.getMessage());
        }
    }

    public void fullConfiguration() throws CoreException, IOException {
        if (!this.rootDir.equals("")) {
            this.initRootDirFolder(true);
        }
        this.addProjectToSourcePathPref();
        this.createWEBINFFolder();
        this.createWEBINFSrcFolder();
        this.createWorkFolder();
        this.addTomcatJarToProjectClasspath();
        this.addWEBINFLibJarFilesToProjectClasspath();
        this.clearDefaultSourceEntries();
        this.setClassesAsOutputFolder();
        if (this.classesContainsJavaFiles()) {
            this.setClassesAsSourceFolder();
        }
        this.setSrcAsSourceFolder();
        this.setWEBINFSrcAsSourceFolder();
        this.setWorkAsSourceFolder();
        this.updateContext();
    }

    public void clearDefaultSourceEntries() throws CoreException {
        IClasspathEntry[] entries = this.javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>(entries.length + 1);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() != 3) {
                cp.add(entries[i]);
            }
            ++i;
        }
        this.javaProject.setRawClasspath(cp.toArray(new IClasspathEntry[cp.size()]), null);
    }

    public void addTomcatJarToProjectClasspath() throws CoreException {
        TomcatBootstrap tb = TomcatLauncherPlugin.getDefault().getTomcatBootstrap();
        IClasspathEntry[] entries = this.javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>(entries.length + 1);
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() != 4 || !entry.getPath().toOSString().startsWith(TomcatLauncherPlugin.getDefault().getTomcatIPath().toOSString())) {
                cp.add(entry);
            }
            ++i;
        }
        cp.addAll(tb.getTomcatJars());
        this.javaProject.setRawClasspath(cp.toArray(new IClasspathEntry[cp.size()]), null);
    }

    public void addWEBINFLibJarFilesToProjectClasspath() throws CoreException {
        IFolder libFolder = this.getWebInfFolder().getFolder("lib");
        IResource[] libFiles = libFolder.members();
        IClasspathEntry[] entries = this.javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>(entries.length + 1);
        cp.addAll(Arrays.asList(entries));
        int i = 0;
        while (i < libFiles.length) {
            if (libFiles[i].getType() == 1 && libFiles[i].getFileExtension().equalsIgnoreCase("jar")) {
                cp.add(JavaCore.newLibraryEntry((IPath)libFiles[i].getFullPath(), null, null));
            }
            ++i;
        }
        this.javaProject.setRawClasspath(cp.toArray(new IClasspathEntry[cp.size()]), null);
    }

    public IFolder getWebInfFolder() {
        if (this.getRootDirFolder() == null) {
            return this.project.getFolder("WEB-INF");
        }
        return this.getRootDirFolder().getFolder("WEB-INF");
    }

    public IFolder getWorkFolder() {
        return this.project.getFolder("work");
    }

    public IFolder getRootDirFolder() {
        if (this.rootDirFolder == null) {
            this.initRootDirFolder(false);
        }
        return this.rootDirFolder;
    }

    private void initRootDirFolder(boolean create) {
        StringTokenizer tokenizer = new StringTokenizer(this.getRootDir(), "/\\:");
        IFolder folder = null;
        try {
            while (tokenizer.hasMoreTokens()) {
                String each = tokenizer.nextToken();
                folder = folder == null ? this.project.getFolder(each) : folder.getFolder(each);
                if (!create) continue;
                this.createFolder(folder);
            }
        }
        catch (CoreException ex) {
            TomcatLauncherPlugin.log((Exception)((Object)ex));
            folder = null;
            this.setRootDir("/");
        }
        this.rootDirFolder = folder;
    }

    public void createWEBINFFolder() throws CoreException {
        IFolder webinfFolder = this.getWebInfFolder();
        this.createFolder(webinfFolder);
        this.createFolder(webinfFolder.getFolder("classes"));
        this.createFolder(webinfFolder.getFolder("lib"));
        this.createFile(webinfFolder.getFile(".cvsignore"), "classes");
    }

    public void createWEBINFSrcFolder() throws CoreException {
        this.createFolder(this.getWebInfFolder().getFolder("src"));
    }

    public void createWorkFolder() throws CoreException {
        IFolder folderHandle = this.getWorkFolder();
        this.createFolder(folderHandle);
        String tomcatVersion = TomcatLauncherPlugin.getDefault().getTomcatVersion();
        if (tomcatVersion.equals("tomcatV4") || tomcatVersion.equals("tomcatV41")) {
            folderHandle = folderHandle.getFolder("org");
            this.createFolder(folderHandle);
            folderHandle = folderHandle.getFolder("apache");
            this.createFolder(folderHandle);
            folderHandle = folderHandle.getFolder("jsp");
            this.createFolder(folderHandle);
        }
        this.createFile(this.project.getFile(".cvsignore"), "work");
    }

    public void setSrcAsSourceFolder() throws CoreException {
    }

    public void setWEBINFSrcAsSourceFolder() throws CoreException {
        this.setFolderAsSourceEntry(this.getWebInfFolder().getFolder("src"), null);
    }

    public void setClassesAsOutputFolder() throws CoreException {
        IFolder classesFolder = this.getWebInfFolder().getFolder("classes");
        this.javaProject.setOutputLocation(classesFolder.getFullPath(), null);
    }

    public void setClassesAsSourceFolder() throws CoreException {
        IFolder classesFolder = this.getWebInfFolder().getFolder("classes");
        this.setFolderAsSourceEntry(classesFolder, null);
    }

    public void setWorkAsSourceFolder() throws CoreException {
        this.setFolderAsSourceEntry(this.getWorkFolder(), this.getWorkFolder());
    }

    private void createFolder(IFolder folderHandle) throws CoreException {
        try {
            folderHandle.create(false, true, null);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                folderHandle.refreshLocal(2, null);
            }
            throw e;
        }
    }

    private void createFile(IFile fileHandle, String content) throws CoreException {
        try {
            fileHandle.create((InputStream)new ByteArrayInputStream(content.getBytes()), 0, null);
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(2, null);
            }
            throw e;
        }
    }

    private void setFolderAsSourceEntry(IFolder folderHandle, IFolder output) throws CoreException {
        IClasspathEntry[] entries = this.javaProject.getRawClasspath();
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
        System.arraycopy(entries, 0, newEntries, 0, entries.length);
        IPath outputPath = null;
        if (output != null) {
            outputPath = output.getFullPath();
        }
        IPath[] emptyPath = new IPath[]{};
        newEntries[entries.length] = JavaCore.newSourceEntry((IPath)folderHandle.getFullPath(), (IPath[])emptyPath, (IPath)outputPath);
        this.javaProject.setRawClasspath(newEntries, null);
    }

    public void updateContext() throws CoreException, IOException {
        if (TomcatLauncherPlugin.getDefault().getConfigMode().equals("serverFile")) {
            this.updateServerXML();
        } else {
            this.updateContextFile();
        }
    }

    private void updateServerXML() throws CoreException, IOException {
        if (this.getUpdateXml()) {
            this.backupServerXML();
            String xml = FileUtil.readTextFile(this.getServerXML());
            if (!this.contextExistsInXML(xml)) {
                this.addContextToServerXML();
            } else {
                this.updateContextDefinitionInFile(this.getServerXML());
            }
        }
    }

    private void updateContextFile() throws CoreException, IOException {
        if (this.getUpdateXml()) {
            File contextFile = this.getContextFile();
            if (!contextFile.exists()) {
                FileUtil.toTextFile(contextFile, this.createContextDefinition());
            } else {
                this.updateContextDefinitionInFile(contextFile);
            }
        }
    }

    private File getContextFile() {
        File contextFile = new File(String.valueOf(TomcatLauncherPlugin.getDefault().getContextsDir()) + File.separator + this.getContextFileName());
        return contextFile;
    }

    private String getContextFileName() {
        String contextFileName = this.getWebPath();
        if (contextFileName.startsWith("/")) {
            contextFileName = contextFileName.substring(1);
        }
        contextFileName = contextFileName.replace('/', '#');
        return String.valueOf(contextFileName) + ".xml";
    }

    public void removeContext() throws CoreException, IOException {
        this.removeContextFile();
        if (TomcatLauncherPlugin.getDefault().getConfigMode().equals("serverFile")) {
            this.removeContextInServerXML();
        }
    }

    private void removeContextFile() {
        this.getContextFile().delete();
    }

    private void removeContextInServerXML() throws CoreException, IOException {
        this.backupServerXML();
        String xml = FileUtil.readTextFile(this.getServerXML());
        if (this.contextExistsInXML(xml)) {
            int contextTagIdx = this.getContextTagIndex(xml);
            int endTagIndex = xml.indexOf("</Context>", contextTagIdx);
            boolean hasNoBody = false;
            if (endTagIndex < 0) {
                endTagIndex = xml.indexOf(62, contextTagIdx);
                hasNoBody = true;
            } else {
                endTagIndex += "</Context>".length();
            }
            StringBuffer out = null;
            out = new StringBuffer(xml.substring(0, contextTagIdx));
            out.append(xml.substring(endTagIndex + 1, xml.length()));
            FileUtil.toTextFile(this.getServerXML(), out.toString());
        }
    }

    public void backupServerXML() throws CoreException, IOException {
        String backup = String.valueOf(this.getServerXMLLocation()) + ".backup";
        String old = String.valueOf(this.getServerXMLLocation()) + ".old";
        if (!this.getServerXML().exists()) {
            String msg = "Tomcat server.xml file is not found in " + this.getServerXML().getAbsolutePath();
            Status status = new Status(4, TomcatLauncherPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, msg, null);
            throw new CoreException((IStatus)status);
        }
        File backupFile = new File(backup);
        if (!backupFile.exists()) {
            FileUtil.copy(this.getServerXML(), backupFile);
        }
        FileUtil.copy(this.getServerXML(), new File(old));
    }

    private File getServerXML() {
        return new File(this.getServerXMLLocation());
    }

    private String getServerXMLLocation() {
        return TomcatLauncherPlugin.getDefault().getConfigFile();
    }

    private boolean contextExistsInXML(String xml) throws IOException {
        return this.getContextTagIndex(xml) != -1;
    }

    private int getContextTagIndex(String xml) throws IOException {
        int pathIndex = xml.indexOf(this.getContextPath());
        if (pathIndex == -1) {
            return -1;
        }
        int tagIndex = xml.substring(0, pathIndex).lastIndexOf(60);
        String tag = xml.substring(tagIndex, tagIndex + 8);
        if (!tag.equalsIgnoreCase(this.getContextStartTag())) {
            return -1;
        }
        return tagIndex;
    }

    private void addContextToServerXML() throws IOException {
        String xml = FileUtil.readTextFile(this.getServerXML());
        String tag = TomcatLauncherPlugin.getDefault().getTomcatBootstrap().getXMLTagAfterContextDefinition();
        int tagIndex = xml.indexOf(tag);
        int insertIndex = xml.substring(0, tagIndex).lastIndexOf(10);
        StringBuffer out = new StringBuffer(xml.substring(0, insertIndex));
        out.append(this.createContextDefinition());
        out.append(xml.substring(insertIndex, xml.length()));
        FileUtil.toTextFile(this.getServerXML(), out.toString());
    }

    private String createContextDefinition() {
        StringBuffer contextBuffer = new StringBuffer();
        contextBuffer.append(this.getContextStartTag());
        contextBuffer.append(' ');
        contextBuffer.append(this.getContextPath());
        contextBuffer.append(' ');
        contextBuffer.append(this.getContextReloadable());
        contextBuffer.append(' ');
        contextBuffer.append(this.getContextDocBase());
        contextBuffer.append(' ');
        contextBuffer.append(this.getContextWorkDir());
        contextBuffer.append(" />\n");
        String context = contextBuffer.toString();
        if (this.getWebClassPathEntries() != null) {
            context = this.addLoaderToContext(context);
        }
        if (this.getRedirectLogger()) {
            context = this.addLoggerToContext(context);
        }
        if (!this.getExtraInfo().equals("")) {
            context = this.addExtraInfoToContext(context);
        }
        return context;
    }

    private String updateContextDefinition(String context) {
        int extraInfoIndex;
        int loggerIndex;
        int reloadableIndex = context.indexOf(KEY_RELOADABLE);
        context = reloadableIndex == -1 ? this.addReloadableToContext(context) : this.updateReloadableInContext(context);
        int docBaseIndex = context.indexOf("docBase");
        context = docBaseIndex == -1 ? this.addDocBaseToContext(context) : this.updateDocBaseInContext(context);
        int workIndex = context.indexOf("workDir");
        int loaderIndex = (context = workIndex == -1 ? this.addWorkToContext(context) : this.updateWorkInContext(context)).indexOf("<Loader");
        if (loaderIndex == -1 && this.getWebClassPathEntries() != null) {
            context = this.addLoaderToContext(context);
        }
        if (loaderIndex != -1 && this.getWebClassPathEntries() == null) {
            context = this.removeLoaderInContext(context);
        }
        if (loaderIndex != -1 && this.getWebClassPathEntries() != null) {
            context = this.updateLoaderInContext(context);
        }
        if ((loggerIndex = context.indexOf("<Logger")) == -1 && this.getRedirectLogger()) {
            context = this.addLoggerToContext(context);
        }
        if (loggerIndex != -1 && !this.getRedirectLogger()) {
            context = this.removeLoggerInContext(context);
        }
        if (loggerIndex != -1 && this.getRedirectLogger()) {
            context = this.updateLoggerInContext(context);
        }
        if ((extraInfoIndex = context.indexOf(extraBeginTag)) == -1 && !this.getExtraInfo().equals("")) {
            context = this.addExtraInfoToContext(context);
        }
        if (extraInfoIndex != -1 && this.getExtraInfo().equals("")) {
            context = this.removeExtraInfoInContext(context);
        }
        if (extraInfoIndex != -1 && !this.getExtraInfo().equals("")) {
            context = this.updateExtraInfoInContext(context);
        }
        return context;
    }

    private void updateContextDefinitionInFile(File xmlFile) throws IOException {
        String xml = FileUtil.readTextFile(xmlFile);
        int contextTagIndex = this.getContextTagIndex(xml);
        if (contextTagIndex == -1) {
            return;
        }
        int endContextTagIndex = xml.indexOf(">", contextTagIndex);
        if (xml.charAt(endContextTagIndex - 1) != '/') {
            endContextTagIndex = xml.indexOf(this.getContextEndTag(), contextTagIndex) + this.getContextEndTag().length() - 1;
        }
        String context = xml.substring(contextTagIndex, endContextTagIndex + 1);
        StringBuffer out = new StringBuffer(xml.substring(0, contextTagIndex));
        out.append(this.updateContextDefinition(context));
        out.append(xml.substring(endContextTagIndex + 1));
        FileUtil.toTextFile(xmlFile, out.toString());
    }

    private String addDocBaseToContext(String context) {
        int reloadableIndex = context.indexOf(this.getContextReloadable());
        int firstDoubleQuoteIndex = context.indexOf(34, reloadableIndex) + 1;
        int docBaseIndex = context.indexOf(34, firstDoubleQuoteIndex) + 1;
        StringBuffer out = new StringBuffer(context.substring(0, docBaseIndex));
        out.append(' ');
        out.append(this.getContextDocBase());
        out.append(' ');
        out.append(context.substring(docBaseIndex, context.length()));
        return out.toString();
    }

    private String updateDocBaseInContext(String context) {
        int docBaseIndex = context.indexOf("docBase");
        int startIndex = context.indexOf(34, docBaseIndex);
        int endIndex = context.indexOf(34, startIndex + 1);
        StringBuffer out = new StringBuffer(context.substring(0, docBaseIndex));
        out.append(this.getContextDocBase());
        out.append(context.substring(endIndex + 1, context.length()));
        return out.toString();
    }

    private String getContextReloadable() {
        return "reloadable=\"" + this.getReloadable() + '\"';
    }

    private String addReloadableToContext(String context) {
        int pathIndex = context.indexOf(this.getContextPath());
        int firstDoubleQuoteIndex = context.indexOf(34, pathIndex) + 1;
        int reloadableIndex = context.indexOf(34, firstDoubleQuoteIndex) + 1;
        StringBuffer out = new StringBuffer(context.substring(0, reloadableIndex));
        out.append(' ');
        out.append(this.getContextReloadable());
        out.append(' ');
        out.append(context.substring(reloadableIndex, context.length()));
        return out.toString();
    }

    private String updateReloadableInContext(String context) {
        int reloadableIndex = context.indexOf(KEY_RELOADABLE);
        int startIndex = context.indexOf(34, reloadableIndex);
        int endIndex = context.indexOf(34, startIndex + 1);
        StringBuffer out = new StringBuffer(context.substring(0, reloadableIndex));
        out.append(this.getContextReloadable());
        out.append(context.substring(endIndex + 1, context.length()));
        return out.toString();
    }

    private String addWorkToContext(String context) {
        int docBaseIndex = context.indexOf("docBase");
        int firstDoubleQuoteIndex = context.indexOf(34, docBaseIndex) + 1;
        int workIndex = context.indexOf(34, firstDoubleQuoteIndex) + 1;
        StringBuffer out = new StringBuffer(context.substring(0, workIndex));
        out.append(' ');
        out.append(this.getContextWorkDir());
        out.append(' ');
        out.append(context.substring(workIndex, context.length()));
        return out.toString();
    }

    private String updateWorkInContext(String context) {
        int workDirIndex = context.indexOf("workDir");
        int startIndex = context.indexOf(34, workDirIndex);
        int endIndex = context.indexOf(34, startIndex + 1);
        StringBuffer out = new StringBuffer(context.substring(0, workDirIndex));
        out.append(this.getContextWorkDir());
        out.append(context.substring(endIndex + 1, context.length()));
        return out.toString();
    }

    private String formatContextEndTag(String context) {
        int endContextStartTagIndex = context.indexOf(">");
        StringBuffer newContext = new StringBuffer();
        if (context.charAt(endContextStartTagIndex - 1) == '/') {
            newContext.append(context.substring(0, endContextStartTagIndex - 1));
            newContext.append(">");
            newContext.append("\n");
            newContext.append(this.getContextEndTag());
            newContext.append("\n");
            context = newContext.toString();
            --endContextStartTagIndex;
        } else {
            int endContextTagIndex = context.indexOf(this.getContextEndTag());
            if (context.charAt(endContextTagIndex - 1) != '\n') {
                newContext.append(context.substring(0, endContextTagIndex));
                newContext.append("\n");
                newContext.append(context.substring(endContextTagIndex));
            } else {
                return context;
            }
        }
        return newContext.toString();
    }

    private String addLoaderToContext(String context) {
        context = this.formatContextEndTag(context);
        int endContextStartTagIndex = context.indexOf(">");
        int loaderIndex = endContextStartTagIndex + 1;
        StringBuffer out = new StringBuffer(context.substring(0, loaderIndex));
        out.append(this.getContextWebAppClassLoader());
        out.append(context.substring(loaderIndex, context.length()));
        return out.toString();
    }

    private String updateLoaderInContext(String context) {
        int endContextStartTagIndex;
        int startIndex;
        if ((context = this.formatContextEndTag(context)).charAt((startIndex = context.indexOf("<Loader", endContextStartTagIndex = context.indexOf(">"))) - 1) == '\t') {
            --startIndex;
        }
        if (context.charAt(startIndex - 1) == '\n') {
            --startIndex;
        }
        int endIndex = context.indexOf("/>", startIndex + 1) + 1;
        StringBuffer out = new StringBuffer(context.substring(0, startIndex));
        out.append(this.getContextWebAppClassLoader());
        out.append(context.substring(endIndex + 1, context.length()));
        return out.toString();
    }

    private String removeLoaderInContext(String context) {
        int endContextStartTagIndex = context.indexOf(">");
        int startIndex = context.indexOf("<Loader", endContextStartTagIndex);
        if (context.charAt(startIndex - 1) == '\t') {
            --startIndex;
        }
        if (context.charAt(startIndex - 1) == '\n') {
            --startIndex;
        }
        int endIndex = context.indexOf("/>", startIndex + 1) + 1;
        StringBuffer out = new StringBuffer(context.substring(0, startIndex));
        out.append(context.substring(endIndex + 1, context.length()));
        return out.toString();
    }

    private String addLoggerToContext(String context) {
        context = this.formatContextEndTag(context);
        int endContextStartTagIndex = context.indexOf(">");
        int loggerIndex = endContextStartTagIndex + 1;
        StringBuffer out = new StringBuffer(context.substring(0, loggerIndex));
        out.append(this.getContextLogger());
        out.append(context.substring(loggerIndex, context.length()));
        return out.toString();
    }

    private String updateLoggerInContext(String context) {
        int endContextStartTagIndex = context.indexOf(">");
        int startIndex = context.indexOf("<Logger", endContextStartTagIndex);
        if (context.charAt(startIndex - 1) == '\t') {
            --startIndex;
        }
        if (context.charAt(startIndex - 1) == '\n') {
            --startIndex;
        }
        int endIndex = context.indexOf("/>", startIndex) + 1;
        StringBuffer out = new StringBuffer(context.substring(0, startIndex));
        out.append(this.getContextLogger());
        out.append(context.substring(endIndex + 1, context.length()));
        return out.toString();
    }

    private String removeLoggerInContext(String context) {
        int endContextStartTagIndex = context.indexOf(">");
        int startIndex = context.indexOf("<Logger", endContextStartTagIndex);
        if (context.charAt(startIndex - 1) == '\t') {
            --startIndex;
        }
        if (context.charAt(startIndex - 1) == '\n') {
            --startIndex;
        }
        int endIndex = context.indexOf("/>", startIndex) + 1;
        StringBuffer out = new StringBuffer(context.substring(0, startIndex));
        out.append(context.substring(endIndex + 1, context.length()));
        return out.toString();
    }

    private String addExtraInfoToContext(String context) {
        context = this.formatContextEndTag(context);
        int endContextStartTagIndex = context.indexOf(">");
        int extraInfoIndex = endContextStartTagIndex + 1;
        StringBuffer out = new StringBuffer(context.substring(0, extraInfoIndex));
        out.append('\n');
        out.append(extraBeginTag);
        out.append('\n');
        out.append(this.getExtraInfo());
        out.append('\n');
        out.append(extraEndTag);
        out.append(context.substring(extraInfoIndex, context.length()));
        return out.toString();
    }

    private String updateExtraInfoInContext(String context) {
        int endContextStartTagIndex = context.indexOf(">");
        int startIndex = context.indexOf(extraBeginTag, endContextStartTagIndex);
        if (context.charAt(startIndex - 1) == '\t') {
            --startIndex;
        }
        if (context.charAt(startIndex - 1) == '\n') {
            --startIndex;
        }
        int extraEndTagStartIndex = context.indexOf(extraEndTag, startIndex);
        StringBuffer out = new StringBuffer(context.substring(0, startIndex));
        out.append('\n');
        out.append(extraBeginTag);
        out.append('\n');
        out.append(this.getExtraInfo());
        out.append('\n');
        out.append(context.substring(extraEndTagStartIndex, context.length()));
        return out.toString();
    }

    private String removeExtraInfoInContext(String context) {
        int endContextStartTagIndex = context.indexOf(">");
        int startIndex = context.indexOf(extraBeginTag, endContextStartTagIndex);
        if (context.charAt(startIndex - 1) == '\t') {
            --startIndex;
        }
        if (context.charAt(startIndex - 1) == '\n') {
            --startIndex;
        }
        int extraEndTagStartIndex = context.indexOf(extraEndTag, startIndex);
        StringBuffer out = new StringBuffer(context.substring(0, startIndex));
        int endIndex = extraEndTagStartIndex + extraEndTag.length();
        out.append(context.substring(endIndex, context.length()));
        return out.toString();
    }

    private String getContextStartTag() {
        return "<Context";
    }

    private String getContextPath() {
        return "path=\"" + this.getWebPath() + '\"';
    }

    private String getContextDocBase() {
        String docBaseLocation = "";
        docBaseLocation = this.getRootDirFolder() == null ? this.project.getLocation().toOSString() : this.getRootDirFolder().getLocation().toOSString();
        return "docBase=\"" + docBaseLocation + '\"';
    }

    private String getContextWorkDir() {
        String workFolderLocation = this.getWorkFolder().getLocation().toOSString();
        return TomcatLauncherPlugin.getDefault().getTomcatBootstrap().getContextWorkDir(workFolderLocation);
    }

    private String getContextWebAppClassLoader() {
        return "\n\t<Loader className=\"org.apache.catalina.loader.DevLoader\" reloadable=\"true\" debug=\"1\" useSystemClassLoaderAsParent=\"false\" />";
    }

    private String getContextLogger() {
        return "\n\t<Logger className=\"org.apache.catalina.logger.SystemOutLogger\" verbosity=\"4\" timestamp=\"true\"/>";
    }

    private String getContextEndTag() {
        return "</Context>";
    }

    public void exportToWar() throws IOException {
        File warFile = new File(this.getWarLocation());
        File directory = null;
        directory = this.getRootDirFolder() == null ? this.getProject().getLocation().toFile() : this.getRootDirFolder().getLocation().toFile();
        TomcatProjectZipper zipper = new TomcatProjectZipper(warFile, directory, this.getExportSource());
        zipper.zip();
    }

    private boolean classesContainsJavaFiles() {
        IFolder webinfFolder = this.getWebInfFolder();
        IFolder classesFolder = webinfFolder.getFolder("classes");
        File f = classesFolder.getLocation().toFile();
        if (!f.exists()) {
            return false;
        }
        if (!f.isDirectory()) {
            return false;
        }
        return FileUtil.dirContainsFiles(f, "java", true);
    }

    private void addProjectToSourcePathPref() {
        ProjectListElement ple;
        List projects = TomcatLauncherPlugin.getDefault().getProjectsInSourcePath();
        if (!projects.contains(ple = new ProjectListElement(this.getProject()))) {
            projects.add(ple);
            TomcatLauncherPlugin.getDefault().setProjectsInSourcePath(projects);
        }
    }
}

