/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatPluginResources;
import com.sysdeo.eclipse.tomcat.TomcatProject;
import com.sysdeo.eclipse.tomcat.TomcatProjectPropertyPage;
import com.sysdeo.eclipse.tomcat.WebClassPathEntries;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TomcatProjectWebclasspathPropertyPage {
    private static final String WEBAPP_CLASSPATH_FILENAME = ".webclasspath";
    private CheckedListDialogField cpList;
    private Button webClassPathCheck;
    private WebClassPathEntries entries;
    private ArrayList visitedProjects = new ArrayList();
    private TomcatProjectPropertyPage page;

    public TomcatProjectWebclasspathPropertyPage(TomcatProjectPropertyPage page) {
        this.page = page;
    }

    public IJavaProject getJavaProject() {
        try {
            return this.page.getJavaProject();
        }
        catch (CoreException e) {
            TomcatLauncherPlugin.log((Exception)((Object)e));
            return null;
        }
    }

    public boolean performOk() {
        List newSelection = this.cpList.getCheckedElements();
        try {
            if (this.webClassPathCheck.getSelection()) {
                this.page.getTomcatProject().setWebClassPathEntries(new WebClassPathEntries(newSelection));
            } else {
                this.page.getTomcatProject().setWebClassPathEntries(null);
            }
            this.page.getTomcatProject().saveProperties();
        }
        catch (Exception ex) {
            TomcatLauncherPlugin.log(ex);
            return false;
        }
        return true;
    }

    public Control getControl(Composite ctrl) {
        boolean activated = this.isActive();
        Composite group = new Composite(ctrl, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        this.webClassPathCheck = new Button(group, 16416);
        this.webClassPathCheck.setText(TomcatPluginResources.PROPERTIES_PAGE_PROJECT_ACTIVATE_DEVLOADER_LABEL);
        this.webClassPathCheck.setEnabled(true);
        this.webClassPathCheck.setSelection(activated);
        this.webClassPathCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                if (TomcatProjectWebclasspathPropertyPage.this.webClassPathCheck.getSelection()) {
                    TomcatProjectWebclasspathPropertyPage.this.entries = new WebClassPathEntries();
                    TomcatProjectWebclasspathPropertyPage.this.cpList.setEnabled(true);
                } else {
                    TomcatProjectWebclasspathPropertyPage.this.entries = null;
                    TomcatProjectWebclasspathPropertyPage.this.cpList.setEnabled(false);
                }
            }
        });
        this.cpList = new CheckedListDialogField(null, new String[]{"Check All", "Uncheck All"}, (ILabelProvider)new LabelProvider(){});
        this.cpList.setEnabled(activated);
        this.cpList.setCheckAllButtonIndex(0);
        this.cpList.setUncheckAllButtonIndex(1);
        ArrayList classPathEntries = new ArrayList();
        this.getClassPathEntries(this.getJavaProject(), classPathEntries);
        List selected = null;
        if (this.entries != null) {
            selected = this.entries.getList();
            Iterator it = selected.iterator();
            while (it.hasNext()) {
                String sel = (String)it.next();
                if (classPathEntries.contains(sel)) continue;
                it.remove();
            }
        }
        Collections.sort(classPathEntries);
        this.invokeForCompatibility("setElements", classPathEntries);
        if (this.entries != null) {
            this.invokeForCompatibility("setCheckedElements", this.entries.getList());
        }
        this.cpList.doFillIntoGrid(group, 3);
        LayoutUtil.setHorizontalGrabbing((Control)this.cpList.getListControl(null));
        return group;
    }

    public void getClassPathEntries(IJavaProject prj, ArrayList data) {
        IClasspathEntry[] entries = null;
        IPath outputPath = null;
        try {
            outputPath = prj.getOutputLocation();
            this.add(data, prj.getOutputLocation());
            entries = prj.getRawClasspath();
        }
        catch (JavaModelException e) {
            TomcatLauncherPlugin.log((Exception)((Object)e));
        }
        if (entries != null) {
            this.getClassPathEntries(entries, prj, data, outputPath);
        }
    }

    private void getClassPathEntries(IClasspathEntry[] entries, IJavaProject prj, ArrayList data, IPath outputPath) {
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 2) {
                String prjName = entry.getPath().lastSegment();
                if (!this.visitedProjects.contains(prjName)) {
                    this.visitedProjects.add(prjName);
                    this.getClassPathEntries(this.getJavaProject().getJavaModel().getJavaProject(prjName), data);
                }
            } else if (entry.getEntryKind() == 1) {
                this.add(data, entry.getPath());
            } else if (entry.getEntryKind() == 3) {
                IPath path = entry.getOutputLocation();
                if (path != null && !path.equals((Object)outputPath)) {
                    this.add(data, path);
                }
            } else if (entry.getEntryKind() == 5) {
                if (!entry.getPath().toString().equals("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    IClasspathContainer container;
                    this.add(data, entry.getPath());
                    try {
                        container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)prj);
                    }
                    catch (JavaModelException e) {
                        TomcatLauncherPlugin.log("failed to obtain classpath container '" + entry.getPath() + "'" + " for project '" + prj.getProject().getName() + "'");
                        TomcatLauncherPlugin.log((Exception)((Object)e));
                        container = null;
                    }
                    if (container != null) {
                        this.getClassPathEntries(container.getClasspathEntries(), prj, data, outputPath);
                    }
                }
            } else {
                this.add(data, entry.getPath());
            }
            ++i;
        }
    }

    private void add(ArrayList data, IPath entry) {
        String path = entry.toFile().toString().replace('\\', '/');
        if (!data.contains(path) && path.indexOf("TOMCAT_HOME") == -1 && path.indexOf("JRE_CONTAINER") == -1 && path.indexOf("JRE_LIB") == -1) {
            data.add(path.replace('\\', '/'));
        }
    }

    private List readSelectedEntries() {
        ArrayList<String> selected;
        block15: {
            selected = new ArrayList<String>();
            IFile file = this.getJavaProject().getProject().getFile((IPath)new Path(WEBAPP_CLASSPATH_FILENAME));
            if (file == null) {
                return selected;
            }
            File cpFile = file.getLocation().makeAbsolute().toFile();
            if (cpFile.exists()) {
                FileReader reader = null;
                try {
                    try {
                        reader = new FileReader(cpFile);
                        LineNumberReader lr = new LineNumberReader(reader);
                        String line = null;
                        while ((line = lr.readLine()) != null) {
                            selected.add(line);
                        }
                    }
                    catch (IOException ioEx) {
                        TomcatLauncherPlugin.log(ioEx);
                        if (reader == null) break block15;
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return selected;
    }

    private boolean isActive() {
        TomcatProject project;
        block3: {
            this.entries = null;
            project = this.page.getTomcatProject();
            if (project != null) break block3;
            return false;
        }
        try {
            this.entries = project.getWebClassPathEntries();
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return this.entries != null;
    }

    private void invokeForCompatibility(String methodName, List projects) {
        Class<?> clazz = this.cpList.getClass();
        Class[] collectionParameter = new Class[]{Collection.class};
        try {
            Method method = clazz.getMethod(methodName, collectionParameter);
            Object[] args = new Object[]{projects};
            method.invoke((Object)this.cpList, args);
        }
        catch (Exception e) {
            Class[] listParameter = new Class[]{List.class};
            try {
                Method method = clazz.getMethod(methodName, listParameter);
                Object[] args = new Object[]{projects};
                method.invoke((Object)this.cpList, args);
            }
            catch (Exception ex) {
                TomcatLauncherPlugin.log(ex);
            }
        }
    }
}

