/*
 * Decompiled with CFR 0.152.
 */
package com.sysdeo.eclipse.tomcat.actions;

import com.sysdeo.eclipse.tomcat.TomcatLauncherPlugin;
import com.sysdeo.eclipse.tomcat.TomcatProject;
import com.sysdeo.eclipse.tomcat.actions.TomcatActionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class TomcatProjectAbstractActionDelegate
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow window;
    private String msg;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    public void run(IAction action) {
        this.setMsgToSuccess();
        try {
            TomcatProject prj = this.getCurrentSelection();
            if (prj != null) {
                this.doActionOn(prj);
            }
        }
        catch (TomcatActionException ex) {
            this.setMsgToFail(ex.getMessage(), false);
        }
        catch (Exception ex) {
            TomcatLauncherPlugin.log(ex);
            this.setMsgToFail(ex.getMessage(), true);
        }
        if (this.showMessageBox()) {
            Shell shell = TomcatLauncherPlugin.getShell();
            MessageDialog.openInformation((Shell)shell, (String)"Tomcat", (String)this.msg);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected TomcatProject getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = JavaPlugin.getActiveWorkbenchWindow();
        TomcatProject result = null;
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            Object project = ((IStructuredSelection)selection).getFirstElement();
            if (project instanceof IProject) {
                result = TomcatProject.create((IProject)project);
            }
            if (project instanceof IJavaProject) {
                result = TomcatProject.create((IJavaProject)project);
            }
        }
        return result;
    }

    public abstract void doActionOn(TomcatProject var1) throws Exception;

    public boolean showMessageBox() {
        return true;
    }

    private void setMsgToFail(String detail, boolean seelog) {
        this.msg = TomcatLauncherPlugin.getResourceString("msg.action.failed");
        this.msg = String.valueOf(this.msg) + "\n" + detail;
        if (seelog) {
            this.msg = String.valueOf(this.msg) + TomcatLauncherPlugin.getResourceString("msg.action.seelog");
        }
    }

    private void setMsgToSuccess() {
        this.msg = TomcatLauncherPlugin.getResourceString("msg.action.succeeded");
    }
}

