/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.launching.launcher;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.launching.PDELaunchingPlugin;
import org.eclipse.pde.internal.launching.PDEMessages;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.RequirementHelper;

public class EclipsePluginValidationOperation
extends LaunchValidationOperation {
    public static final int CREATE_EXTENSION_ERROR_CODE = 1000;
    private Map fExtensionErrors = new HashMap(2);
    private static Object[] EMPTY = new Object[0];

    public EclipsePluginValidationOperation(ILaunchConfiguration configuration) {
        super(configuration);
    }

    protected IPluginModelBase[] getModels() throws CoreException {
        return BundleLauncherHelper.getMergedBundles(this.fLaunchConfiguration, false);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        super.run(monitor);
        if (this.fExtensionErrors.size() > 0) {
            this.fExtensionErrors.clear();
        }
        this.validateExtensions();
    }

    private void validateExtensions() {
        try {
            String[] required = RequirementHelper.getApplicationRequirements(this.fLaunchConfiguration);
            int i = 0;
            while (i < required.length) {
                BundleDescription bundle = this.getState().getBundle(required[i], null);
                if (bundle == null) {
                    String message = NLS.bind((String)PDEMessages.EclipsePluginValidationOperation_pluginMissing, (Object)required[i]);
                    Status status = new Status(4, "org.eclipse.pde.launching", 1000, message, null);
                    IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
                    Object extensionError = null;
                    extensionError = statusHandler == null ? status.getMessage() : statusHandler.handleStatus((IStatus)status, (Object)required[i]);
                    this.fExtensionErrors.put(extensionError, EMPTY);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDELaunchingPlugin.log(e);
        }
    }

    public boolean hasErrors() {
        return super.hasErrors() || this.fExtensionErrors.size() >= 1;
    }

    public Map getInput() {
        Map map = super.getInput();
        map.putAll(this.fExtensionErrors);
        return map;
    }
}

