/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class DOMMessageFormatter {
    public static final String DOM_DOMAIN = "http://www.w3.org/dom/DOMTR";
    public static final String SERIALIZER_DOMAIN = "http://apache.org/xml/serializer";

    public static String formatMessage(String string, String string2, Object[] objectArray) throws MissingResourceException {
        ResourceBundle resourceBundle = null;
        if (string.equals(DOM_DOMAIN)) {
            resourceBundle = PropertyResourceBundle.getBundle("org.apache.xerces.impl.msg.DOMMessages");
        } else if (string.equals(SERIALIZER_DOMAIN)) {
            resourceBundle = PropertyResourceBundle.getBundle("org.apache.xerces.impl.msg.XMLSerializerMessages");
        } else {
            throw new MissingResourceException("Unknown domain" + string, null, string2);
        }
        if (resourceBundle == null) {
            throw new MissingResourceException("Property file not found!", "org.apache.xerces.impl.msg.DOMMessages", string2);
        }
        String string3 = String.valueOf(string2) + ": " + resourceBundle.getString(string2);
        if (objectArray != null) {
            try {
                string3 = MessageFormat.format(string3, objectArray);
            }
            catch (Exception exception) {
                string3 = resourceBundle.getString("FormatFailed");
                string3 = String.valueOf(string3) + " " + resourceBundle.getString(string2);
            }
        }
        if (string3 == null) {
            string3 = resourceBundle.getString("BadMessageKey");
            throw new MissingResourceException(string3, "org.apache.xerces.impl.msg.DOMMessages", string2);
        }
        return string3;
    }
}

