/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.util;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable = new byte[255];
    private static final char[] lookUpHexAlphabet = new char[16];

    static {
        int n = 0;
        while (n < 255) {
            HexBin.hexNumberTable[n] = -1;
            ++n;
        }
        n = 57;
        while (n >= 48) {
            HexBin.hexNumberTable[n] = (byte)(n - 48);
            --n;
        }
        n = 70;
        while (n >= 65) {
            HexBin.hexNumberTable[n] = (byte)(n - 65 + 10);
            --n;
        }
        n = 102;
        while (n >= 97) {
            HexBin.hexNumberTable[n] = (byte)(n - 97 + 10);
            --n;
        }
        n = 0;
        while (n < 10) {
            HexBin.lookUpHexAlphabet[n] = (char)(48 + n);
            ++n;
        }
        n = 10;
        while (n <= 15) {
            HexBin.lookUpHexAlphabet[n] = (char)(65 + n - 10);
            ++n;
        }
    }

    public static String encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = n * 2;
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = byArray[n3];
            if (n4 < 0) {
                n4 += 256;
            }
            cArray[n3 * 2] = lookUpHexAlphabet[n4 >> 4];
            cArray[n3 * 2 + 1] = lookUpHexAlphabet[n4 & 0xF];
            ++n3;
        }
        return new String(cArray);
    }

    public static byte[] decode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n % 2 != 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byte by = hexNumberTable[cArray[n3 * 2]];
            if (by == -1) {
                return null;
            }
            byte by2 = hexNumberTable[cArray[n3 * 2 + 1]];
            if (by2 == -1) {
                return null;
            }
            byArray[n3] = (byte)(by << 4 | by2);
            ++n3;
        }
        return byArray;
    }
}

