/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd.regex.test;

import com.thaiopensource.datatype.xsd.regex.Regex;
import com.thaiopensource.datatype.xsd.regex.RegexEngine;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Service;
import com.thaiopensource.util.Utf16;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;

public class CategoryTest {
    private static final String categories = "LMNPZSC";
    private static final String subCategories = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn";
    private final Regex[] categoryPosRegexes = new Regex["LMNPZSC".length()];
    private final Regex[] categoryNegRegexes = new Regex["LMNPZSC".length()];
    private final Regex[] subCategoryPosRegexes = new Regex["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    private final Regex[] subCategoryNegRegexes = new Regex["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    int nFail = 0;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static void main(String[] stringArray) throws IOException, RegexSyntaxException {
        RegexEngine regexEngine;
        if (stringArray.length != 2) {
            StringBuffer stringBuffer = new StringBuffer("usage: ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.thaiopensource.datatype.xsd.regex.test.CategoryTest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            System.err.println(stringBuffer.append(clazz.getName()).append(" engineClass UnicodeData").toString());
            System.exit(2);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(stringArray[1])));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.thaiopensource.datatype.xsd.regex.RegexEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Enumeration enumeration = new Service(clazz).getProviders();
        do {
            if (enumeration.hasMoreElements()) continue;
            System.err.println("couldn't find regex engine");
            System.exit(2);
        } while (!(regexEngine = (RegexEngine)enumeration.nextElement()).getClass().getName().equals(stringArray[0]));
        int n = new CategoryTest(regexEngine).testAll(bufferedReader);
        System.err.println(String.valueOf(n) + " tests failed");
        System.exit(n > 0 ? 1 : 0);
    }

    CategoryTest(RegexEngine regexEngine) throws RegexSyntaxException {
        String string;
        int n = 0;
        int n2 = categories.length();
        while (n < n2) {
            string = categories.substring(n, n + 1);
            this.categoryPosRegexes[n] = regexEngine.compile("\\p{" + string + "}");
            this.categoryNegRegexes[n] = regexEngine.compile("\\P{" + string + "}");
            ++n;
        }
        n = 0;
        n2 = subCategories.length();
        while (n < n2) {
            string = subCategories.substring(n, n + 2);
            this.subCategoryPosRegexes[n / 2] = regexEngine.compile("\\p{" + string + "}");
            this.subCategoryNegRegexes[n / 2] = regexEngine.compile("\\P{" + string + "}");
            n += 2;
        }
    }

    int testAll(BufferedReader bufferedReader) throws IOException {
        String string;
        int n = -1;
        while ((string = bufferedReader.readLine()) != null) {
            int n2 = string.indexOf(59);
            if (n2 < 0) continue;
            int n3 = Integer.parseInt(string.substring(0, n2), 16);
            int n4 = string.indexOf(59, n2 + 1);
            String string2 = string.substring(n2, n4);
            String string3 = string.substring(n4 + 1, n4 + 3);
            if (n + 1 != n3) {
                String string4 = string2.endsWith(", Last>") ? string3 : "Cn";
                int n5 = n + 1;
                while (n5 < n3) {
                    this.test(n5, string4);
                    ++n5;
                }
            }
            this.test(n3, string3);
            n = n3;
        }
        ++n;
        while (n < 0x110000) {
            this.test(n, "Cn");
            ++n;
        }
        return this.nFail;
    }

    void test(int n, String string) {
        if (!CategoryTest.isXmlChar(n)) {
            return;
        }
        if (subCategories.indexOf(string) < 0) {
            System.err.println("Missing category: " + string);
            System.exit(2);
        }
        int n2 = 0;
        int n3 = categories.length();
        while (n2 < n3) {
            this.check(n, this.categoryPosRegexes[n2], this.categoryNegRegexes[n2], string.charAt(0) == categories.charAt(n2), categories.substring(n2, n2 + 1));
            ++n2;
        }
        n2 = 0;
        n3 = subCategories.length();
        while (n2 < n3) {
            this.check(n, this.subCategoryPosRegexes[n2 / 2], this.subCategoryNegRegexes[n2 / 2], string.equals(subCategories.substring(n2, n2 + 2)), subCategories.substring(n2, n2 + 2));
            n2 += 2;
        }
    }

    void check(int n, Regex regex, Regex regex2, boolean bl, String string) {
        String string2 = n > 65535 ? new String(new char[]{Utf16.surrogate1(n), Utf16.surrogate2(n)}) : new String(new char[]{(char)n});
        if (regex.matches(string2) != bl) {
            this.fail(n, string);
        }
        if (regex2.matches(string2) != !bl) {
            this.fail(n, "-" + string);
        }
    }

    void fail(int n, String string) {
        ++this.nFail;
        System.err.println("Failed: " + Integer.toHexString(n) + "/" + string);
    }

    static boolean isXmlChar(int n) {
        switch (n) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
            case 65534: 
            case 65535: {
                return false;
            }
        }
        if (n < 32) {
            return false;
        }
        return n < 55296 || n >= 57344;
    }
}

