/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.objfac.util.Local;
import com.objfac.util.TabCalculator;
import com.objfac.walker.DocumentContext;
import com.objfac.walker.DummyContext;
import com.objfac.walker.IWalker;
import com.objfac.walker.gen.GenerateXMLResult;
import com.objfac.walker.gen.IXMLGenerator;
import com.objfac.xml.schema.SchemaConstants;
import com.thaiopensource.datatype.Datatype2;
import com.thaiopensource.datatype.xsd.QNameDatatype;
import com.thaiopensource.relaxng.impl.AfterPattern;
import com.thaiopensource.relaxng.impl.AttributePattern;
import com.thaiopensource.relaxng.impl.ChoicePattern;
import com.thaiopensource.relaxng.impl.DataPattern;
import com.thaiopensource.relaxng.impl.ElementPattern;
import com.thaiopensource.relaxng.impl.GroupPattern;
import com.thaiopensource.relaxng.impl.InterleavePattern;
import com.thaiopensource.relaxng.impl.MAbstractPatternFunction;
import com.thaiopensource.relaxng.impl.MNPattern;
import com.thaiopensource.relaxng.impl.MStarPattern;
import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.OneOrMorePattern;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternWalker;
import com.thaiopensource.relaxng.impl.RefPattern;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.relaxng.impl.TextPattern;
import com.thaiopensource.relaxng.impl.ValuePattern;
import com.thaiopensource.xml.util.Name;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import org.relaxng.datatype.Datatype;

public class XMLGenerator
implements IXMLGenerator {
    private Random random;
    private GenerateXMLResult result;
    private boolean fUseNamespace;
    private StringBuffer altNs;
    private String defaultPrefix;
    private String[] rootAttrs;
    private int elementCount;
    private int maxElements;
    private boolean inText;
    private int uniqueId;
    private int prefixCount;
    private int lineMax;
    private TabCalculator tabber;
    private int lineLength;
    private int nest;
    boolean inElement;
    private PrintWriter writer;
    private HashMap genCount;
    private HashMap nsToPrefix;
    private HashMap nsToPrefixHistory;
    private HashMap prefixToNs;
    private HashMap nsToAliasPrefix;
    private LinkedList nslist;
    private String pendingPrefix;
    private String pendingNs;
    private DocumentContext dummyContext = new DummyContext();
    private AttributeGenerator attrGen = new AttributeGenerator();
    private DeterministicGenerator detGen = new DeterministicGenerator();
    private static final Integer ONE = new Integer(1);
    private static final Integer TWO = new Integer(2);
    private static final Integer TRE = new Integer(3);
    private static final boolean TRACE = false;

    public void generate(String string, String string2, String[] stringArray, GenerateXMLResult generateXMLResult, IWalker iWalker, PrintWriter printWriter, boolean bl, int n, boolean bl2, int n2, int n3) {
        this.writer = printWriter;
        this.genCount = new HashMap();
        this.nsToPrefix = new HashMap();
        this.prefixToNs = new HashMap();
        this.nsToPrefixHistory = new HashMap();
        this.nsToAliasPrefix = new HashMap();
        this.nslist = new LinkedList();
        this.nest = -1;
        this.tabber = new TabCalculator(n, bl2);
        this.lineMax = n2;
        this.maxElements = n3;
        this.rootAttrs = stringArray;
        this.fUseNamespace = bl;
        this.result = generateXMLResult;
        this.elementCount = 0;
        this.defaultPrefix = generateXMLResult.prefix;
        if (generateXMLResult.randomizeChoices) {
            this.random = generateXMLResult.randomSeed ? new Random() : new Random(8905532706935593549L);
        }
        this.generateElement(new Name(string, string2), iWalker);
        this.genCount = null;
        this.nsToPrefix = null;
        this.prefixToNs = null;
        this.nsToPrefixHistory = null;
        this.nsToAliasPrefix = null;
        this.nslist = null;
        this.random = null;
    }

    private void generateElement(Name name, IWalker iWalker) {
        String string;
        this.genCount.put(name, ONE);
        StringBuffer stringBuffer = this.getTopNs();
        String string2 = name.getLocalName();
        if (this.fUseNamespace && name.getNamespaceUri().length() > 0 && (string = this.getPrefix(name.getNamespaceUri())).length() > 0) {
            string2 = String.valueOf(string) + ':' + name.getLocalName();
        }
        this.startElement(string2);
        if (iWalker.acceptElement(name.getNamespaceUri(), name.getLocalName(), name.getLocalName())) {
            if (this.rootAttrs != null) {
                int n = 0;
                while (n < this.rootAttrs.length) {
                    this.addAttribute(this.rootAttrs[n], this.rootAttrs[n + 1]);
                    n += 2;
                }
                this.rootAttrs = null;
            }
            if (iWalker.isDTD() || iWalker.isXMLSchema()) {
                this.deterministicGenerateBody((PatternWalker)iWalker);
            } else {
                this.generateElementBody((PatternWalker)iWalker);
            }
            if (!iWalker.acceptEndTag(name.getNamespaceUri(), name.getLocalName(), name.getLocalName())) {
                iWalker.skipContents();
            }
        }
        this.endElement(string2);
        this.popTopNs(stringBuffer);
    }

    private void deterministicGenerateBody(PatternWalker patternWalker) {
        Pattern pattern = patternWalker.getPattern();
        this.deterministicGenerateBody(pattern);
    }

    private void deterministicGenerateBody(Pattern pattern) {
        String string = this.detGen.getValue();
        this.detGen.setValue(null);
        int n = this.detGen.getCount();
        if (n == this.maxElements) {
            this.addComment(Local.format((String)"Maximum of {0} elements exceeded", (int)this.maxElements));
        }
        if (n >= this.maxElements) {
            return;
        }
        this.detGen.generate(pattern);
        String string2 = this.detGen.getValue();
        if (this.detGen.getCount() == n && string2 != null && this.inElement) {
            this.addText(string2);
        }
        this.detGen.setValue(string);
    }

    private void deterministicGenerateElement(Name name, Pattern pattern) {
        String string;
        StringBuffer stringBuffer = this.getTopNs();
        String string2 = name.getLocalName();
        if (this.fUseNamespace && name.getNamespaceUri().length() > 0 && (string = this.getPrefix(name.getNamespaceUri())).length() > 0) {
            string2 = String.valueOf(string) + ':' + name.getLocalName();
        }
        this.startElement(string2);
        this.deterministicGenerateBody(pattern);
        this.endElement(string2);
        this.popTopNs(stringBuffer);
    }

    private void deterministicGenerateAttribute(Name name, Pattern pattern) {
        String string = this.getAttrQName(name);
        String string2 = this.detGen.getValue();
        this.detGen.setValue(null);
        this.detGen.generate(pattern);
        String string3 = this.detGen.getValue();
        if (string3 == null) {
            string3 = "value";
        }
        this.addAttribute(string, string3);
        this.detGen.setValue(string2);
    }

    private void generateElement(Name name, PatternWalker patternWalker) {
        Integer n = (Integer)this.genCount.get(name);
        if (n == null) {
            this.genCount.put(name, ONE);
        } else if (n == ONE) {
            this.genCount.put(name, TWO);
        } else if (n == TWO) {
            this.genCount.put(name, TRE);
        } else {
            this.addComment(Local.format((String)"Possible recursive cycle on element {0}. Not generated", (Object)name.getLocalName()));
            if (patternWalker.acceptElement(name.getNamespaceUri(), name.getLocalName(), name.getLocalName())) {
                patternWalker.skipAttributes();
                patternWalker.skipContents();
            }
            return;
        }
        ++this.elementCount;
        if (this.elementCount == this.maxElements) {
            this.addComment(Local.format((String)"Maximum of {0} elements exceeded", (int)this.maxElements));
        }
        if (this.elementCount >= this.maxElements) {
            return;
        }
        StringBuffer stringBuffer = this.getTopNs();
        String string = this.getElemQName(name);
        this.startElement(string);
        if (patternWalker.acceptElement(name.getNamespaceUri(), name.getLocalName(), name.getLocalName())) {
            this.generateElementBody(patternWalker);
            if (!patternWalker.acceptEndTag(name.getNamespaceUri(), name.getLocalName(), name.getLocalName())) {
                patternWalker.skipContents();
            }
        }
        this.popTopNs(stringBuffer);
        this.endElement(string);
        if (n == null) {
            this.genCount.remove(name);
        } else {
            this.genCount.put(name, n);
        }
    }

    private void generateElementBody(PatternWalker patternWalker) {
        this.generateAttributes(patternWalker);
        this.generateChildren(patternWalker);
    }

    private void generateAttributes(PatternWalker patternWalker) {
        this.attrGen.generateAttributes(patternWalker);
        if (!patternWalker.acceptEndAttributes()) {
            patternWalker.skipAttributes();
        }
    }

    private void generateChildren(PatternWalker patternWalker) {
        if (patternWalker.isTextOnly()) {
            String[] stringArray = patternWalker.getTextValues();
            String[] stringArray2 = patternWalker.getElementTypes();
            Name name = new Name(stringArray2[0], stringArray2[1]);
            String string = this.getValueForType(name, stringArray);
            this.addText(string);
            patternWalker.acceptTextValue(string, this.dummyContext);
        } else {
            ElementGenerator elementGenerator = new ElementGenerator();
            elementGenerator.generateElements(patternWalker);
        }
    }

    private void popTopNs(StringBuffer stringBuffer) {
        if (stringBuffer == null && this.nslist.size() == 0) {
            return;
        }
        StringBuffer stringBuffer2 = (StringBuffer)this.nslist.getLast();
        while (stringBuffer2 != stringBuffer) {
            if (stringBuffer2 == this.altNs) {
                this.altNs = null;
            } else {
                String string = stringBuffer2.toString();
                String string2 = (String)this.nsToPrefix.get(string);
                this.nsToPrefix.remove(string);
                if (string2 != null) {
                    this.prefixToNs.remove(string2);
                }
            }
            this.nslist.removeLast();
            if (this.nslist.size() == 0) break;
            stringBuffer2 = (StringBuffer)this.nslist.getLast();
        }
    }

    private StringBuffer getTopNs() {
        if (this.nslist.size() > 0) {
            return (StringBuffer)this.nslist.getLast();
        }
        return null;
    }

    private void generateAttribute(Name name, PatternWalker patternWalker) {
        String string = this.getAttrQName(name);
        String[] stringArray = patternWalker.getAttributeValues(name.getNamespaceUri(), name.getLocalName(), name.getLocalName());
        String[] stringArray2 = patternWalker.getAttributeTypes(name.getNamespaceUri(), name.getLocalName(), name.getLocalName());
        Name name2 = new Name(stringArray2[0], stringArray2[1]);
        String string2 = this.getValueForType(name2, stringArray);
        this.addAttribute(string, string2);
        if (!patternWalker.acceptAttribute(name.getNamespaceUri(), name.getLocalName(), name.getLocalName(), string2, this.dummyContext)) {
            patternWalker.acceptAttributeSkipValue(name.getNamespaceUri(), name.getLocalName(), name.getLocalName());
        }
    }

    private String getAttrQName(Name name) {
        String string = name.getLocalName();
        if (this.fUseNamespace && name.getNamespaceUri().length() > 0) {
            String string2 = this.getPrefix(name.getNamespaceUri());
            this.pushPendingNs();
            if (string2.length() == 0) {
                string2 = this.getAltPrefix(name.getNamespaceUri());
                this.pushPendingNs();
            }
            string = String.valueOf(string2) + ':' + name.getLocalName();
        }
        return string;
    }

    private String getElemQName(Name name) {
        String string;
        String string2 = name.getLocalName();
        this.getTopNs();
        if (this.fUseNamespace && name.getNamespaceUri().length() > 0 && (string = this.getPrefix(name.getNamespaceUri())).length() > 0) {
            string2 = String.valueOf(string) + ':' + name.getLocalName();
        }
        return string2;
    }

    private String getValueForType(Name name, String[] stringArray) {
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        String string = null;
        if (name.getNamespaceUri().equals("http://www.w3.org/2001/XMLSchema-datatypes") || name.getNamespaceUri().equals("http://www.w3.org/2001/XMLSchema")) {
            string = name.getLocalName().equals("ID") ? "id" + this.uniqueId++ : (name.getLocalName().equals("IDREF") || name.getLocalName().equals("IDREFS") ? "id0" : (String)SchemaConstants.TYPE_VALUES.get(name.getLocalName()));
        } else if (name.getNamespaceUri().length() == 0) {
            if ("string".equals(name.getLocalName())) {
                string = "string";
            } else if ("token".equals(name.getLocalName())) {
                string = "token";
            }
        }
        if (string == null) {
            string = "String";
        }
        return string;
    }

    private String getPrefix(String string) {
        if (string.length() == 0) {
            return "";
        }
        String string2 = (String)this.nsToPrefix.get(string);
        if (string2 == null) {
            if (this.prefixCount++ == 0) {
                string2 = this.defaultPrefix != null && this.defaultPrefix.length() > 0 ? this.defaultPrefix : "ns";
            } else {
                string2 = (String)this.nsToPrefixHistory.get(string);
                if (string2 == null) {
                    string2 = "ns" + this.prefixCount++;
                }
            }
            while (this.prefixToNs.get(string2) != null) {
                string2 = "ns" + this.prefixCount++;
            }
            this.nsToPrefix.put(string, string2);
            this.nsToPrefixHistory.put(string, string2);
            this.prefixToNs.put(string2, string);
            this.nslist.add(new StringBuffer(string));
            this.pendingNs = string;
            this.pendingPrefix = string2;
        }
        return string2;
    }

    private String getAltPrefix(String string) {
        if (this.altNs == null) {
            this.pushPendingNs();
            this.altNs = new StringBuffer(string);
            this.nslist.add(this.altNs);
            this.pendingNs = string;
            this.pendingPrefix = "alt";
        }
        return "alt";
    }

    private void startElement(String string) {
        this.endStartTag();
        ++this.nest;
        this.indent();
        this.print('<');
        this.print(string);
        this.inElement = true;
        this.pushPendingNs();
    }

    private void pushPendingNs() {
        if (this.pendingNs != null) {
            String string = this.pendingPrefix;
            if (string.length() > 0) {
                this.addAttribute("xmlns:" + string, this.pendingNs);
            } else {
                this.addAttribute("xmlns", this.pendingNs);
            }
            this.pendingNs = null;
            this.pendingPrefix = null;
        }
    }

    private void endStartTag() {
        if (this.inElement) {
            this.println(">");
            this.inElement = false;
        }
    }

    private void addText(String string) {
        if (!this.inElement) {
            throw new IllegalStateException("text node not in element");
        }
        this.print(">");
        this.inElement = false;
        this.print(string);
        this.inText = true;
    }

    private void addComment(String string) {
        this.endStartTag();
        this.indent();
        this.print("<!--");
        this.print(string);
        this.println("-->");
    }

    private void endElement(String string) {
        if (this.inElement) {
            this.print('/');
            this.endStartTag();
        } else {
            if (!this.inText) {
                this.indent();
            }
            this.inText = false;
            this.print("</");
            this.print(string);
            this.println(">");
        }
        --this.nest;
    }

    private void addAttribute(String string, String string2) {
        if (!this.inElement) {
            throw new IllegalStateException("Attribute outside element");
        }
        int n = string.length() + string2.length() + 4;
        if (this.lineLength + n > this.lineMax) {
            this.println();
            this.indent();
            this.printTab();
        } else {
            this.print(' ');
        }
        this.print(string);
        this.print("=\"");
        this.print(string2);
        this.print('\"');
    }

    private void indent() {
        int n = 0;
        while (n < this.nest) {
            this.printTab();
            ++n;
        }
    }

    private void print(char c) {
        ++this.lineLength;
        this.writer.print(c);
    }

    private void print(String string) {
        this.lineLength += string.length();
        this.writer.print(string);
    }

    private void println(String string) {
        this.writer.println(string);
        this.lineLength = 0;
    }

    private void println() {
        this.writer.println();
        this.lineLength = 0;
    }

    private void printTab() {
        String string = this.tabber.getTab();
        this.writer.print(string);
        this.lineLength += this.tabber.getTabWidth();
    }

    private class AttributeGenerator
    extends MAbstractPatternFunction {
        private boolean isOptional;
        private PatternWalker walker;
        private int count;

        AttributeGenerator() {
        }

        public void generateAttributes(PatternWalker patternWalker) {
            this.walker = patternWalker;
            this.isOptional = false;
            this.count = 0;
            patternWalker.getPattern().apply(this);
        }

        public Object caseOther(Pattern pattern) {
            return null;
        }

        public Object caseAfter(AfterPattern afterPattern) {
            return afterPattern.p1.apply(this);
        }

        public Object caseAttribute(AttributePattern attributePattern) {
            NameClass nameClass;
            if ((!this.isOptional || ((XMLGenerator)XMLGenerator.this).result.optionalAttributes) && (nameClass = attributePattern.getNameClass()) instanceof SimpleNameClass) {
                SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
                Name name = simpleNameClass.getName();
                XMLGenerator.this.generateAttribute(name, this.walker);
                ++this.count;
            }
            return null;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            Pattern pattern = groupPattern.p1;
            Pattern pattern2 = groupPattern.p2;
            if (XMLGenerator.this.random != null && XMLGenerator.this.random.nextBoolean()) {
                Pattern pattern3 = pattern;
                pattern = pattern2;
                pattern2 = pattern3;
            }
            pattern.apply(this);
            pattern2.apply(this);
            return null;
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            Pattern pattern = choicePattern.p1;
            Pattern pattern2 = choicePattern.p2;
            if (XMLGenerator.this.random != null && XMLGenerator.this.random.nextBoolean()) {
                Pattern pattern3 = pattern;
                pattern = pattern2;
                pattern2 = pattern3;
            }
            boolean bl = this.isOptional;
            int n = this.count;
            this.isOptional = bl || pattern2.isNullable();
            pattern.apply(this);
            if (this.count == n) {
                this.isOptional = bl || pattern.isNullable();
                pattern2.apply(this);
            }
            this.isOptional = bl;
            return null;
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            Pattern pattern = interleavePattern.p1;
            Pattern pattern2 = interleavePattern.p2;
            if (XMLGenerator.this.random != null && XMLGenerator.this.random.nextBoolean()) {
                Pattern pattern3 = pattern;
                pattern = pattern2;
                pattern2 = pattern3;
            }
            pattern.apply(this);
            pattern2.apply(this);
            return null;
        }

        public Object caseRef(RefPattern refPattern) {
            if (refPattern.getPattern() == null) {
                return null;
            }
            return refPattern.getPattern().apply(this);
        }
    }

    private class ElementGenerator
    extends MAbstractPatternFunction {
        private PatternWalker walker;
        boolean isOptional;
        int count;
        HashSet seen;

        ElementGenerator() {
        }

        public void generateElements(PatternWalker patternWalker) {
            this.walker = patternWalker;
            this.isOptional = false;
            this.count = 0;
            this.seen = new HashSet();
            patternWalker.getPattern().apply(this);
        }

        public Object caseOther(Pattern pattern) {
            return null;
        }

        public Object caseAfter(AfterPattern afterPattern) {
            return afterPattern.getOperand1().apply(this);
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            Pattern pattern;
            Pattern pattern2 = choicePattern.p1;
            Pattern pattern3 = choicePattern.p2;
            if (XMLGenerator.this.random != null) {
                if (XMLGenerator.this.random.nextBoolean()) {
                    pattern = pattern2;
                    pattern2 = pattern3;
                    pattern3 = pattern;
                }
            } else if (this.seen.contains(choicePattern)) {
                pattern = pattern2;
                pattern2 = pattern3;
                pattern3 = pattern;
                this.seen.remove(choicePattern);
            } else {
                this.seen.add(choicePattern);
            }
            boolean bl = this.isOptional;
            int n = this.count;
            this.isOptional = bl || pattern3.isNullable();
            pattern2.apply(this);
            if (this.count == n) {
                this.isOptional = bl || pattern2.isNullable();
                pattern3.apply(this);
            }
            this.isOptional = bl;
            return null;
        }

        public Object caseElement(ElementPattern elementPattern) {
            NameClass nameClass;
            if ((!this.isOptional || ((XMLGenerator)XMLGenerator.this).result.optionalElements) && (nameClass = elementPattern.getNameClass()) instanceof SimpleNameClass) {
                SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
                Name name = simpleNameClass.getName();
                XMLGenerator.this.generateElement(name, this.walker);
                ++this.count;
            }
            return null;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            groupPattern.p1.apply(this);
            groupPattern.p2.apply(this);
            return null;
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            Pattern pattern = interleavePattern.p1;
            Pattern pattern2 = interleavePattern.p2;
            if (XMLGenerator.this.random != null && XMLGenerator.this.random.nextBoolean()) {
                Pattern pattern3 = pattern;
                pattern = pattern2;
                pattern2 = pattern3;
            }
            pattern.apply(this);
            pattern2.apply(this);
            return null;
        }

        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            boolean bl = this.isOptional;
            int n = ((XMLGenerator)XMLGenerator.this).result.repeatCount == 0 && !this.isOptional ? 1 : ((XMLGenerator)XMLGenerator.this).result.repeatCount;
            this.isOptional = false;
            while (n-- > 0) {
                oneOrMorePattern.getOperand().apply(this);
            }
            this.isOptional = bl;
            return super.caseOneOrMore(oneOrMorePattern);
        }

        public Object caseMStar(MStarPattern mStarPattern) {
            boolean bl = this.isOptional;
            int n = ((XMLGenerator)XMLGenerator.this).result.repeatCount == 0 && !this.isOptional ? 1 : ((XMLGenerator)XMLGenerator.this).result.repeatCount;
            this.isOptional = false;
            while (n-- > 0) {
                mStarPattern.getOperand().apply(this);
            }
            this.isOptional = bl;
            return super.caseMStar(mStarPattern);
        }

        public Object caseMN(MNPattern mNPattern) {
            boolean bl = this.isOptional;
            int n = ((XMLGenerator)XMLGenerator.this).result.repeatCount == 0 && !this.isOptional ? 1 : Math.min(((XMLGenerator)XMLGenerator.this).result.repeatCount, mNPattern.getN());
            this.isOptional = false;
            while (n-- > 0) {
                mNPattern.getOperand().apply(this);
            }
            this.isOptional = bl;
            return super.caseMN(mNPattern);
        }

        public Object caseRef(RefPattern refPattern) {
            if (refPattern.getPattern() == null) {
                return null;
            }
            return refPattern.getPattern().apply(this);
        }
    }

    private class DeterministicGenerator
    extends MAbstractPatternFunction {
        boolean isOptional = false;
        int count = 0;
        HashSet recursive = new HashSet();
        HashSet seen = new HashSet();
        String value = null;

        DeterministicGenerator() {
        }

        public void generate(Pattern pattern) {
            pattern.apply(this);
        }

        public String getValue() {
            return this.value;
        }

        public int getCount() {
            return this.count;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public Object caseData(DataPattern dataPattern) {
            if (this.value != null) {
                return null;
            }
            Datatype datatype = dataPattern.getDatatype();
            if (datatype instanceof Datatype2) {
                Datatype2 datatype2 = (Datatype2)datatype;
                String string = datatype2.getTypeName();
                Name name = new Name("http://www.w3.org/2001/XMLSchema-datatypes", string);
                this.value = XMLGenerator.this.getValueForType(name, new String[0]);
            } else {
                String string = datatype.getClass().getName();
                this.value = string.endsWith(".BooleanDatatype") ? "true" : "string";
            }
            return this.caseOther(dataPattern);
        }

        public Object caseValue(ValuePattern valuePattern) {
            if (this.value != null) {
                return null;
            }
            Datatype datatype = valuePattern.getDatatype();
            if (datatype instanceof Datatype2) {
                Datatype2 datatype2 = (Datatype2)datatype;
                String string = datatype2.getTypeName();
                if ("QName".equals(string)) {
                    Object object = valuePattern.getValue();
                    if (object instanceof QNameDatatype.QName) {
                        XMLGenerator.this.pushPendingNs();
                        QNameDatatype.QName qName = (QNameDatatype.QName)object;
                        String string2 = qName.namespaceURI;
                        String string3 = XMLGenerator.this.getPrefix(string2);
                        XMLGenerator.this.pushPendingNs();
                        this.value = String.valueOf(string3) + ':' + qName.localName;
                    }
                } else {
                    this.value = valuePattern.getValue().toString();
                }
            } else {
                this.value = valuePattern.getValue().toString();
            }
            return null;
        }

        public Object caseText(TextPattern textPattern) {
            if (this.value != null) {
                return null;
            }
            this.value = "text";
            return null;
        }

        public Object caseElement(ElementPattern elementPattern) {
            NameClass nameClass;
            if ((!this.isOptional || ((XMLGenerator)XMLGenerator.this).result.optionalElements) && (nameClass = elementPattern.getNameClass()) instanceof SimpleNameClass) {
                SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
                Name name = simpleNameClass.getName();
                ++this.count;
                XMLGenerator.this.deterministicGenerateElement(name, elementPattern.getContent());
            }
            return null;
        }

        public Object caseAttribute(AttributePattern attributePattern) {
            NameClass nameClass;
            if ((!this.isOptional || ((XMLGenerator)XMLGenerator.this).result.optionalAttributes) && (nameClass = attributePattern.getNameClass()) instanceof SimpleNameClass) {
                SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
                Name name = simpleNameClass.getName();
                XMLGenerator.this.deterministicGenerateAttribute(name, attributePattern.getContent());
            }
            return null;
        }

        public Object caseAfter(AfterPattern afterPattern) {
            return afterPattern.getOperand1().apply(this);
        }

        public Object caseChoice(ChoicePattern choicePattern) {
            Pattern pattern;
            Pattern pattern2 = choicePattern.p1;
            Pattern pattern3 = choicePattern.p2;
            if (XMLGenerator.this.random != null) {
                if (XMLGenerator.this.random.nextBoolean()) {
                    pattern = pattern2;
                    pattern2 = pattern3;
                    pattern3 = pattern;
                }
            } else if (this.seen.contains(choicePattern)) {
                pattern = pattern2;
                pattern2 = pattern3;
                pattern3 = pattern;
                this.seen.remove(choicePattern);
            } else {
                this.seen.add(choicePattern);
            }
            boolean bl = this.isOptional;
            int n = this.count;
            this.isOptional = bl || pattern3.isNullable();
            pattern2.apply(this);
            if (this.count == n) {
                this.isOptional = bl || pattern2.isNullable();
                pattern3.apply(this);
            }
            this.isOptional = bl;
            return null;
        }

        public Object caseGroup(GroupPattern groupPattern) {
            groupPattern.p1.apply(this);
            groupPattern.p2.apply(this);
            return null;
        }

        public Object caseInterleave(InterleavePattern interleavePattern) {
            Pattern pattern = interleavePattern.p1;
            Pattern pattern2 = interleavePattern.p2;
            if (XMLGenerator.this.random != null && XMLGenerator.this.random.nextBoolean()) {
                Pattern pattern3 = pattern;
                pattern = pattern2;
                pattern2 = pattern3;
            }
            pattern.apply(this);
            pattern2.apply(this);
            return null;
        }

        public Object caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            boolean bl = this.isOptional;
            int n = ((XMLGenerator)XMLGenerator.this).result.repeatCount == 0 && !this.isOptional ? 1 : ((XMLGenerator)XMLGenerator.this).result.repeatCount;
            this.isOptional = false;
            while (n-- > 0) {
                oneOrMorePattern.getOperand().apply(this);
            }
            this.isOptional = bl;
            return super.caseOneOrMore(oneOrMorePattern);
        }

        public Object caseMStar(MStarPattern mStarPattern) {
            boolean bl = this.isOptional;
            int n = ((XMLGenerator)XMLGenerator.this).result.repeatCount == 0 && !this.isOptional ? 1 : ((XMLGenerator)XMLGenerator.this).result.repeatCount;
            this.isOptional = false;
            while (n-- > 0) {
                mStarPattern.getOperand().apply(this);
            }
            this.isOptional = bl;
            return super.caseMStar(mStarPattern);
        }

        public Object caseMN(MNPattern mNPattern) {
            boolean bl = this.isOptional;
            int n = ((XMLGenerator)XMLGenerator.this).result.repeatCount == 0 && !this.isOptional ? 1 : Math.min(((XMLGenerator)XMLGenerator.this).result.repeatCount, mNPattern.getN());
            this.isOptional = false;
            while (n-- > 0) {
                mNPattern.getOperand().apply(this);
            }
            this.isOptional = bl;
            return super.caseMN(mNPattern);
        }

        public Object caseRef(RefPattern refPattern) {
            if (refPattern.getPattern() == null) {
                return null;
            }
            if (this.recursive.contains(refPattern)) {
                return null;
            }
            this.recursive.add(refPattern);
            refPattern.getPattern().apply(this);
            this.recursive.remove(refPattern);
            return null;
        }

        public Object caseOther(Pattern pattern) {
            return null;
        }
    }
}

