/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.sax;

import com.thaiopensource.util.UriOrFile;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorHandlerImpl
implements ErrorHandler {
    private final PrintWriter err;
    private final String bundleName = "com.thaiopensource.xml.sax.resources.Messages";
    private ResourceBundle bundle = null;

    public ErrorHandlerImpl() {
        this(System.err);
    }

    public ErrorHandlerImpl(OutputStream outputStream) {
        this.err = new PrintWriter(outputStream);
    }

    public ErrorHandlerImpl(Writer writer) {
        this.err = new PrintWriter(writer);
    }

    public void close() {
        this.err.close();
    }

    private String getString(String string) {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com.thaiopensource.xml.sax.resources.Messages");
        }
        return this.bundle.getString(string);
    }

    private String format(String string, Object[] objectArray) {
        return MessageFormat.format(this.getString(string), objectArray);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.print(this.format("warning", new Object[]{this.formatMessage(sAXParseException), this.formatLocation(sAXParseException)}));
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.print(this.format("error", new Object[]{this.formatMessage(sAXParseException), this.formatLocation(sAXParseException)}));
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void printException(Throwable throwable) {
        String string = throwable instanceof SAXParseException ? this.formatLocation((SAXParseException)throwable) : "";
        String string2 = throwable instanceof SAXException ? this.formatMessage((SAXException)throwable) : this.formatMessage(throwable);
        this.print(this.format("fatal", new Object[]{string2, string}));
    }

    public void print(String string) {
        if (string.length() != 0) {
            this.err.println(string);
            this.err.flush();
        }
    }

    private String formatLocation(SAXParseException sAXParseException) {
        Integer n;
        String string = sAXParseException.getSystemId();
        int n2 = sAXParseException.getLineNumber();
        Integer n3 = n2 >= 0 ? new Integer(n2) : null;
        n2 = sAXParseException.getColumnNumber();
        Integer n4 = n = n2 >= 0 ? new Integer(n2) : null;
        if (string != null) {
            string = UriOrFile.uriToUriOrFile(string);
            if (n3 != null) {
                if (n != null) {
                    return this.format("locator_system_id_line_number_column_number", new Object[]{string, n3, n});
                }
                return this.format("locator_system_id_line_number", new Object[]{string, n3});
            }
            return this.format("locator_system_id", new Object[]{string});
        }
        if (n3 != null) {
            if (n != null) {
                return this.format("locator_line_number_column_number", new Object[]{n3, n});
            }
            return this.format("locator_line_number", new Object[]{n3});
        }
        return "";
    }

    private String formatMessage(SAXException sAXException) {
        Exception exception = sAXException.getException();
        String string = sAXException.getMessage();
        if (exception != null) {
            String string2 = exception.getMessage();
            if (string2 == string || exception.getClass().getName().equals(string)) {
                return this.formatMessage(exception);
            }
            if (string2 == null) {
                return this.format("exception", new Object[]{exception.getClass().getName(), string});
            }
            return this.format("tunnel_exception", new Object[]{exception.getClass().getName(), string, string2});
        }
        if (string == null) {
            string = this.getString("no_detail");
        }
        return string;
    }

    private String formatMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = this.getString("no_detail");
        }
        if (throwable instanceof FileNotFoundException) {
            return this.format("file_not_found", new Object[]{string});
        }
        return this.format("exception", new Object[]{throwable.getClass().getName(), string});
    }
}

