/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.create.component;

import aurora.ide.meta.gef.Util;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.CheckBox;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.Form;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.Input;
import aurora.ide.meta.gef.editors.models.QueryDataSet;
import aurora.ide.meta.gef.editors.models.ResultDataSet;
import aurora.ide.meta.gef.editors.models.Toolbar;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import java.util.List;
import uncertain.composite.CompositeMap;

public class ViewDiagramCreator {
    private List<CompositeMap> input;

    public ViewDiagramCreator(List<CompositeMap> input) {
        this.input = input;
    }

    public ViewDiagram createPrototypeDiagram(CompositeMap typeMap) {
        Form fillForm;
        ViewDiagram diagram = new ViewDiagram();
        if (typeMap == null) {
            return diagram;
        }
        String type = typeMap.getString((Object)"type", "");
        if ("form_query".equals(type)) {
            fillForm = this.fillQueryForm(this.input);
            diagram.addChild((AuroraComponent)fillForm);
        }
        if ("form_edit".equals(type)) {
            fillForm = this.fillEditForm(this.input);
            diagram.addChild((AuroraComponent)fillForm);
        }
        if ("grid".equals(type)) {
            Grid fillGrid = this.fillGrid(this.input);
            diagram.addChild((AuroraComponent)fillGrid);
        }
        if ("form_grid".equals(type)) {
            fillForm = this.fillQueryForm(this.input);
            diagram.addChild((AuroraComponent)fillForm);
            Grid fillGrid = this.fillGrid(this.input);
            ResultDataSet dataset = fillGrid.getDataset();
            dataset.setQueryContainer((Container)fillForm);
            diagram.addChild((AuroraComponent)fillGrid);
        }
        return diagram;
    }

    private boolean isQueryNameMap(CompositeMap f) {
        return "query-field".equals(f.getName());
    }

    private boolean isRefFieldMap(CompositeMap f) {
        return "ref-field".equals(f.getName());
    }

    private Grid fillGrid(List<CompositeMap> fields) {
        Grid container = new Grid();
        ResultDataSet ds = new ResultDataSet();
        container.setDataset((Dataset)ds);
        for (CompositeMap f : fields) {
            if (!this.isRefFieldMap(f) && !this.isField(f)) continue;
            if (ds.getModel() == null || "".equals(ds.getModel().trim())) {
                ds.setModel(f.getString((Object)"model", ""));
            }
            String string = Util.getPrompt((CompositeMap)f, (String)"");
            GridColumn gc = new GridColumn();
            gc.setPrompt(string);
            String name = f.getString((Object)"name");
            name = name == null ? "" : name;
            gc.setName(name);
            String type = Util.getType((CompositeMap)f);
            gc.setEditor(type);
            container.addChild((AuroraComponent)gc);
        }
        container.setNavbarType("complex");
        Toolbar tb = this.createToolbar();
        container.addChild((AuroraComponent)tb);
        container.setSelectionMode("multiple");
        return container;
    }

    private Toolbar createToolbar() {
        Toolbar tb = new Toolbar();
        Button b1 = new Button();
        b1.setButtonType("add");
        tb.addChild((AuroraComponent)b1);
        Button b2 = new Button();
        b2.setButtonType("delete");
        tb.addChild((AuroraComponent)b2);
        Button b3 = new Button();
        b3.setButtonType("save");
        tb.addChild((AuroraComponent)b3);
        return tb;
    }

    private boolean isField(CompositeMap f) {
        return "field".equals(f.getName());
    }

    private Form fillQueryForm(List<CompositeMap> fields) {
        Form container = new Form();
        QueryDataSet ds = new QueryDataSet();
        container.setDataset((Dataset)ds);
        for (CompositeMap field : fields) {
            if (!this.isQueryNameMap(field) && !this.isField(field)) continue;
            if (ds.getModel() == null || "".equals(ds.getModel().trim())) {
                ds.setModel(field.getString((Object)"model", ""));
            }
            this.fillForm(container, field);
        }
        return container;
    }

    private Form fillEditForm(List<CompositeMap> fields) {
        Form container = new Form();
        ResultDataSet ds = new ResultDataSet();
        container.setDataset((Dataset)ds);
        for (CompositeMap field : fields) {
            if (!this.isField(field)) continue;
            if (ds.getModel() == null || "".equals(ds.getModel().trim())) {
                ds.setModel(field.getString((Object)"model", ""));
            }
            this.fillForm(container, field);
        }
        return container;
    }

    private void fillForm(Form container, CompositeMap field) {
        String name = (String)field.get((Object)"field");
        name = name == null ? field.getString((Object)"name") : name;
        name = name == null ? "" : name;
        Input input = new Input();
        String type = Util.getType((CompositeMap)field);
        if ("checkBox".equals(type)) {
            input = new CheckBox();
        }
        input.setType(type);
        input.setName(name);
        input.setPrompt(Util.getPrompt((CompositeMap)field, (String)""));
        container.addChild((AuroraComponent)input);
    }
}

