/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.bm;

import aurora.ide.create.component.wizard.CreateComponentWizard;
import aurora.ide.editor.textpage.TextPage;
import aurora.ide.views.bm.BMTransfer;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.Transfer;

public class BMTransferDropTargetListener
extends DropTargetAdapter {
    private Transfer transfer = BMTransfer.getInstance();
    private TextPage textPage;

    public BMTransferDropTargetListener(TextPage textPage) {
        this.textPage = textPage;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public void setTransfer(Transfer transfer) {
        this.transfer = transfer;
    }

    public Transfer[] getTransfers() {
        return new Transfer[]{this.transfer};
    }

    public void dragOver(DropTargetEvent event) {
        boolean supportedType = this.transfer.isSupportedType(event.currentDataType);
        if (supportedType) {
            event.feedback |= 8;
            event.feedback |= 1;
            return;
        }
    }

    public void dragEnter(DropTargetEvent event) {
        super.dragEnter(event);
    }

    public void drop(DropTargetEvent event) {
        boolean supportedType = this.transfer.isSupportedType(event.currentDataType);
        if (!supportedType) {
            return;
        }
        IProject project = this.getTextPage().getFile().getProject();
        Object a = event.data;
        if (a instanceof List) {
            CreateComponentWizard ccw = new CreateComponentWizard((List)event.data, project, this.getTextPage());
            WizardDialog wd = new WizardDialog(this.textPage.getSite().getShell(), (IWizard)ccw);
            wd.addPageChangedListener((IPageChangedListener)ccw);
            wd.setHelpAvailable(false);
            wd.setMinimumPageSize(800, 400);
            wd.open();
        }
    }

    public void dropAccept(DropTargetEvent event) {
        super.dropAccept(event);
    }

    public TextPage getTextPage() {
        return this.textPage;
    }

    public void setTextPage(TextPage textPage) {
        this.textPage = textPage;
    }
}

