/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.wizard;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.designer.DataType;
import aurora.ide.meta.gef.editors.template.BMBindComponent;
import aurora.ide.meta.gef.editors.template.BMReference;
import aurora.ide.meta.gef.editors.template.ButtonComponent;
import aurora.ide.meta.gef.editors.template.Component;
import aurora.ide.meta.gef.editors.template.Template;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import uncertain.composite.CompositeMap;

public class ScreenGenerator {
    private CompositeMap initProcMap = this.newMap("init-procedure");
    private CompositeMap scriptMap = this.newMap("script", null);
    private CompositeMap dataSetsMap = this.newMap("dataSets");
    StringBuilder scriptTemp = new StringBuilder();
    private Template template;
    private HashMap<String, BMReference> bmrMap = new HashMap();
    private HashMap<String, Component> comMap = new HashMap();

    public CompositeMap gen(Template view) {
        this.template = view;
        this.extractBMReference();
        this.extractComponent();
        CompositeMap scrMap = this.newMap("screen", "a", "http://www.aurora-framework.org/application");
        scrMap.addChild(this.initProcMap);
        CompositeMap viewMap = this.newMap("view");
        scrMap.addChild(viewMap);
        viewMap.addChild(this.scriptMap);
        viewMap.addChild(this.dataSetsMap);
        for (Component ac : view.getChildren()) {
            CompositeMap m = this.createMapFromCom(ac);
            viewMap.addChild(m);
        }
        String str = this.scriptTemp.toString();
        str = String.valueOf(str.replace("\n", "\n\t\t\t")) + "\n\t\t";
        this.scriptMap.setText(str);
        return scrMap;
    }

    private void extractBMReference() {
        List list = this.template.getBms();
        if (list != null) {
            for (BMReference bm : list) {
                this.bmrMap.put(bm.getId(), bm);
            }
        }
        if ((list = this.template.getLinkBms()) != null) {
            for (BMReference bm : list) {
                this.bmrMap.put(bm.getId(), bm);
            }
        }
    }

    private void extractComponent() {
        LinkedList<Template> queue = new LinkedList<Template>();
        queue.add(this.template);
        while (!queue.isEmpty()) {
            Component c = (Component)queue.remove(0);
            String id = c.getId();
            if (id != null && id.length() > 0) {
                this.comMap.put(id, c);
            }
            if (c.getChildren() == null) continue;
            queue.addAll(c.getChildren());
        }
    }

    private CompositeMap createMapFromCom(Component ac2) {
        String type = ac2.getComponentType().toLowerCase();
        this.autoCorrectComponentType(ac2, type);
        if ("grid".equals(type)) {
            return this.createMapFromGrid(ac2);
        }
        if (ac2 instanceof ButtonComponent) {
            return this.createMapFromButton((ButtonComponent)ac2);
        }
        if (this.oneOf(type, "form", "fieldset")) {
            return this.createMapFromBox(ac2);
        }
        if ("tabpanel".equals(type)) {
            return this.createMapFromTabPanel(ac2);
        }
        CompositeMap map = this.newMap(ac2.getComponentType());
        if (ac2.getChildren() != null) {
            for (Component ac : ac2.getChildren()) {
                CompositeMap m = this.createMapFromCom(ac);
                map.addChild(m);
            }
        }
        return map;
    }

    private void autoCorrectComponentType(Component c, String typeLowCase) {
        if ("hbox".equals(typeLowCase)) {
            c.setComponentType("hBox");
        } else if ("vbox".equals(typeLowCase)) {
            c.setComponentType("vBox");
        }
    }

    private CompositeMap createMapFromTabPanel(Component tp) {
        CompositeMap tpMap = this.newMap(tp.getComponentType());
        tpMap.put((Object)"width", (Object)850);
        tpMap.put((Object)"height", (Object)350);
        CompositeMap tabsMap = this.newMap("tabs");
        tpMap.addChild(tabsMap);
        int idx = 1;
        for (Component c : tp.getChildren()) {
            CompositeMap tab = this.createMapFromCom(c);
            if (tab.getName().equals("tab")) {
                tab.put((Object)"prompt", (Object)("tab" + idx++));
            }
            tabsMap.addChild(tab);
        }
        return tpMap;
    }

    private CompositeMap createMapFromButton(ButtonComponent ac2) {
        CompositeMap btnMap = this.newMap("button");
        String type = ac2.getType();
        if ("toolBar".equals(ac2.getParent().getComponentType())) {
            btnMap.put((Object)"type", (Object)type);
        } else {
            btnMap.put((Object)"text", (Object)ac2.getText());
            String id = ac2.getTarget();
            Component c = this.comMap.get(id);
            if (c != null) {
                if ("query".equals(type)) {
                    String bmrID = ((BMBindComponent)c).getBmReferenceID();
                    BMReference bm = this.getBMReference(bmrID);
                    String ds_id = this.getDataSetId(bm.getModel(), false);
                    String fName = this.createDataSetFunction("query", ds_id);
                    btnMap.put((Object)"click", (Object)fName);
                } else if ("reset".equals(type)) {
                    BMBindComponent bmbc = this.getQueryOwner(c);
                    if (bmbc != null) {
                        String bmrID = bmbc.getBmReferenceID();
                        BMReference bm = this.getBMReference(bmrID);
                        String ds_id = this.getDataSetId(bm.getModel(), true);
                        String fName = this.createDataSetFunction("reset", ds_id);
                        btnMap.put((Object)"click", (Object)fName);
                    }
                } else if ("save".equals(type)) {
                    String bmrID = ((BMBindComponent)c).getBmReferenceID();
                    BMReference bm = this.getBMReference(bmrID);
                    String ds_id = this.getDataSetId(bm.getModel(), false);
                    String fName = this.createDataSetFunction("submit", ds_id);
                    btnMap.put((Object)"click", (Object)fName);
                }
            }
        }
        return btnMap;
    }

    private CompositeMap createMapFromBox(Component ac2) {
        BMBindComponent queryOwner;
        CompositeMap map = this.newMap(ac2.getComponentType());
        String type = ac2.getComponentType().toLowerCase();
        if (this.oneOf(type, "field", "form")) {
            map.put((Object)"column", (Object)3);
            map.put((Object)"title", (Object)type);
        }
        if (ac2 instanceof BMBindComponent) {
            BMBindComponent bmbc = (BMBindComponent)ac2;
            String bmrID = bmbc.getBmReferenceID();
            BMReference bm = this.getBMReference(bmrID);
            this.fillBoxArea(map, bm, false);
        } else if (ac2.getId() != null && (queryOwner = this.getQueryOwner(ac2)) != null) {
            String bmrID = queryOwner.getBmReferenceID();
            BMReference bm = this.getBMReference(bmrID);
            this.fillBoxArea(map, bm, true);
        }
        return map;
    }

    private void fillBoxArea(CompositeMap boxMap, BMReference bm, boolean query) {
        IFile file = bm.getModel();
        if (file != null) {
            BMCompositeMap bmc = new BMCompositeMap(file);
            CompositeMap ds = this.createDataSet(bmc, file, query);
            List fields = query ? bmc.getQueryFields() : bmc.getFieldsWithoutPk();
            String pkName = bmc.getPkFieldName();
            for (CompositeMap f : fields) {
                if (pkName != null && pkName.equals(f.get((Object)"field"))) continue;
                if (f.getString((Object)"field") != null) {
                    f = bmc.getFieldByName(f.getString((Object)"field"));
                }
                String inputType = this.getRecommendEditor(f);
                CompositeMap input = this.newMap(inputType);
                input.put((Object)"bindTarget", (Object)ds.getString((Object)"id"));
                input.put((Object)"name", (Object)f.getString((Object)"name"));
                input.put((Object)"prompt", (Object)f.getString((Object)"prompt"));
                boxMap.addChild(input);
            }
            this.dataSetsMap.addChild(ds);
        }
    }

    private String getRecommendEditor(CompositeMap f) {
        String inputType = null;
        String dataType = BMCompositeMap.getMapAttribute((CompositeMap)f, (String)"datatype");
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataType dt = dataTypeArray[n2];
            if (dt.getJavaType().equals(dataType)) {
                inputType = dt.getDefaultEditor();
                break;
            }
            ++n2;
        }
        if (inputType == null) {
            inputType = this.gussesEditor(f.getName());
        }
        return inputType;
    }

    private BMBindComponent getQueryOwner(Component c) {
        Component root = c;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        LinkedList<Component> queue = new LinkedList<Component>();
        queue.add(root);
        while (!queue.isEmpty()) {
            BMBindComponent bmbc;
            String queryContainer;
            Component com = (Component)queue.remove(0);
            if (com.getChildren() != null) {
                queue.addAll(com.getChildren());
            }
            if (!(com instanceof BMBindComponent) || (queryContainer = (bmbc = (BMBindComponent)com).getQueryComponent()) == null || !queryContainer.equals(c.getId())) continue;
            return bmbc;
        }
        return null;
    }

    private CompositeMap createMapFromGrid(Component ac2) {
        BMBindComponent bmbc;
        String bmrID;
        BMReference bm;
        CompositeMap map = this.newMap(ac2.getComponentType());
        map.put((Object)"id", (Object)ac2.getId());
        map.put((Object)"width", (Object)"800");
        map.put((Object)"height", (Object)"300");
        if (ac2.getChildren() != null) {
            for (Component c : ac2.getChildren()) {
                CompositeMap m = this.createMapFromCom(c);
                map.addChild(m);
            }
        }
        if (ac2 instanceof BMBindComponent && (bm = this.getBMReference(bmrID = (bmbc = (BMBindComponent)ac2).getBmReferenceID())) != null) {
            IFile file = bm.getModel();
            BMCompositeMap bmc = new BMCompositeMap(file);
            this.fillGridColumns(map, bmc, bm);
            CompositeMap ds = this.createDataSet(bmc, file, false);
            map.put((Object)"bindTarget", (Object)ds.getString((Object)"id"));
            Component queryComponent = this.comMap.get(bmbc.getQueryComponent());
            if (queryComponent instanceof BMBindComponent) {
                bm = this.getBMReference(((BMBindComponent)queryComponent).getBmReferenceID());
                if (bm != null) {
                    file = bm.getModel();
                    ds.put((Object)"bindTarget", (Object)this.getDataSetId(file, false));
                    ds.put((Object)"bindName", (Object)ds.getString((Object)"model").replace('.', '_'));
                }
            } else if (queryComponent != null) {
                ds.put((Object)"queryDataSet", (Object)this.getDataSetId(file, true));
            }
            this.dataSetsMap.addChild(ds);
        }
        return map;
    }

    private void fillGridColumns(CompositeMap gridMap, BMCompositeMap bmc, BMReference bm) {
        CompositeMap cols = this.newMap("columns");
        CompositeMap pkField = bmc.getFieldOfPk();
        List fields = bmc.getFields(false, true);
        if (pkField != null && "java.lang.String".equals(BMCompositeMap.getMapAttribute((CompositeMap)pkField, (String)"datatype"))) {
            fields.add(0, pkField);
        }
        HashMap<String, String> editorMapping = new HashMap<String, String>();
        boolean editable = this.oneOf(this.template.getType(), "update", "create");
        for (CompositeMap f : fields) {
            CompositeMap col = this.newMap("column");
            col.put((Object)"name", (Object)f.getString((Object)"name"));
            if (editable) {
                String editor = this.getRecommendEditor(f);
                String editorId = (String)editorMapping.get(editor);
                if (editorId == null) {
                    editorId = String.valueOf(gridMap.getString((Object)"id")) + "_" + editor + "_id";
                    editorMapping.put(editor, editorId);
                }
                col.put((Object)"editor", (Object)editorId);
            }
            col.put((Object)"prompt", (Object)f.getString((Object)"prompt"));
            col.put((Object)"width", (Object)100);
            cols.addChild(col);
        }
        gridMap.addChild(cols);
        if (editable) {
            CompositeMap editorsMap = this.newMap("editors");
            for (String s : editorMapping.keySet()) {
                CompositeMap eMap = this.newMap(s);
                eMap.put((Object)"id", editorMapping.get(s));
                editorsMap.addChild(eMap);
            }
            gridMap.addChild(editorsMap);
        }
    }

    private String getDataSetId(IFile file, boolean query) {
        String fileName = file.getName();
        int idx = fileName.lastIndexOf(46);
        fileName = fileName.substring(0, idx);
        return String.valueOf(fileName) + (query ? "_query_ds" : "_result_ds");
    }

    private CompositeMap createDataSet(BMCompositeMap bmc, IFile file, boolean query) {
        CompositeMap dsMap = this.newMap("dataSet");
        dsMap.put((Object)"id", (Object)this.getDataSetId(file, query));
        if (query) {
            dsMap.put((Object)"autoCreate", (Object)true);
        } else {
            String pkg = ResourceUtil.getBmPkgPath((IFile)file);
            dsMap.put((Object)"model", (Object)pkg);
        }
        CompositeMap fields = this.newMap("fields");
        List list = query ? bmc.getQueryFields() : bmc.getFields(true, true);
        for (CompositeMap f : list) {
            CompositeMap m = this.newMap("field");
            if (f.getString((Object)"field") != null) {
                f = bmc.getFieldByName(f.getString((Object)"field"));
            }
            m.put((Object)"name", f.get((Object)"name"));
            fields.addChild(m);
        }
        dsMap.addChild(fields);
        return dsMap;
    }

    private BMReference getBMReference(String bmrID) {
        return this.bmrMap.get(bmrID);
    }

    private String gussesEditor(String fieldName) {
        if (fieldName != null && fieldName.contains("date")) {
            return DataType.DATE.getDefaultEditor();
        }
        return DataType.TEXT.getDefaultEditor();
    }

    private boolean oneOf(String base, String ... target) {
        return Arrays.asList(target).contains(base);
    }

    private String createDataSetFunction(String op, String ds_id) {
        String fName = String.valueOf(op) + "_" + ds_id;
        String function = String.format("\nfunction %s(){\n\t$('%s').%s();\n}", fName, ds_id, op);
        this.scriptTemp.append(function);
        return fName;
    }

    public CompositeMap newMap(String ... para) {
        CommentCompositeMap m = new CommentCompositeMap();
        if (para == null || para.length == 0) {
            return m;
        }
        m.setName(para[0]);
        if (para.length > 1) {
            m.setPrefix(para[1]);
        } else {
            m.setPrefix("a");
        }
        if (para.length > 2) {
            m.setNameSpaceURI(para[2]);
        }
        return m;
    }
}

