/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.wizard;

import aurora.ide.builder.ResourceUtil;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.template.BMReference;
import aurora.ide.meta.gef.editors.template.Template;
import aurora.ide.meta.gef.editors.template.handle.TemplateFactory;
import aurora.ide.meta.gef.editors.template.handle.TemplateHandle;
import aurora.ide.meta.gef.editors.template.handle.TemplateHelper;
import aurora.ide.views.dialog.ResourceSelector;
import aurora.ide.views.wizard.Messages;
import aurora.ide.views.wizard.NewScreenWizard;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectBmWizardPage
extends WizardPage {
    private NewScreenWizard.UserInput us = null;
    private Composite container;
    private Template tpl = null;
    BmPathValidator validaor = new BmPathValidator();
    HashMap<Object, Boolean> finishFlag = new HashMap();
    ViewDiagram view = null;

    public SelectBmWizardPage() {
        super("wizardPage");
        this.setTitle(Messages.SelectBmWizardPage_1);
        this.setDescription(Messages.SelectBmWizardPage_2);
    }

    public void setUserInput(NewScreenWizard.UserInput input) {
        this.us = input;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        this.container.setLayout((Layout)new GridLayout(1, true));
        this.setControl((Control)this.container);
    }

    public void setVisible(boolean v) {
        if (this.tpl != this.us.template) {
            this.view = TemplateHelper.getInstance().createView(this.us.template);
            this.finishFlag.clear();
            this.dynamicCreate();
        }
        super.setVisible(v);
    }

    protected void dynamicCreate() {
        this.tpl = this.us.template;
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (!c.isDisposed()) {
                c.dispose();
            }
            ++n2;
        }
        List list = this.us.template.getBms();
        if (list != null && list.size() > 0) {
            this.createGroup(this.container, "Model", list);
            this.setPageComplete(false);
        }
        if ((list = this.us.template.getLinkBms()) != null && list.size() > 0) {
            this.createGroup(this.container, "Init-Model(optional)", list);
        }
        this.checkFinish();
        this.container.layout();
    }

    private void createGroup(Composite parent, String title, List<BMReference> content) {
        Group group = new Group(this.container, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setText(Messages.SelectBmWizardPage_5);
        group.setLayout((Layout)new GridLayout(3, false));
        for (BMReference bm : content) {
            this.createInputField((Composite)group, bm);
        }
    }

    private void createInputField(Composite parent, BMReference bm) {
        Label l = new Label(parent, 0);
        l.setText(bm.getName());
        Text t = new Text(parent, 2048);
        t.setLayoutData((Object)new GridData(768));
        t.setData("bm", (Object)bm);
        t.setText(this.getModelPath(bm));
        this.finishFlag.put(t, this.validatePath(t.getText()) == null);
        t.addModifyListener((ModifyListener)this.validaor);
        Button btn = new Button(parent, 0);
        btn.addSelectionListener((SelectionListener)new ButtonSelectionListener(t, bm));
        btn.setText(Messages.SelectBmWizardPage_7);
    }

    private String getModelPath(BMReference bm) {
        IFile f = bm.getModel();
        if (f != null) {
            return f.getFullPath().toString();
        }
        return "";
    }

    void checkFinish() {
        TemplateHandle handle;
        boolean res = true;
        for (Object o : this.finishFlag.keySet()) {
            res = this.finishFlag.get(o);
            if (!res) break;
        }
        if (res && (handle = TemplateFactory.getTemplateHandle((String)this.view.getTemplateType())) != null) {
            handle.fill(this.view);
        }
        this.setPageComplete(res);
    }

    public ViewDiagram getViewDiagram() {
        return this.view;
    }

    private String validatePath(String path) {
        IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        String msg = null;
        if (r == null) {
            msg = Messages.SelectBmWizardPage_9;
        } else if (!(r instanceof IFile) || !"bm".equals(r.getFileExtension())) {
            msg = Messages.SelectBmWizardPage_10;
        }
        return msg;
    }

    private class BmPathValidator
    implements ModifyListener {
        private BmPathValidator() {
        }

        public void modifyText(ModifyEvent e) {
            Text t = (Text)e.getSource();
            String path = t.getText();
            IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            String msg = SelectBmWizardPage.this.validatePath(path);
            ((BMReference)t.getData("bm")).setModel((IFile)r);
            t.setToolTipText(msg);
            SelectBmWizardPage.this.setErrorMessage(msg);
            t.setBackground(msg == null ? null : NewScreenWizard.WRONG_COLOR);
            SelectBmWizardPage.this.finishFlag.put(t, msg == null);
            SelectBmWizardPage.this.checkFinish();
        }
    }

    private class ButtonSelectionListener
    implements SelectionListener {
        private BMReference bm;
        private Text text;

        public ButtonSelectionListener(Text text, BMReference bm) {
            this.text = text;
            this.bm = bm;
        }

        public void widgetSelected(SelectionEvent e) {
            ResourceSelector rs = new ResourceSelector(SelectBmWizardPage.this.getShell());
            rs.setExtFilter(new String[]{"bm"});
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(((SelectBmWizardPage)SelectBmWizardPage.this).us.dir);
            if (!(res instanceof IContainer)) {
                rs.setInput((IContainer)ResourcesPlugin.getWorkspace().getRoot());
            } else {
                IProject proj = res.getProject();
                if (ResourceUtil.isAuroraProject((IProject)proj)) {
                    rs.setInput((IContainer)ResourceUtil.getBMHomeFolder((IProject)proj));
                } else {
                    rs.setInput((IContainer)proj);
                }
            }
            IResource sel = rs.getSelection();
            if (sel instanceof IFile) {
                this.bm.setModel((IFile)sel);
                this.text.setText(sel.getFullPath().toString());
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

