/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.views.wizard;

import aurora.ide.meta.MetaPlugin;
import aurora.ide.meta.gef.editors.template.Template;
import aurora.ide.meta.gef.editors.template.handle.TemplateHelper;
import aurora.ide.meta.gef.editors.wizard.dialog.TComposite;
import aurora.ide.views.dialog.ResourceSelector;
import aurora.ide.views.wizard.Messages;
import aurora.ide.views.wizard.NewScreenWizard;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SelectTemplatelWizardPage
extends WizardPage {
    private Text text_dir;
    private Text text_fileName;
    private Label lblDesc;
    private NewScreenWizard.UserInput us = null;
    private Button chkUseModel;

    public SelectTemplatelWizardPage() {
        super("wizardPage");
        this.setTitle(Messages.SelectTemplatelWizardPage_1);
        this.setDescription("Wizard Page description");
        this.setPageComplete(false);
    }

    public void setUserInput(NewScreenWizard.UserInput input) {
        this.us = input;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(container, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label.setText(Messages.SelectTemplatelWizardPage_3);
        this.text_dir = new Text(container, 2048);
        this.text_dir.setText(this.us.dir);
        this.text_dir.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Button button = new Button(container, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceSelector rs = new ResourceSelector(SelectTemplatelWizardPage.this.getShell());
                rs.setDirOnly(true);
                rs.setInput((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                IResource res = rs.getSelection();
                if (res == null) {
                    return;
                }
                SelectTemplatelWizardPage.this.text_dir.setText(res.getFullPath().toString());
                SelectTemplatelWizardPage.this.text_fileName.forceFocus();
            }
        });
        button.setText(Messages.SelectTemplatelWizardPage_4);
        Label label_1 = new Label(container, 0);
        label_1.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        label_1.setText(Messages.SelectTemplatelWizardPage_5);
        this.text_fileName = new Text(container, 2048);
        this.text_fileName.setText(this.us.fileName);
        this.text_fileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label(container, 0);
        IPath path = MetaPlugin.getDefault().getStateLocation().append("template");
        this.createTemplate(container, TemplateHelper.getInstance().getTemplates(path));
        this.createBottomComposite(container);
        this.initValidator();
        if (this.text_dir.getText().length() > 0) {
            this.text_fileName.forceFocus();
        }
    }

    private void createTemplate(Composite composite, Map<String, List<Template>> tempMap) {
        TComposite tComposite = new TComposite(composite, 2048, tempMap);
        tComposite.setLayoutData((Object)new GridData(4, 4, false, true, 3, 1));
        this.us.template = tComposite.getSelection();
        tComposite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TComposite t = (TComposite)e.getSource();
                ((SelectTemplatelWizardPage)SelectTemplatelWizardPage.this).us.template = t.getSelection();
                if (((SelectTemplatelWizardPage)SelectTemplatelWizardPage.this).us.template != null) {
                    SelectTemplatelWizardPage.this.setTemplateDescription(((SelectTemplatelWizardPage)SelectTemplatelWizardPage.this).us.template.getDescription());
                }
            }
        });
        composite.layout(true);
    }

    private void createBottomComposite(Composite container) {
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new FillLayout(512));
        composite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.lblDesc = new Label(composite, 0);
        new Label(composite, 0);
        this.chkUseModel = new Button(composite, 32);
        this.chkUseModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((SelectTemplatelWizardPage)SelectTemplatelWizardPage.this).us.noUseModel = SelectTemplatelWizardPage.this.chkUseModel.getSelection();
            }
        });
        this.chkUseModel.setSelection(this.us.noUseModel);
        this.chkUseModel.setText(Messages.SelectTemplatelWizardPage_7);
    }

    private void setTemplateDescription(String desc) {
        if (desc == null) {
            desc = "";
        }
        this.lblDesc.setText(desc);
        this.lblDesc.redraw();
    }

    private void initValidator() {
        ModifyListener ml = new ModifyListener(){
            private IWorkspace workspace = ResourcesPlugin.getWorkspace();
            private String[] msgs = new String[2];

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.getSource();
                if (t == SelectTemplatelWizardPage.this.text_dir) {
                    this.validateDir();
                } else {
                    this.validateFileName();
                }
                if (this.msgs[0] == null) {
                    SelectTemplatelWizardPage.this.setErrorMessage(this.msgs[1]);
                } else {
                    SelectTemplatelWizardPage.this.setErrorMessage(this.msgs[0]);
                }
                SelectTemplatelWizardPage.this.setPageComplete(SelectTemplatelWizardPage.this.getErrorMessage() == null);
            }

            void validateDir() {
                String dir;
                ((SelectTemplatelWizardPage)SelectTemplatelWizardPage.this).us.dir = dir = SelectTemplatelWizardPage.this.text_dir.getText();
                IStatus status = this.workspace.validatePath(dir, 6);
                this.msgs[0] = null;
                if (!status.isOK()) {
                    this.msgs[0] = status.getMessage();
                } else {
                    IResource res = this.workspace.getRoot().findMember(dir);
                    if (!(res instanceof IContainer)) {
                        this.msgs[0] = "Path '" + dir + "' does not exists (or not a folder).";
                    }
                }
                if (this.msgs[0] == null) {
                    this.validateFileName();
                }
            }

            void validateFileName() {
                String fn;
                ((SelectTemplatelWizardPage)SelectTemplatelWizardPage.this).us.fileName = fn = SelectTemplatelWizardPage.this.text_fileName.getText();
                if (this.msgs[0] != null) {
                    return;
                }
                if (!this.regExpCheck(fn)) {
                    return;
                }
                int idx = fn.indexOf(46);
                if (idx == -1) {
                    fn = String.valueOf(fn) + "." + "screen";
                }
                IPath path = new Path(SelectTemplatelWizardPage.this.text_dir.getText()).append(fn);
                this.msgs[1] = null;
                IResource res = this.workspace.getRoot().findMember(path);
                if (res != null) {
                    this.msgs[1] = String.valueOf(res.getClass().getSimpleName()) + " '" + fn + "' already exists.";
                }
            }

            boolean regExpCheck(String fn) {
                if (!new Path("").isValidSegment(fn)) {
                    this.msgs[1] = "'" + fn + "' is not a valid segment";
                    return false;
                }
                boolean res = fn.matches("[\\w\\d_]+(.screen)?");
                this.msgs[1] = "File name '" + fn + "' is not valid.";
                return res;
            }
        };
        this.text_dir.addModifyListener(ml);
        this.text_fileName.addModifyListener(ml);
    }
}

