/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.execute;

import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionVariable;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.TableNavigator;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterTableViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.execute.ParameterWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ParameterMarkerPage
extends WizardPage {
    private Vector parmMarkers;
    private Vector parmValues;
    private ParameterTableViewer paramMarkerTable;
    private Composite tablePanel;

    public ParameterMarkerPage(Vector parms) {
        super(Messages._UI_WIZARD_PARAMETER_MARKER_TITLE);
        this.parmMarkers = parms;
        this.setTitle(Messages._UI_WIZARD_PARAMETER_MARKER_HEADING);
        this.setDescription(Messages._UI_WIZARD_PARAMETER_MARKER_EXPL);
        this.setPageComplete(false);
        this.parmValues = new Vector();
    }

    public void createControl(Composite parent) {
        Composite mainPanel = new Composite(parent, 0);
        GridLayout mainPanelLayout = new GridLayout();
        mainPanel.setLayout((Layout)mainPanelLayout);
        mainPanel.setLayoutData((Object)ViewUtility.createFill());
        this.tablePanel = new Composite(mainPanel, 0);
        GridLayout tablePanelLayout = new GridLayout();
        this.tablePanel.setLayout((Layout)tablePanelLayout);
        this.tablePanel.setLayoutData((Object)ViewUtility.createFill());
        this.fillParameterMarkers();
        this.paramMarkerTable = new ParameterTableViewer(this, 68354, this.tablePanel, this.parmMarkers);
        this.paramMarkerTable.getTable().setLinesVisible(true);
        this.paramMarkerTable.getTable().setLayoutData((Object)ViewUtility.createFill());
        this.paramMarkerTable.setInput(this.parmValues);
        Control[] tmp = this.paramMarkerTable.getTable().getChildren();
        int i = 0;
        while (i < tmp.length) {
            if (tmp[i] instanceof TableNavigator && !tmp[i].isDisposed()) {
                tmp[i].setVisible(false);
                break;
            }
            ++i;
        }
        this.setControl((Control)mainPanel);
    }

    private void fillParameterMarkers() {
        int i = 0;
        while (i < this.parmMarkers.size()) {
            String defaultValue = "";
            this.parmValues.add(defaultValue);
            ++i;
        }
        this.updateFinishButton();
    }

    public boolean updateFinishButton() {
        boolean ready = true;
        int i = 0;
        while (i < this.parmMarkers.size()) {
            if (this.parmValues.elementAt(i) == null || this.parmValues.elementAt(i).equals("")) {
                ready = false;
            }
            ++i;
        }
        this.appendQuotes();
        this.setPageComplete(ready);
        return ready;
    }

    private void appendQuotes() {
        ExpressionHelper eh = new ExpressionHelper();
        eh.setQuotesContext("");
        int i = 0;
        while (i < this.parmMarkers.size()) {
            Object aParm;
            if (this.parmValues.elementAt(i) != null && !this.parmValues.elementAt(i).equals("") && (aParm = this.parmMarkers.elementAt(i)) instanceof ValueExpressionVariable) {
                ValueExpressionVariable var = (ValueExpressionVariable)aParm;
                DataType dType = var.getDataType();
                this.parmValues.setElementAt(eh.appendQuotes(dType, this.parmValues.elementAt(i).toString()), i);
            }
            ++i;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.performOk();
    }

    public boolean performOk() {
        if (this.getWizard() instanceof ParameterWizard) {
            ((ParameterWizard)this.getWizard()).setValueMarkers(this.parmValues);
        }
        return true;
    }

    public Vector getParameterMarkers() {
        return this.parmValues;
    }
}

