/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.annotations.registry;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.common.internal.annotations.registry.AnnotationTagsetRegistry;
import org.eclipse.jst.common.internal.annotations.registry.AttributeValuesHelper;

public class TagsetDescriptor {
    public static final String TAGSET = "AnnotationTagSet";
    public static final String ATT_NAME = "name";
    public static final String ATT_DISPLAY_NAME = "displayName";
    public static final String ATT_DESCRIPTION = "description";
    public static final String ATT_PARENT_TAGSET = "parentTagset";
    public static final String ATT_VALID_VALUES_HELPER = "validValuesHelper";
    private final IConfigurationElement element;
    protected String name;
    protected String displayName;
    protected String description;
    protected String parentTagset;
    protected AttributeValuesHelper validValuesHelper;

    protected TagsetDescriptor() {
        this.element = null;
    }

    public TagsetDescriptor(IConfigurationElement element) {
        this.element = element;
        this.init();
    }

    private void init() {
        this.name = this.element.getAttribute(ATT_NAME);
        this.displayName = this.element.getAttribute(ATT_DISPLAY_NAME);
        this.description = this.element.getAttribute(ATT_DESCRIPTION);
        this.parentTagset = this.element.getAttribute(ATT_PARENT_TAGSET);
        try {
            String validValuesHelperName = this.element.getAttribute(ATT_VALID_VALUES_HELPER);
            if (validValuesHelperName != null) {
                Class<?> loaded = Class.forName(validValuesHelperName);
                this.validValuesHelper = (AttributeValuesHelper)loaded.newInstance();
            }
        }
        catch (Exception exception) {}
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public IConfigurationElement getElement() {
        return this.element;
    }

    public String getName() {
        return this.name;
    }

    public String getParentTagset() {
        return this.parentTagset;
    }

    public TagsetDescriptor[] getDirectDependents() {
        if (this.getName() == null || this.getName().equals("")) {
            return new TagsetDescriptor[0];
        }
        ArrayList<TagsetDescriptor> dependents = new ArrayList<TagsetDescriptor>();
        TagsetDescriptor descriptor2 = null;
        for (TagsetDescriptor descriptor2 : AnnotationTagsetRegistry.INSTANCE.getDescriptors()) {
            if (!this.getName().equals(descriptor2.getParentTagset())) continue;
            dependents.add(descriptor2);
        }
        TagsetDescriptor[] descriptors = new TagsetDescriptor[dependents.size()];
        dependents.toArray(descriptors);
        return descriptors;
    }

    public AttributeValuesHelper getValidValuesHelper() {
        return this.validValuesHelper;
    }

    public void setValidValuesHelper(AttributeValuesHelper validValuesHelper) {
        this.validValuesHelper = validValuesHelper;
    }
}

