/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jpt.common.utility.JavaType;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.SimpleJavaType;
import org.eclipse.jpt.common.utility.internal.SimpleMethodSignature;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTTools {
    public static CompilationUnit buildASTRoot(ICompilationUnit compilationUnit) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(compilationUnit);
        parser.setIgnoreMethodBodies(true);
        parser.setResolveBindings(true);
        parser.setBindingsRecovery(true);
        return (CompilationUnit)parser.createAST(null);
    }

    public static String resolveEnum(Expression expression) {
        if (expression == null) {
            return null;
        }
        switch (expression.getNodeType()) {
            case 40: 
            case 42: {
                return ASTTools.resolveEnum((Name)expression);
            }
        }
        return null;
    }

    public static String resolveEnum(Name enumExpression) {
        IBinding binding = enumExpression.resolveBinding();
        if (binding == null) {
            return null;
        }
        if (binding.getKind() != 3) {
            return null;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        return String.valueOf(variableBinding.getType().getQualifiedName()) + '.' + variableBinding.getName();
    }

    public static String resolveAnnotation(Annotation node) {
        IAnnotationBinding annotationBinding = node.resolveAnnotationBinding();
        if (annotationBinding == null) {
            return null;
        }
        ITypeBinding annotationTypeBinding = annotationBinding.getAnnotationType();
        return annotationTypeBinding == null ? null : annotationTypeBinding.getQualifiedName();
    }

    public static String resolveFullyQualifiedName(Expression expression) {
        ITypeBinding resolvedTypeBinding = ASTTools.resolveTypeBinding(expression);
        return resolvedTypeBinding == null ? null : resolvedTypeBinding.getQualifiedName();
    }

    public static Iterable<String> resolveFullyQualifiedNames(Expression expression) {
        return new TransformationIterable<ITypeBinding, String>(ASTTools.resolveTypeBindings(expression)){

            protected String transform(ITypeBinding o) {
                return o == null ? null : o.getQualifiedName();
            }
        };
    }

    public static ITypeBinding resolveTypeBinding(Expression expression) {
        if (expression.getNodeType() == 57) {
            return ((TypeLiteral)expression).getType().resolveBinding();
        }
        return null;
    }

    public static Iterable<ITypeBinding> resolveTypeBindings(Expression expression) {
        if (expression.getNodeType() == 4) {
            ArrayInitializer arrayExpression = (ArrayInitializer)expression;
            return new TransformationIterable<Expression, ITypeBinding>((Iterable)arrayExpression.expressions()){

                protected ITypeBinding transform(Expression o) {
                    return ASTTools.resolveTypeBinding(o);
                }
            };
        }
        return EmptyIterable.instance();
    }

    public static MethodSignature buildMethodSignature(MethodDeclaration methodDeclaration) {
        return new SimpleMethodSignature(methodDeclaration.getName().getFullyQualifiedName(), ASTTools.buildParameterTypes(methodDeclaration));
    }

    public static JavaType[] buildParameterTypes(MethodDeclaration methodDeclaration) {
        List<SingleVariableDeclaration> parameters = ASTTools.parameters(methodDeclaration);
        int len = parameters.size();
        JavaType[] parameterTypes = new JavaType[len];
        int i = 0;
        while (i < len) {
            ITypeBinding type = parameters.get(i).getType().resolveBinding();
            parameterTypes[i] = new SimpleJavaType(type.getQualifiedName(), type.getDimensions());
            ++i;
        }
        return parameterTypes;
    }

    private static List<SingleVariableDeclaration> parameters(MethodDeclaration methodDeclaration) {
        return methodDeclaration.parameters();
    }

    public static boolean typeIsSubTypeOf(Expression expression, String searchTypeName) {
        return ASTTools.findTypeInHierarchy(expression, searchTypeName) != null;
    }

    public static ITypeBinding findTypeInHierarchy(Expression expression, String searchTypeName) {
        ITypeBinding typeBinding = ASTTools.resolveTypeBinding(expression);
        return typeBinding == null ? null : ASTTools.findTypeInHierarchy(typeBinding, searchTypeName);
    }

    public static boolean typeIsSubTypeOf(ITypeBinding typeBinding, String searchTypeName) {
        return ASTTools.findTypeInHierarchy(typeBinding, searchTypeName) != null;
    }

    public static ITypeBinding findTypeInHierarchy(ITypeBinding typeBinding, String searchTypeName) {
        return ASTTools.findTypeInHierarchy(typeBinding, searchTypeName, new HashSet<String>());
    }

    private static ITypeBinding findTypeInHierarchy(ITypeBinding typeBinding, String searchTypeName, HashSet<String> visited) {
        String typeName = typeBinding.getTypeDeclaration().getQualifiedName();
        if (visited.contains(typeName)) {
            return null;
        }
        if (typeName.equals(searchTypeName)) {
            return typeBinding;
        }
        visited.add(typeName);
        ITypeBinding interfaceBinding = ASTTools.findTypeInInterfaces(typeBinding, searchTypeName, visited);
        if (interfaceBinding != null) {
            return interfaceBinding;
        }
        return ASTTools.findTypeInSuperclasses(typeBinding, searchTypeName, visited);
    }

    private static ITypeBinding findTypeInInterfaces(ITypeBinding typeBinding, String searchTypeName, HashSet<String> visited) {
        ITypeBinding[] interfaceBindings;
        ITypeBinding[] iTypeBindingArray = interfaceBindings = typeBinding.getInterfaces();
        int n = interfaceBindings.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding interfaceBinding = iTypeBindingArray[n2];
            ITypeBinding result = ASTTools.findTypeInHierarchy(interfaceBinding, searchTypeName, visited);
            if (result != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    private static ITypeBinding findTypeInSuperclasses(ITypeBinding typeBinding, String searchTypeName, HashSet<String> visited) {
        ITypeBinding result;
        ITypeBinding superBinding = typeBinding.getSuperclass();
        if (superBinding != null && (result = ASTTools.findTypeInHierarchy(superBinding, searchTypeName, visited)) != null) {
            return result;
        }
        return null;
    }

    public static boolean typeImplementsInterface(Expression expression, String searchInterfaceName) {
        ITypeBinding typeBinding = ASTTools.resolveTypeBinding(expression);
        if (typeBinding == null) {
            return false;
        }
        return ASTTools.findInterfaceInHierarchy(typeBinding, searchInterfaceName) != null;
    }

    public static boolean typeImplementsInterface(ITypeBinding typeBinding, String searchInterfaceName) {
        return ASTTools.findInterfaceInHierarchy(typeBinding, searchInterfaceName) != null;
    }

    private static ITypeBinding findInterfaceInHierarchy(ITypeBinding typeBinding, String searchInterfaceName) {
        HashSet<String> visited = new HashSet<String>();
        ITypeBinding interfaceBinding = ASTTools.findTypeInInterfaces(typeBinding, searchInterfaceName, visited);
        if (interfaceBinding != null) {
            return interfaceBinding;
        }
        return ASTTools.findTypeInSuperclasses(typeBinding, searchInterfaceName, visited);
    }
}

