/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.utility.jdt;

import java.util.List;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTNodeTextRange;
import org.eclipse.jpt.common.core.internal.utility.jdt.DefaultAnnotationEditFormatter;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTMember;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AbstractType;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.CommandExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJDTType
extends JDTMember
implements AbstractType {
    protected AbstractJDTType(AbstractTypeDeclaration typeDeclaration, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor) {
        this(typeDeclaration, compilationUnit, modifySharedDocumentCommandExecutor, (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    protected AbstractJDTType(AbstractTypeDeclaration typeDeclaration, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor, AnnotationEditFormatter annotationEditFormatter) {
        this(null, typeDeclaration, 1, compilationUnit, modifySharedDocumentCommandExecutor, annotationEditFormatter);
    }

    protected AbstractJDTType(Type declaringType, AbstractTypeDeclaration typeDeclaration, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor) {
        this(declaringType, typeDeclaration, occurrence, compilationUnit, modifySharedDocumentCommandExecutor, (AnnotationEditFormatter)DefaultAnnotationEditFormatter.instance());
    }

    protected AbstractJDTType(Type declaringType, AbstractTypeDeclaration typeDeclaration, int occurrence, ICompilationUnit compilationUnit, CommandExecutor modifySharedDocumentCommandExecutor, AnnotationEditFormatter annotationEditFormatter) {
        super(declaringType, typeDeclaration.getName().getFullyQualifiedName(), occurrence, compilationUnit, modifySharedDocumentCommandExecutor, annotationEditFormatter);
    }

    protected AbstractJDTType(Type declaringType, String name, int occurrence, ICompilationUnit compilationUnit) {
        super(declaringType, name, occurrence, compilationUnit, CommandExecutor.Default.instance(), DefaultAnnotationEditFormatter.instance());
    }

    @Override
    protected Type getDeclaringType() {
        return (Type)super.getDeclaringType();
    }

    @Override
    public ITypeBinding getBinding(CompilationUnit astRoot) {
        AbstractTypeDeclaration td = this.getBodyDeclaration(astRoot);
        return td == null ? null : td.resolveBinding();
    }

    @Override
    public AbstractTypeDeclaration getBodyDeclaration(CompilationUnit astRoot) {
        Type declaringType = this.getDeclaringType();
        if (declaringType == null) {
            return this.getTopLevelTypeDeclaration(astRoot);
        }
        TypeDeclaration typeDeclaration = declaringType.getBodyDeclaration(astRoot);
        return typeDeclaration == null ? null : this.getNestedTypeDeclaration(typeDeclaration);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        AbstractTypeDeclaration bodyDeclaration = this.getBodyDeclaration(astRoot);
        return bodyDeclaration == null ? null : new ASTNodeTextRange((ASTNode)bodyDeclaration.getName());
    }

    protected AbstractTypeDeclaration getTopLevelTypeDeclaration(CompilationUnit astRoot) {
        return this.getTypeDeclaration(AbstractJDTType.types(astRoot));
    }

    protected AbstractTypeDeclaration getTypeDeclaration(List<AbstractTypeDeclaration> typeDeclarations) {
        return this.getTypeDeclaration(typeDeclarations.toArray(new AbstractTypeDeclaration[typeDeclarations.size()]));
    }

    protected abstract AbstractTypeDeclaration getNestedTypeDeclaration(TypeDeclaration var1);

    protected AbstractTypeDeclaration getTypeDeclaration(AbstractTypeDeclaration[] typeDeclarations) {
        String name = this.getName();
        int occurrence = this.getOccurrence();
        int count = 0;
        AbstractTypeDeclaration[] abstractTypeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractTypeDeclaration typeDeclaration = abstractTypeDeclarationArray[n2];
            if (typeDeclaration.getName().getFullyQualifiedName().equals(name) && ++count == occurrence) {
                return typeDeclaration.getNodeType() == this.getASTNodeType() ? typeDeclaration : null;
            }
            ++n2;
        }
        return null;
    }

    protected abstract int getASTNodeType();

    protected static List<AbstractTypeDeclaration> types(CompilationUnit astRoot) {
        return astRoot.types();
    }

    protected static EnumDeclaration[] getEnums(TypeDeclaration declaringTypeDeclaration) {
        List<BodyDeclaration> bd = AbstractJDTType.bodyDeclarations(declaringTypeDeclaration);
        int typeCount = 0;
        ListIterator<BodyDeclaration> it = bd.listIterator();
        while (it.hasNext()) {
            if (((BodyDeclaration)it.next()).getNodeType() != 71) continue;
            ++typeCount;
        }
        EnumDeclaration[] memberEnums = new EnumDeclaration[typeCount];
        int next = 0;
        ListIterator<BodyDeclaration> it2 = bd.listIterator();
        while (it2.hasNext()) {
            BodyDeclaration decl = (BodyDeclaration)it2.next();
            if (decl.getNodeType() != 71) continue;
            memberEnums[next++] = (EnumDeclaration)decl;
        }
        return memberEnums;
    }

    protected static List<BodyDeclaration> bodyDeclarations(TypeDeclaration typeDeclaration) {
        return typeDeclaration.bodyDeclarations();
    }
}

