/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;

public class CodeFormatFix
implements IFix {
    private final IJavaScriptUnit fCompilationUnit;
    private final TextChange fChange;

    public static IFix createCleanUp(IJavaScriptUnit cu, boolean format, boolean removeTrailingWhitespacesAll, boolean removeTrailingWhitespacesIgnorEmpty) throws CoreException {
        if (!(format || removeTrailingWhitespacesAll || removeTrailingWhitespacesIgnorEmpty)) {
            return null;
        }
        if (format) {
            Document document;
            HashMap fomatterSettings = new HashMap(cu.getJavaScriptProject().getOptions(true));
            String content = cu.getBuffer().getContents();
            TextEdit edit = CodeFormatterUtil.reformat(8, content, 0, TextUtilities.getDefaultLineDelimiter((IDocument)(document = new Document(content))), fomatterSettings);
            if (edit == null || !edit.hasChildren()) {
                return null;
            }
            String label = MultiFixMessages.CodeFormatFix_description;
            CompilationUnitChange change = new CompilationUnitChange(label, cu);
            change.setEdit(edit);
            CategorizedTextEditGroup group = new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
            group.addTextEdit(edit);
            change.addTextEditGroup((TextEditGroup)group);
            return new CodeFormatFix((TextChange)change, cu);
        }
        if (removeTrailingWhitespacesAll || removeTrailingWhitespacesIgnorEmpty) {
            MultiTextEdit multiEdit;
            block15: {
                try {
                    multiEdit = new MultiTextEdit();
                    Document document = new Document(cu.getBuffer().getContents());
                    int lineCount = document.getNumberOfLines();
                    int i = 0;
                    while (i < lineCount) {
                        IRegion region = document.getLineInformation(i);
                        if (region.getLength() != 0) {
                            int lineStart = region.getOffset();
                            int lineExclusiveEnd = lineStart + region.getLength();
                            int j = CodeFormatFix.getIndexOfRightMostNoneWhitspaceCharacter(lineStart, lineExclusiveEnd - 1, document);
                            if (removeTrailingWhitespacesAll) {
                                if (++j < lineExclusiveEnd) {
                                    multiEdit.addChild((TextEdit)new DeleteEdit(j, lineExclusiveEnd - j));
                                }
                            } else if (removeTrailingWhitespacesIgnorEmpty && j >= lineStart) {
                                if (document.getChar(j) == '*' && CodeFormatFix.getIndexOfRightMostNoneWhitspaceCharacter(lineStart, j - 1, document) < lineStart) {
                                    ++j;
                                }
                                if (++j < lineExclusiveEnd) {
                                    multiEdit.addChild((TextEdit)new DeleteEdit(j, lineExclusiveEnd - j));
                                }
                            }
                        }
                        ++i;
                    }
                    if (multiEdit.getChildrenSize() != 0) break block15;
                    return null;
                }
                catch (BadLocationException x) {
                    throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), 0, "", (Throwable)x));
                }
            }
            String label = MultiFixMessages.CodeFormatFix_RemoveTrailingWhitespace_changeDescription;
            CompilationUnitChange change = new CompilationUnitChange(label, cu);
            change.setEdit((TextEdit)multiEdit);
            CategorizedTextEditGroup group = new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label)));
            group.addTextEdit((TextEdit)multiEdit);
            change.addTextEditGroup((TextEditGroup)group);
            return new CodeFormatFix((TextChange)change, cu);
        }
        return null;
    }

    private static int getIndexOfRightMostNoneWhitspaceCharacter(int start, int end, Document document) throws BadLocationException {
        int position = end;
        while (position >= start && Character.isWhitespace(document.getChar(position))) {
            --position;
        }
        return position;
    }

    public CodeFormatFix(TextChange change, IJavaScriptUnit compilationUnit) {
        this.fChange = change;
        this.fCompilationUnit = compilationUnit;
    }

    public TextChange createChange() throws CoreException {
        return this.fChange;
    }

    public IJavaScriptUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public String getDescription() {
        return MultiFixMessages.CodeFormatFix_description;
    }

    public IStatus getStatus() {
        return StatusInfo.OK_STATUS;
    }
}

