/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.wizards;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.ui.wizards.IJsGlobalScopeContainerPage;
import org.eclipse.wst.jsdt.ui.wizards.IJsGlobalScopeContainerPageExtension;
import org.eclipse.wst.jsdt.ui.wizards.IJsGlobalScopeContainerPageExtension2;
import org.eclipse.wst.jsdt.ui.wizards.NewElementWizardPage;

public class BaseLibraryWizardPage
extends NewElementWizardPage
implements IJsGlobalScopeContainerPage,
IJsGlobalScopeContainerPageExtension,
IJsGlobalScopeContainerPageExtension2 {
    private static final String HTML5 = "html5";
    private static final String STANDARD_BROWSER = "/StandardBrowser/";
    private IPath fPath = Path.ROOT;
    private ComboDialogField fVersionField;

    private static IPath newDefaultPath() {
        return BaseLibraryWizardPage.newV401Path();
    }

    private static Path newV401Path() {
        return new Path("org.eclipse.wst.jsdt.launching.baseBrowserLibrary");
    }

    private static Path newV5Path() {
        return new Path("org.eclipse.wst.jsdt.launching.baseBrowserLibrary/StandardBrowser/html5");
    }

    public BaseLibraryWizardPage() {
        super("BasicLibraryWizardPage");
        this.setTitle(NewWizardMessages.BaseLibraryWizardPage_title);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        DialogField field = new DialogField();
        field.setLabelText(NewWizardMessages.BaseLibraryWizardPage_DefaultBrowserLibraryAdded);
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{field}, false, -1, -1);
        this.fVersionField = new ComboDialogField(8);
        this.fVersionField.setLabelText(NewWizardMessages.BaseLibraryWizardPage_DOM_objects_version);
        this.fVersionField.setItems(new String[]{NewWizardMessages.BaseLibraryWizardPage_HTML401, NewWizardMessages.BaseLibraryWizardPage_HTML5});
        if (this.fPath.segmentCount() > 2 && this.fPath.lastSegment().equals(HTML5)) {
            this.fVersionField.selectItem(1);
        } else {
            this.fVersionField.selectItem(0);
        }
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{field, this.fVersionField}, false, -1, -1);
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.setDescription(NewWizardMessages.BaseLibraryWizardPage_WebBrowserSupport);
    }

    public boolean finish() {
        if (this.fVersionField == null) {
            this.fPath = BaseLibraryWizardPage.newDefaultPath();
        } else {
            switch (this.fVersionField.getSelectionIndex()) {
                case 0: {
                    this.fPath = BaseLibraryWizardPage.newV401Path();
                    break;
                }
                case 1: {
                    this.fPath = BaseLibraryWizardPage.newV5Path();
                    break;
                }
                default: {
                    this.fPath = BaseLibraryWizardPage.newDefaultPath();
                }
            }
        }
        return true;
    }

    public IIncludePathEntry[] getNewContainers() {
        if (this.fPath == null || this.fPath.isRoot()) {
            this.fPath = BaseLibraryWizardPage.newDefaultPath();
        }
        IIncludePathEntry library = JavaScriptCore.newContainerEntry((IPath)this.fPath);
        return new IIncludePathEntry[]{library};
    }

    public IIncludePathEntry getSelection() {
        return JavaScriptCore.newContainerEntry((IPath)this.fPath);
    }

    public void initialize(IJavaScriptProject project, IIncludePathEntry[] currentEntries) {
        this.fPath = BaseLibraryWizardPage.newDefaultPath();
        int i = 0;
        while (i < currentEntries.length) {
            IPath path = currentEntries[i].getPath();
            if (!path.isEmpty() && "org.eclipse.wst.jsdt.launching.baseBrowserLibrary".equals(path.segment(0))) {
                this.fPath = path;
            }
            ++i;
        }
    }

    public void setSelection(IIncludePathEntry containerEntry) {
        if (containerEntry != null) {
            this.fPath = containerEntry.getPath();
        }
    }
}

