/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util;

import com.objfac.util.IntArrayList;
import com.objfac.util.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PartialOrder {
    private List partialOrder;
    private IntArrayList counts = new IntArrayList();
    private ArrayList needs;
    private HashMap indices;
    private ArrayList objects;
    private IntArrayList indirection;
    private BitSet traversed;
    private int head;
    private IntArrayList headStack;
    private BitSet marked;
    private BitSet[] transitiveDependencies;

    public PartialOrder() {
        this.counts.add(0);
        this.needs = new ArrayList();
        this.needs.add(null);
        this.indices = new HashMap();
        this.objects = new ArrayList();
        this.objects.add(null);
        this.head = 0;
    }

    public void dependsOn(Object object, Object object2) {
        if (!object.equals(object2)) {
            int n = this.getIndex(object);
            int n2 = this.getIndex(object2);
            this.addTo(n, new Need(n2));
        } else {
            this.getIndex(object);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getPartialOrder() {
        if (this.partialOrder != null) return this.partialOrder;
        IntArrayList intArrayList = new IntArrayList();
        intArrayList.addAll(this.counts);
        try {
            this.partialOrder = this.knuthAlgorithm();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.counts = intArrayList;
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.counts = intArrayList;
            return this.partialOrder;
        }
    }

    public void removeCycles() {
        PartialOrder partialOrder = this.decycle();
        if (partialOrder != null) {
            this.counts = partialOrder.counts;
            this.needs = partialOrder.needs;
            this.indices = partialOrder.indices;
            this.objects = partialOrder.objects;
        }
    }

    public void clusterDependencies() {
        PartialOrder partialOrder = this.cluster();
        if (partialOrder != null) {
            this.counts = partialOrder.counts;
            this.needs = partialOrder.needs;
            this.indices = partialOrder.indices;
            this.objects = partialOrder.objects;
        }
    }

    public Map computeOptimalParents(List list) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            hashMap2.put(iterator.next(), new Integer(n));
            ++n;
        }
        n = list.size();
        if (n > 0) {
            BitSet bitSet = new BitSet();
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                bitSet.clear();
                this.setSuccessors(e, bitSet, hashMap2);
                ArrayList arrayList = new ArrayList();
                int n3 = n2;
                while ((n3 = bitSet.nextSetBit(n3 + 1)) >= 0) {
                    Object e2 = list.get(n3);
                    arrayList.add(e2);
                }
                arrayList.trimToSize();
                hashMap.put(e, arrayList);
                ++n2;
            }
        }
        return hashMap;
    }

    public Map computeUniqueParents(List list) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            hashMap2.put(iterator.next(), new Integer(n));
            ++n;
        }
        n = list.size();
        if (n > 0) {
            BitSet bitSet;
            Object e;
            BitSet[] bitSetArray = new BitSet[n];
            int n2 = 0;
            while (n2 < n) {
                e = list.get(n2);
                if (n2 > 0 && bitSetArray[n2 - 1].get(n2)) {
                    bitSetArray[n2] = bitSetArray[n2 - 1];
                } else {
                    bitSet = new BitSet();
                    this.setSuccessors(e, bitSet, hashMap2);
                    bitSetArray[n2] = bitSet;
                }
                ++n2;
            }
            n2 = 0;
            while (n2 < n) {
                e = list.get(n2);
                bitSet = new BitSet();
                int n3 = 0;
                while (n3 < bitSetArray.length) {
                    if (n3 == n2 || bitSetArray[n3].get(n2)) {
                        bitSet.or(bitSetArray[n3]);
                    }
                    ++n3;
                }
                n3 = bitSet.nextSetBit(n2 + 1);
                if (n3 >= 0) {
                    hashMap.put(e, list.get(n3));
                }
                ++n2;
            }
        }
        return hashMap;
    }

    private void setSuccessors(Object object, BitSet bitSet, HashMap hashMap) {
        Integer n = (Integer)this.indices.get(object);
        Need need = (Need)this.needs.get(n);
        while (need != null) {
            Object e = this.objects.get(need.index);
            Integer n2 = (Integer)hashMap.get(e);
            bitSet.set(n2);
            this.setSuccessors(e, bitSet, hashMap);
            need = need.next;
        }
    }

    private void addNeeds(int n, HashSet hashSet) {
        Need need = (Need)this.needs.get(n);
        while (need != null) {
            hashSet.add(this.objects.get(need.index));
            need = need.next;
        }
    }

    private boolean ifNeeds(int n, HashSet hashSet) {
        Need need = (Need)this.needs.get(n);
        while (need != null) {
            if (hashSet.contains(this.objects.get(need.index))) {
                return true;
            }
            if (this.ifNeeds(need.index, hashSet)) {
                return true;
            }
            need = need.next;
        }
        return false;
    }

    private int getIndex(Object object) {
        Integer n = (Integer)this.indices.get(object);
        if (n == null) {
            n = new Integer(this.objects.size());
            this.counts.add(0);
            this.needs.add(null);
            this.objects.add(object);
            this.indices.put(object, n);
        }
        return n;
    }

    private void addTo(int n, Need need) {
        need.next = (Need)this.needs.get(n);
        if (need.next != null) {
            need.next.prev = need;
        }
        need.parent = n;
        this.needs.set(n, need);
        this.increment(this.counts, need.index);
        this.partialOrder = null;
    }

    private List knuthAlgorithm() {
        ArrayList arrayList = new ArrayList();
        int n = 1;
        int n2 = this.counts.size();
        while (n < n2) {
            if (this.counts.get(n) == 0) {
                this.addToQueue(n);
            }
            ++n;
        }
        n = 0;
        while ((n2 = this.counts.get(0)) > 0) {
            arrayList.add(this.objects.get(n2));
            this.counts.set(0, this.counts.get(n2));
            ++n;
            Need need = (Need)this.needs.get(n2);
            while (need != null) {
                int n3 = this.counts.get(need.index) - 1;
                this.counts.set(need.index, n3);
                if (n3 == 0) {
                    this.addToQueue(need.index);
                }
                need = need.next;
            }
        }
        if (n + 1 < this.objects.size()) {
            throw new IllegalStateException(Messages.partialOrderCycle);
        }
        return arrayList;
    }

    private void addToQueue(int n) {
        this.counts.set(n, this.counts.get(0));
        this.counts.set(0, n);
    }

    private void dependsOn(int n, int n2) {
        this.addTo(n, new Need(n2));
    }

    private PartialOrder cluster() {
        int n;
        Object object;
        int n2 = this.counts.size();
        this.indirection = new IntArrayList();
        int n3 = 0;
        while (n3 < this.counts.size()) {
            this.indirection.add(n3);
            ++n3;
        }
        this.traversed = new BitSet();
        List list = this.getPartialOrder();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (Integer)this.indices.get(iterator.next());
            n = (Integer)object;
            if (this.traversed.get(n)) continue;
            this.cluster(n);
        }
        if (n2 == this.counts.size()) {
            return null;
        }
        this.partialOrder = null;
        object = new PartialOrder();
        n = 1;
        int n4 = this.counts.size();
        while (n < n4) {
            if (this.indirection.get(n) == n) {
                HashSet hashSet = new HashSet();
                this.updateDependencies(n, hashSet);
                this.addToOrder((PartialOrder)object, n);
            }
            ++n;
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private void addToOrder(PartialOrder var1_1, int var2_2) {
        block1: {
            var3_3 = this.objects.get(var2_2);
            var4_4 = (Need)this.needs.get(var2_2);
            if (var4_4 != null) ** GOTO lbl8
            var1_1.dependsOn(var3_3, var3_3);
            break block1;
lbl-1000:
            // 1 sources

            {
                var1_1.dependsOn(var3_3, this.objects.get(var4_4.index));
                var4_4 = var4_4.next;
lbl8:
                // 2 sources

                ** while (var4_4 != null)
            }
        }
    }

    private void cluster(int n) {
        this.traversed.set(n);
        CycleSet cycleSet = null;
        int n2 = -1;
        BitSet bitSet = new BitSet();
        System.out.println(this.objects.get(n).toString());
        IntArrayList intArrayList = new IntArrayList();
        int n3 = 0;
        while (n3 < this.counts.size()) {
            intArrayList.add(0);
            ++n3;
        }
        this.visitDependencies(n, intArrayList, bitSet);
        n3 = 1;
        while (n3 < intArrayList.size()) {
            int n4 = this.counts.get(n3);
            if (n4 == intArrayList.get(n3)) {
                n2 = this.counts.size();
                this.indirection.set(n, n2);
                this.indirection.add(n2);
                cycleSet = new CycleSet();
                cycleSet.add(this.objects.get(n));
                this.counts.add(this.counts.get(n));
                this.counts.set(n, -1);
                this.objects.add(cycleSet);
                this.needs.add(null);
                break;
            }
            ++n3;
        }
        if (cycleSet == null) {
            return;
        }
        bitSet.clear();
        this.moveDependencies(n, cycleSet, n2, bitSet, intArrayList);
    }

    private void visitDependencies(int n, IntArrayList intArrayList, BitSet bitSet) {
        Need need = (Need)this.needs.get(n);
        while (need != null) {
            this.increment(intArrayList, need.index);
            if (!bitSet.get(need.index)) {
                bitSet.set(need.index);
                this.visitDependencies(need.index, intArrayList, bitSet);
            }
            need = need.next;
        }
    }

    private void decrement(IntArrayList intArrayList, int n) {
        intArrayList.set(n, intArrayList.get(n) - 1);
    }

    private void increment(IntArrayList intArrayList, int n) {
        intArrayList.set(n, intArrayList.get(n) + 1);
    }

    private void cluster(int n, CycleSet cycleSet, int n2, BitSet bitSet, IntArrayList intArrayList) {
        this.counts.set(n, -1);
        this.traversed.set(n);
        if (!bitSet.get(n)) {
            bitSet.set(n);
            cycleSet.add(this.objects.get(n));
            this.indirection.set(n, n2);
            System.out.println(" uniquely refs " + this.objects.get(n).toString());
            this.moveDependencies(n, cycleSet, n2, bitSet, intArrayList);
        }
    }

    private void moveDependencies(int n, CycleSet cycleSet, int n2, BitSet bitSet, IntArrayList intArrayList) {
        Need need = null;
        Need need2 = (Need)this.needs.get(n);
        while (need2 != null) {
            need = need2.next;
            int n3 = this.counts.get(need2.index);
            if (n3 == intArrayList.get(need2.index)) {
                this.cluster(need2.index, cycleSet, n2, bitSet, intArrayList);
            } else if (cycleSet != null) {
                this.copyDependency(n2, need2, bitSet);
            }
            need2 = need;
        }
    }

    private void copyDependency(int n, Need need, BitSet bitSet) {
        this.decrement(this.counts, need.index);
        if (!bitSet.get(need.index)) {
            System.out.println(" depends on " + this.objects.get(need.index).toString());
            this.addTo(n, need);
        }
        bitSet.set(need.index);
    }

    private PartialOrder decycle() {
        this.indirection = new IntArrayList();
        int n = 0;
        while (n < this.counts.size()) {
            this.indirection.add(n);
            ++n;
        }
        this.traversed = new BitSet();
        this.head = 0;
        this.headStack = new IntArrayList();
        n = this.counts.size();
        int n2 = 1;
        while (n2 < this.counts.size()) {
            this.traverse(n2);
            ++n2;
        }
        if (n == this.counts.size()) {
            return null;
        }
        this.partialOrder = null;
        PartialOrder partialOrder = new PartialOrder();
        int n3 = 1;
        int n4 = this.counts.size();
        while (n3 < n4) {
            if (this.indirection.get(n3) == n3) {
                HashSet hashSet = new HashSet();
                if (n3 < n) {
                    this.updateDependencies(n3, hashSet);
                    this.copyDependencies(n3, partialOrder);
                } else {
                    CycleSet cycleSet = (CycleSet)this.objects.get(n3);
                    cycleSet.addDependencies();
                    this.copyDependencies(n3, partialOrder);
                }
            }
            ++n3;
        }
        return partialOrder;
    }

    private void copyDependencies(int n, PartialOrder partialOrder) {
        Object e = this.objects.get(n);
        if (this.needs.get(n) == null) {
            partialOrder.getIndex(e);
        }
        Need need = (Need)this.needs.get(n);
        while (need != null) {
            Object e2 = this.objects.get(need.index);
            partialOrder.dependsOn(e, e2);
            need = need.next;
        }
    }

    private void updateDependencies(int n, HashSet hashSet) {
        Need need = null;
        Need need2 = (Need)this.needs.get(n);
        while (need2 != null) {
            int n2 = need2.index;
            int n3 = this.indirection.get(n2);
            Object e = this.objects.get(n3);
            if (!hashSet.contains(e)) {
                need2.index = n3;
                hashSet.add(e);
            } else if (need == null) {
                this.needs.set(n, need2.next);
            } else {
                need.next = need2.next;
            }
            need = need2;
            need2 = need2.next;
        }
    }

    private void traverse(int n) {
        BitSet bitSet = new BitSet();
        this.marked = new BitSet();
        this.traverse(n, bitSet);
        this.traversed.or(this.marked);
        this.marked = null;
    }

    private CycleSet traverse(int n, BitSet bitSet) {
        this.objects.get(n);
        if (this.traversed.get(n)) {
            return null;
        }
        if (bitSet.get(n)) {
            CycleSet cycleSet = new CycleSet();
            cycleSet.index = this.getIndex(cycleSet);
            this.indirection.add(cycleSet.index);
            this.pushHead(n);
            return cycleSet;
        }
        bitSet.set(n);
        CycleSet cycleSet = null;
        Need need = (Need)this.needs.get(n);
        while (need != null) {
            this.objects.get(need.index);
            CycleSet cycleSet2 = this.traverse(need.index, bitSet);
            if (cycleSet2 != null) {
                if (cycleSet != null) {
                    cycleSet2.add(cycleSet);
                }
                cycleSet = cycleSet2;
            }
            if (cycleSet != null) {
                cycleSet.add(n);
            }
            if (n == this.head) {
                this.popHead();
                if (this.head == 0) {
                    cycleSet = null;
                }
            }
            need = need.next;
        }
        bitSet.clear(n);
        this.marked.set(n);
        return cycleSet;
    }

    private void pushHead(int n) {
        this.headStack.add(this.head);
        this.head = n;
    }

    private void popHead() {
        this.head = this.headStack.removeLast();
    }

    public List getGroves() {
        HashSet hashSet = new HashSet();
        int n = 1;
        while (n < this.counts.size()) {
            BitSet bitSet = new BitSet();
            this.traverseGrove(n, bitSet);
            this.addToSet(hashSet, bitSet);
            ++n;
        }
        ArrayList<PartialOrder> arrayList = new ArrayList<PartialOrder>();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            BitSet bitSet = (BitSet)iterator.next();
            PartialOrder partialOrder = new PartialOrder();
            this.addToPartialOrder(partialOrder, bitSet);
            arrayList.add(partialOrder);
        }
        return arrayList;
    }

    private void addToPartialOrder(PartialOrder partialOrder, BitSet bitSet) {
        int n = bitSet.nextSetBit(0);
        while (n >= 0) {
            Object e = this.objects.get(n);
            Need need = (Need)this.needs.get(n);
            if (need == null) {
                partialOrder.dependsOn(e, e);
            }
            while (need != null) {
                Object e2 = this.objects.get(need.index);
                partialOrder.dependsOn(e, e2);
                need = need.next;
            }
            n = bitSet.nextSetBit(n + 1);
        }
    }

    private void addToSet(Set set, BitSet bitSet) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            BitSet bitSet2 = (BitSet)iterator.next();
            BitSet bitSet3 = new BitSet();
            bitSet3.or(bitSet);
            bitSet3.and(bitSet2);
            if (bitSet3.isEmpty()) continue;
            bitSet.or(bitSet2);
            iterator.remove();
        }
        set.add(bitSet);
    }

    private void traverseGrove(int n, BitSet bitSet) {
        bitSet.set(n);
        Need need = (Need)this.needs.get(n);
        while (need != null) {
            this.traverseGrove(need.index, bitSet);
            need = need.next;
        }
    }

    public void linearize() {
        PartialOrder partialOrder = this.doLinearize();
        if (partialOrder != null) {
            this.counts = partialOrder.counts;
            this.needs = partialOrder.needs;
            this.indices = partialOrder.indices;
            this.objects = partialOrder.objects;
        }
    }

    public Map getUniqueParents() {
        Map map = new HashMap();
        boolean bl = false;
        int n = 1;
        while (n < this.needs.size()) {
            Need need = (Need)this.needs.get(n);
            if (need != null) {
                map.put(this.objects.get(n), this.objects.get(need.index));
                if (need.next != null) {
                    bl = true;
                    break;
                }
            }
            ++n;
        }
        if (bl) {
            map = this.computeUniqueParents(this.getPartialOrder());
        }
        return map;
    }

    private PartialOrder doLinearize() {
        Need[] needArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        PartialOrder partialOrder = null;
        this.transitiveDependencies = new BitSet[this.counts.size()];
        final ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.counts.size()) {
            arrayList.add(null);
            ++n;
        }
        List list = this.getPartialOrder();
        Object object6 = list.iterator();
        while (object6.hasNext()) {
            object5 = object6.next();
            Integer n2 = (Integer)this.indices.get(object5);
            int n3 = n2;
            object4 = new BitSet();
            object3 = new ArrayList<Need>();
            Need need = (Need)this.needs.get(n3);
            while (need != null) {
                ((ArrayList)object3).add(need);
                need = need.next;
            }
            int n4 = ((ArrayList)object3).size();
            if (n4 > 1) {
                int n5 = 0;
                while (n5 < ((ArrayList)object3).size()) {
                    object2 = (Need)((ArrayList)object3).get(n5);
                    if (object2 != null) {
                        int n6 = 0;
                        while (n6 < ((ArrayList)object3).size()) {
                            if (n6 != n5 && (object = (Need)((ArrayList)object3).get(n6)) != null && this.dependsTransitively(object2.index, ((Need)object).index)) {
                                ((Need)object).delink();
                                ((ArrayList)object3).set(n6, null);
                                --n4;
                            }
                            ++n6;
                        }
                    }
                    ++n5;
                }
            }
            needArray = (Need)this.needs.get(n3);
            while (needArray != null) {
                ((BitSet)object4).set(needArray.index);
                needArray = needArray.next;
            }
            arrayList.set(n3, object4);
        }
        object6 = new ArrayList();
        object5 = new ArrayList();
        int n7 = 1;
        while (n7 < arrayList.size()) {
            BitSet bitSet = (BitSet)arrayList.get(n7);
            if (bitSet != null && bitSet.cardinality() > 1) {
                bitSet.or(this.transitiveDependencies(n7));
                object4 = new BitSet();
                ((BitSet)object4).set(n7);
                object3 = ((ArrayList)object6).iterator();
                Iterator iterator = ((ArrayList)object5).iterator();
                while (object3.hasNext()) {
                    needArray = (BitSet)object3.next();
                    object2 = (BitSet)iterator.next();
                    BitSet bitSet2 = new BitSet();
                    bitSet2.or(bitSet);
                    bitSet2.and((BitSet)needArray);
                    if (bitSet2.cardinality() <= 0) continue;
                    bitSet.or((BitSet)needArray);
                    ((BitSet)object4).or((BitSet)object2);
                    object3.remove();
                    iterator.remove();
                }
                ((ArrayList)object6).add(bitSet);
                ((ArrayList)object5).add(object4);
            }
            ++n7;
        }
        if (((ArrayList)object6).size() > 0) {
            partialOrder = new PartialOrder();
            BitSet bitSet = new BitSet();
            bitSet.set(1, this.counts.size());
            Iterator iterator = ((ArrayList)object6).iterator();
            object4 = ((ArrayList)object5).iterator();
            while (iterator.hasNext()) {
                object3 = (BitSet)iterator.next();
                BitSet bitSet3 = (BitSet)object4.next();
                bitSet.andNot((BitSet)object3);
                needArray = new Need[((BitSet)object3).cardinality()];
                int n8 = ((BitSet)object3).nextSetBit(0);
                int n9 = 0;
                while (n8 >= 0) {
                    needArray[n9] = new Need(n8);
                    n8 = ((BitSet)object3).nextSetBit(n8 + 1);
                    ++n9;
                }
                Arrays.sort(needArray, new Comparator(){

                    public int compare(Object object, Object object2) {
                        int n;
                        Need need = (Need)object;
                        Need need2 = (Need)object2;
                        if (PartialOrder.this.dependsTransitively(need.index, need2.index)) {
                            return 1;
                        }
                        if (PartialOrder.this.dependsTransitively(need2.index, need.index)) {
                            return -1;
                        }
                        int n2 = PartialOrder.this.counts.get(need.index);
                        if (n2 == (n = PartialOrder.this.counts.get(need2.index))) {
                            n2 = ((BitSet)arrayList.get(need.index)).cardinality();
                            n = ((BitSet)arrayList.get(need2.index)).cardinality();
                        }
                        return n - n2;
                    }
                });
                object2 = needArray;
                n9 = 1;
                while (n9 < ((Need[])object2).length) {
                    partialOrder.dependsOn(this.objects.get(object2[n9 - 1].index), this.objects.get(object2[n9].index));
                    ++n9;
                }
                n9 = bitSet3.nextSetBit(0);
                while (n9 >= 0) {
                    if (bitSet.get(n9)) {
                        bitSet.clear(n9);
                        object = (BitSet)arrayList.get(n9);
                        int n10 = 0;
                        while (n10 < ((Need[])object2).length) {
                            if (((BitSet)object).get(object2[n10].index)) {
                                partialOrder.dependsOn(this.objects.get(n9), this.objects.get(object2[n10].index));
                            }
                            ++n10;
                        }
                    }
                    n9 = bitSet3.nextSetBit(n9 + 1);
                }
            }
            int n11 = bitSet.nextSetBit(0);
            while (n11 >= 0) {
                BitSet bitSet4 = (BitSet)arrayList.get(n11);
                int n12 = bitSet4.nextSetBit(0);
                if (n12 >= 0) {
                    partialOrder.dependsOn(this.objects.get(n11), this.objects.get(n12));
                } else {
                    partialOrder.dependsOn(this.objects.get(n11), this.objects.get(n11));
                }
                n11 = bitSet.nextSetBit(n11 + 1);
            }
        }
        this.transitiveDependencies = null;
        return partialOrder;
    }

    private boolean dependsTransitively(int n, int n2) {
        if (n == n2) {
            return true;
        }
        return this.transitiveDependencies(n).get(n2);
    }

    private BitSet transitiveDependencies(int n) {
        BitSet bitSet = this.transitiveDependencies[n];
        if (bitSet == null) {
            bitSet = this.computeTransitiveDependencies(n);
        }
        return bitSet;
    }

    private BitSet computeTransitiveDependencies(int n) {
        BitSet bitSet;
        if (this.transitiveDependencies[n] != null) {
            return this.transitiveDependencies[n];
        }
        this.transitiveDependencies[n] = bitSet = new BitSet();
        Need need = (Need)this.needs.get(n);
        while (need != null) {
            bitSet.set(need.index);
            bitSet.or(this.computeTransitiveDependencies(need.index));
            need = need.next;
        }
        return bitSet;
    }

    public LinkedList asForest() {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        HashMap hashMap = new HashMap();
        int n = 0;
        while (n < this.counts.size()) {
            if (this.counts.get(n) == 0) {
                Object e = this.objects.get(n);
                Node node = new Node(e);
                linkedList.add(node);
                hashMap.put(e, node);
                this.collectForest(node, n, hashMap);
            }
            ++n;
        }
        return linkedList;
    }

    private void collectForest(Node node, int n, Map map) {
        Need need = (Need)this.needs.get(n);
        while (need != null) {
            Object e = this.objects.get(need.index);
            Node node2 = (Node)map.get(e);
            if (node2 == null) {
                node2 = new Node(e);
                map.put(e, node2);
                this.collectForest(node2, need.index, map);
            }
            node.dependsOn.add(node2);
            need = need.next;
        }
    }

    public static interface Cycle
    extends Cluster {
    }

    public static interface Cluster {
        public Collection getMembers();
    }

    private class Need {
        int index;
        Need next;
        Need prev;
        int parent;

        Need(int n) {
            this.index = n;
        }

        void delink() {
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            } else {
                PartialOrder.this.needs.set(this.parent, this.next);
            }
        }
    }

    private class CycleSet
    implements Cycle {
        HashSet set = new HashSet();
        int index;

        CycleSet() {
        }

        public void add(int n) {
            int n2 = PartialOrder.this.indirection.get(n);
            this.add(PartialOrder.this.objects.get(n2));
        }

        public void add(Object object) {
            if (object != this) {
                if (object instanceof CycleSet) {
                    CycleSet cycleSet = (CycleSet)object;
                    PartialOrder.this.indirection.set(cycleSet.index, this.index);
                    Iterator iterator = cycleSet.set.iterator();
                    while (iterator.hasNext()) {
                        this.internalAdd(iterator.next());
                    }
                } else {
                    this.internalAdd(object);
                }
            }
        }

        private void internalAdd(Object object) {
            Integer n = (Integer)PartialOrder.this.indices.get(object);
            PartialOrder.this.indirection.set(n, this.index);
            this.set.add(object);
        }

        public Collection getMembers() {
            return this.set;
        }

        public void addDependencies() {
            HashSet<CycleSet> hashSet = new HashSet<CycleSet>();
            hashSet.add(this);
            Iterator iterator = this.set.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                int n = (Integer)PartialOrder.this.indices.get(e);
                Need need = (Need)PartialOrder.this.needs.get(n);
                while (need != null) {
                    int n2 = need.index;
                    int n3 = PartialOrder.this.indirection.get(n2);
                    Object e2 = PartialOrder.this.objects.get(n3);
                    if (!hashSet.contains(e2)) {
                        PartialOrder.this.dependsOn(this.index, n3);
                        hashSet.add((CycleSet)e2);
                    }
                    need = need.next;
                }
            }
        }
    }

    public static class Node {
        public Object element;
        public LinkedList dependsOn = new LinkedList();

        public Node(Object object) {
            this.element = object;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Node)) {
                return false;
            }
            Node node = (Node)object;
            return this.element.equals(node.element);
        }

        public int hashCode() {
            return this.element.hashCode();
        }
    }
}

