/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util.config;

import com.objfac.util.config.LookaheadIterator;
import com.objfac.util.config.POMDocument;
import com.objfac.util.config.VirtualNode;
import com.objfac.util.config.VirtualParameter;
import com.objfac.util.config.event.EventCharSequence;
import com.objfac.util.config.event.EventHandler;
import java.util.ArrayList;

public class POMHandler
implements EventHandler,
POMDocument {
    private static final int INITIAL_SIZE = 1024;
    private char[] contents;
    private int pos;
    private boolean ignoreComments;
    private int running;
    public static String[] displayableNodeTypes = new String[]{"EndOfFile", "Text", "SimpleParameter", "CompoundParameter", "Section", "Comment", "EndCompoundParameter"};
    private ArrayList stack = new ArrayList();
    static final char EOF = '\uffff';
    static final char MAX_TEXT = '\ufff8';

    public static String getDisplayableNodeType(int n) {
        if (n < 0 || n > 5) {
            return "#UNKNOWN";
        }
        return displayableNodeTypes[n];
    }

    public POMHandler(boolean bl) {
        this.stack.add(new Compound("", -1));
        this.ignoreComments = bl;
    }

    private void guarantee(int n) {
        if (this.contents == null) {
            this.contents = new char[1024];
        }
        while (this.pos + n > this.contents.length) {
            this.contents = this.newContents(this.contents, this.contents.length * 2);
        }
    }

    private char[] newContents(char[] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, Math.min(n, cArray.length));
        return cArray2;
    }

    public Object getContents() {
        if (this.contents != null && this.contents.length > this.pos) {
            this.contents = this.newContents(this.contents, this.pos);
        }
        return this.contents;
    }

    public void beginDocument() {
        this.pos = 0;
        this.contents = null;
        this.stopRunning();
    }

    public void endDocument() {
        this.stopRunning();
        this.endSection(this.top());
        this.guarantee(1);
        this.contents[this.pos++] = POMHandler.encodedType(0);
    }

    public void beginCompoundParameter(EventCharSequence eventCharSequence) {
        this.stopRunning();
        this.guarantee(1);
        this.contents[this.pos++] = POMHandler.encodedType(3);
        this.appendText(eventCharSequence);
        this.stopRunning();
        this.push(eventCharSequence, this.pos);
        this.guarantee(2);
        POMHandler.encodeInt(this.contents, this.pos, 0);
        this.pos += 2;
    }

    private void push(EventCharSequence eventCharSequence, int n) {
        this.stack.add(new Compound(eventCharSequence.toString(), n));
    }

    private Compound pop() {
        return (Compound)this.stack.remove(this.stack.size() - 1);
    }

    private Compound top() {
        return (Compound)this.stack.get(this.stack.size() - 1);
    }

    private boolean stackContains(EventCharSequence eventCharSequence) {
        int n = this.stack.size() - 1;
        while (n >= 1) {
            if (eventCharSequence.equalString(((Compound)this.stack.get((int)n)).id)) {
                return true;
            }
            --n;
        }
        return false;
    }

    static char encodedType(int n) {
        return (char)(65535 - n);
    }

    static int decodedType(char c) {
        return 65535 - c;
    }

    public static void encodeInt(char[] cArray, int n, int n2) {
        cArray[n++] = (char)(n2 >> 16);
        cArray[n] = (char)(n2 & 0xFFFF);
    }

    public static int decodeInt(char[] cArray, int n) {
        int n2 = cArray[n++] << 16;
        return n2 |= cArray[n] & 0xFFFF;
    }

    private void appendText(EventCharSequence eventCharSequence) {
        int n;
        if (this.running >= 0) {
            n = this.contents[this.running];
        } else {
            n = 0;
            this.startRunning();
        }
        int n2 = eventCharSequence.length();
        int n3 = 0;
        do {
            int n4 = Math.min(65528 - n, n2);
            this.guarantee(n4);
            eventCharSequence.getChars(n3, n3 + n4, this.contents, this.pos);
            this.pos += n4;
            n2 -= n4;
            n3 += n4;
            this.contents[this.running] = (char)(n += n4);
            if (n != 65528) continue;
            n = 0;
            this.startRunning();
        } while (n2 > 0);
    }

    private void startRunning() {
        this.guarantee(1);
        this.running = this.pos;
        this.contents[this.pos++] = '\u0000';
    }

    private void stopRunning() {
        this.running = -1;
    }

    public void endCompoundParameter(EventCharSequence eventCharSequence) {
        if (this.stackContains(eventCharSequence)) {
            this.stopRunning();
            int n = this.stack.size() - 1;
            while (n >= 1) {
                Compound compound = this.pop();
                this.endSection(compound);
                this.guarantee(1);
                this.contents[this.pos++] = POMHandler.encodedType(6);
                POMHandler.encodeInt(this.contents, compound.skip, this.pos);
                if (eventCharSequence.equalString(compound.id)) {
                    return;
                }
                --n;
            }
        }
    }

    public void simpleParameter(EventCharSequence eventCharSequence) {
        this.stopRunning();
        this.guarantee(1);
        this.contents[this.pos++] = POMHandler.encodedType(2);
        this.appendText(eventCharSequence);
        this.stopRunning();
    }

    public void text(EventCharSequence eventCharSequence) {
        this.appendText(eventCharSequence);
    }

    public void comment(EventCharSequence eventCharSequence) {
        if (!this.ignoreComments) {
            this.stopRunning();
            this.guarantee(1);
            this.contents[this.pos++] = POMHandler.encodedType(5);
            this.appendText(eventCharSequence);
            this.stopRunning();
        }
    }

    public void section(EventCharSequence eventCharSequence) {
        Compound compound = this.top();
        this.endSection(compound);
        this.stopRunning();
        this.guarantee(1);
        this.contents[this.pos++] = POMHandler.encodedType(4);
        this.appendText(eventCharSequence);
        this.stopRunning();
        compound.section = new Compound(eventCharSequence.toString(), this.pos);
        this.guarantee(2);
        POMHandler.encodeInt(this.contents, this.pos, 0);
        this.pos += 2;
    }

    private void endSection(Compound compound) {
        if (compound.section != null) {
            this.stopRunning();
            this.guarantee(1);
            this.contents[this.pos++] = POMHandler.encodedType(6);
            POMHandler.encodeInt(this.contents, compound.section.skip, this.pos);
        }
    }

    public LookaheadIterator getParameters() {
        VirtualParameter virtualParameter = new VirtualParameter();
        if (virtualParameter.becomeFirstParameter(this)) {
            return new VirtualParameter.Children(virtualParameter);
        }
        return VirtualParameter.NO_CHILDREN;
    }

    public LookaheadIterator getNodes() {
        VirtualNode virtualNode = new VirtualNode();
        if (virtualNode.becomeFirstNode(this)) {
            return new VirtualNode.Children(virtualNode);
        }
        return VirtualNode.NO_CHILDREN;
    }

    private static class Compound {
        String id;
        int skip;
        Compound section;

        Compound(String string, int n) {
            this.id = string;
            this.skip = n;
        }
    }
}

