/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util.config;

import com.objfac.util.Adaptable;
import com.objfac.util.OpaqueStack;
import com.objfac.util.Stack;
import com.objfac.util.config.AbstractParameterWriter;
import com.objfac.util.config.Messages;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;

public class PrettyWriter
extends AbstractParameterWriter
implements Adaptable {
    private Writer writer;
    private String EOL = File.separatorChar == '\\' ? "\r\n" : "\n";
    private String indent = "";
    private int preserve;
    private Stack stack = new Stack();
    static /* synthetic */ Class class$0;

    public PrettyWriter(Writer writer) {
        this.stack.push("");
        this.writer = writer;
    }

    public void beginCompoundParameter(String string) throws IOException {
        if (this.preserve == 0) {
            this.write(this.indent);
        }
        this.write("[");
        this.write(string);
        this.write("[");
        if (this.preserve == 0) {
            this.writeln();
        }
        this.indent = String.valueOf(this.indent) + "  ";
        this.stack.push(string);
    }

    public void endCompoundParameter(String string) throws IOException {
        if (!this.stack.contains(string)) {
            throw new IllegalStateException(MessageFormat.format(Messages.endDoesntMatch, string));
        }
        int n = this.stack.size();
        while (n-- > 0) {
            String string2 = (String)this.stack.pop();
            this.writeEnd(string2);
            if (string.equals(string2)) break;
        }
    }

    public void writeEnd(String string) throws IOException {
        String string2 = this.indent = this.indent.length() > 2 ? this.indent.substring(2) : "";
        if (this.preserve == 0) {
            this.write(this.indent);
        }
        this.write("]");
        this.write(string);
        this.write("]");
        if (this.preserve == 0) {
            this.writeln();
        }
    }

    public void simpleParameter(String string, String string2) throws IOException {
        if (this.preserve == 0) {
            this.write(this.indent);
        }
        this.write(string);
        this.write("=");
        this.write(string2);
        if (this.preserve == 0) {
            this.writeln();
        }
    }

    public void comment(String string) throws IOException {
        this.write("#" + this.escape(string));
        if (!string.endsWith(this.EOL)) {
            this.writeln("");
        }
    }

    public void section(String string) throws IOException {
        if (this.preserve == 0) {
            this.write(this.indent);
        }
        this.write("[");
        this.write(string);
        this.write("]");
        if (this.preserve == 0) {
            this.writeln();
        }
    }

    public void text(String string) throws IOException {
        this.write(this.escape(string));
    }

    private void writeln(String string) throws IOException {
        this.write(string);
        this.write(this.EOL);
    }

    private void writeln() throws IOException {
        this.write(this.EOL);
    }

    private void write(String string) throws IOException {
        this.writer.write(string);
    }

    private String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        char c = '\u0000';
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c2 = string.charAt(n);
            if (bl2 && (c2 == c || c == '\u0000' && (c2 == '\\' || c2 == '#' || c2 == ']' || c2 == '[' || c2 == '='))) {
                stringBuffer.append(c2);
                c = c2;
            } else if (c2 == '\\') {
                bl2 = true;
                c = '\u0000';
            } else {
                if (bl2 && c == '\u0000') {
                    stringBuffer.append('\\');
                }
                bl2 = false;
                if (c2 == '\n' && !bl) {
                    stringBuffer.append(this.EOL);
                } else if (c2 == '\r') {
                    stringBuffer.append(this.EOL);
                    bl = true;
                } else {
                    bl = false;
                    stringBuffer.append(c2);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void beginPreserveWhitespace() {
        ++this.preserve;
    }

    public void endPreserveWhitespace() throws IOException {
        if (this.preserve > 0) {
            --this.preserve;
        }
        if (this.preserve == 0) {
            this.writeln();
        }
    }

    public void resetPreserveWhitespace() throws IOException {
        this.preserve = 0;
        this.writeln();
    }

    public Object adapt(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.objfac.util.OpaqueStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return new OpaqueStack(){
                Stack save;

                public void push() {
                    this.save = PrettyWriter.this.stack;
                    PrettyWriter.this.stack = new Stack();
                    PrettyWriter.this.stack.push("");
                }

                public void pop() {
                    PrettyWriter.this.stack = this.save;
                }
            };
        }
        return null;
    }
}

