/*
 * Decompiled with CFR 0.152.
 */
package com.objfac.util.config;

import com.objfac.util.config.Messages;
import com.objfac.util.config.event.EventCharSequence;

public class VirtualCharSequence
implements EventCharSequence {
    protected int offset;
    protected char[] buf;
    protected boolean needHash = true;
    protected int hash;
    protected int subBegin;
    protected int subEnd;
    protected int afterOffset;
    protected boolean needHashCode = true;
    protected int cachedHashCode;

    protected void checkBuf() {
        if (this.buf == null) {
            throw new IllegalStateException(Messages.sequenceNotInitialized);
        }
    }

    public char[] getBuffer() {
        this.checkBuf();
        return this.buf;
    }

    public void become(char[] cArray, int n, int n2) {
        this.buf = cArray;
        this.offset = n;
        this.subBegin = 0;
        this.subEnd = n2 - n;
        this.afterOffset = n2;
    }

    public void become(VirtualCharSequence virtualCharSequence, int n, int n2) {
        virtualCharSequence.checkBuf();
        if (n < 0 || n > n2 || n2 + virtualCharSequence.offset > virtualCharSequence.buf.length) {
            throw new IndexOutOfBoundsException();
        }
        this.buf = virtualCharSequence.buf;
        this.offset = virtualCharSequence.offset + n;
        this.subBegin = 0;
        this.subEnd = n2 - n;
        this.afterOffset = virtualCharSequence.offset + n2;
    }

    public void setLength(int n) {
        this.checkBuf();
        if (this.subBegin + n > this.getMaxLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.subEnd = this.subBegin + n;
    }

    protected int getMaxLength() {
        return this.buf.length;
    }

    public boolean hasBecome() {
        return this.buf != null;
    }

    public int length() {
        this.checkBuf();
        return this.subEnd - this.subBegin;
    }

    public char charAt(int n) {
        this.checkIndex(n);
        return this.buf[n + this.subBegin + this.offset];
    }

    protected void checkIndex(int n) {
        if (n < 0 || n + this.subBegin >= this.subEnd) {
            throw new IndexOutOfBoundsException();
        }
    }

    protected int absIndex(int n) {
        this.checkIndex(n);
        return n + this.subBegin + this.offset;
    }

    public String toString() {
        this.checkBuf();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.subEnd - this.subBegin) {
            stringBuffer.append(this.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public CharSequence subSequence(int n, int n2) {
        this.checkBuf();
        this.checkIndex(n);
        this.checkIndex(n2);
        VirtualCharSequence virtualCharSequence = this.makeNewSequence();
        virtualCharSequence.become(this.offset, this.buf, this.afterOffset, n, n2);
        return virtualCharSequence;
    }

    protected VirtualCharSequence makeNewSequence() {
        return new VirtualCharSequence();
    }

    protected void become(int n, char[] cArray, int n2, int n3, int n4) {
        this.offset = n;
        this.buf = cArray;
        this.afterOffset = n2;
        this.subBegin = n3;
        this.subEnd = n4;
    }

    public boolean equals(Object object) {
        this.checkBuf();
        if (object == this) {
            return true;
        }
        if (!(object instanceof VirtualCharSequence)) {
            return false;
        }
        VirtualCharSequence virtualCharSequence = (VirtualCharSequence)object;
        virtualCharSequence.checkBuf();
        if (virtualCharSequence.buf == this.buf && virtualCharSequence.offset == this.offset) {
            return true;
        }
        if (this.length() != virtualCharSequence.length()) {
            return false;
        }
        int n = 0;
        int n2 = this.length();
        while (n < n2) {
            if (this.charAt(n) != virtualCharSequence.charAt(n)) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equalsIgnoreCase(Object object) {
        this.checkBuf();
        if (object == this) {
            return true;
        }
        if (!(object instanceof VirtualCharSequence)) {
            return false;
        }
        VirtualCharSequence virtualCharSequence = (VirtualCharSequence)object;
        virtualCharSequence.checkBuf();
        if (virtualCharSequence.buf == this.buf && virtualCharSequence.offset == this.offset) {
            return true;
        }
        if (this.length() != virtualCharSequence.length()) {
            return false;
        }
        int n = 0;
        int n2 = this.length();
        while (n < n2) {
            char c;
            char c2 = this.charAt(n);
            if (!VirtualCharSequence.equalsIgnoreCase(c2, c = virtualCharSequence.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(char c, char c2) {
        return Character.toUpperCase(c) == Character.toUpperCase(c2) && Character.toLowerCase(c) == Character.toLowerCase(c2);
    }

    public boolean equalString(CharSequence charSequence) {
        this.checkBuf();
        if (this == charSequence) {
            return true;
        }
        if (charSequence instanceof VirtualCharSequence) {
            ((VirtualCharSequence)charSequence).checkBuf();
        }
        if (this.length() != charSequence.length()) {
            return false;
        }
        int n = 0;
        int n2 = this.length();
        while (n < n2) {
            char c;
            char c2 = this.charAt(n);
            if (c2 != (c = charSequence.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equalStringIgnoreCase(CharSequence charSequence) {
        this.checkBuf();
        if (this == charSequence) {
            return true;
        }
        if (charSequence instanceof VirtualCharSequence) {
            ((VirtualCharSequence)charSequence).checkBuf();
        }
        if (this.length() != charSequence.length()) {
            return false;
        }
        int n = 0;
        int n2 = this.length();
        while (n < n2) {
            char c;
            char c2 = this.charAt(n);
            if (!VirtualCharSequence.equalsIgnoreCase(c2, c = charSequence.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        this.checkBuf();
        if (this.needHash) {
            int n = this.subBegin;
            int n2 = this.subEnd - this.subBegin;
            int n3 = 0;
            while (n3 < n2) {
                this.hash = 31 * this.hash + this.charAt(n);
                ++n3;
            }
        }
        return this.hash;
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < this.subBegin || n2 > this.subEnd || n > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n4 = n;
        while (n4 < n2) {
            cArray[n3++] = this.charAt(n4);
            ++n4;
        }
    }

    public void trim() {
        int n;
        int n2 = n = this.length();
        int n3 = 0;
        while (n3 < n && this.charAt(n3) <= ' ') {
            ++n3;
        }
        while (n3 < n && this.charAt(n - 1) <= ' ') {
            --n;
        }
        if (n3 > 0 || n < n2) {
            this.become(this, n3, n);
        }
    }

    public void normalize() {
        this.trim();
        int n = this.length();
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            if (this.charAt(n3) <= ' ') {
                if (!bl) {
                    ++n2;
                    bl = true;
                }
            } else {
                ++n2;
                bl = false;
            }
            ++n3;
        }
        if (n2 < n) {
            char[] cArray = this.getEmptyBuf(n2);
            bl = false;
            int n4 = 0;
            int n5 = 0;
            while (n4 < n) {
                char c = this.charAt(n4);
                if (c <= ' ') {
                    if (!bl) {
                        this.replaceChar(cArray, n5++, ' ');
                        bl = true;
                    }
                } else {
                    this.replaceChar(cArray, n5++, c);
                    bl = false;
                }
                ++n4;
            }
            this.become(cArray, 0, n2);
        }
    }

    protected char[] getEmptyBuf(int n) {
        return new char[n];
    }

    protected void replaceChar(char[] cArray, int n, char c) {
        if (n < 0 || n >= cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        cArray[n] = c;
    }
}

