/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef;

import aurora.ide.builder.BuildContext;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.helpers.ApplicationException;
import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.Input;
import aurora.ide.search.cache.CacheManager;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import uncertain.composite.CompositeMap;
import uncertain.schema.Attribute;

public class Util {
    public static String getType(CompositeMap field) {
        CompositeMap fieldByName;
        if (Util.isQueryName(field) && (fieldByName = Util.findFieldMapByQueryName(field)) != null) {
            return Util.getType(fieldByName);
        }
        String object = Util.getCompositeValue("defaultEditor", field);
        if (Util.supportEditor(object) != null) {
            return object;
        }
        if ("java.lang.Long".equals(field.getString((Object)"datatype"))) {
            return "numberField";
        }
        if ("java.lang.String".equals(field.getString((Object)"datatype"))) {
            return "textField";
        }
        if ("java.util.Date".equals(field.getString((Object)"datatype"))) {
            return "datePicker";
        }
        return "textField";
    }

    public static CompositeMap findFieldMapByQueryName(CompositeMap field) {
        String fn = field.getString((Object)"name", "");
        String endS = Util.getQueryFieldEndString(fn);
        if (endS != null) {
            BMCompositeMap bm = new BMCompositeMap(field.getRoot());
            CompositeMap fieldByName = bm.getFieldByName(fn.replace(endS, ""));
            return fieldByName;
        }
        return null;
    }

    public static boolean isQueryName(CompositeMap field) {
        return "query-field".equals(field.getName()) && field.get((Object)"name") != null;
    }

    private static String getQueryFieldEndString(String fn) {
        String suffix = "_from";
        if (fn.endsWith(suffix)) {
            return suffix;
        }
        suffix = "_to";
        if (fn.endsWith(suffix)) {
            return suffix;
        }
        return "";
    }

    public static String supportEditor(String object) {
        String[] stringArray = Input.INPUT_TYPES;
        int n = Input.INPUT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (t.equalsIgnoreCase(object)) {
                return t;
            }
            ++n2;
        }
        return null;
    }

    public static IEditorPart getActiveEditor(IWorkbenchWindow fWorkbenchWindow) {
        IWorkbenchPart activePart;
        IEditorPart activeEditor;
        IWorkbenchPage activePage = fWorkbenchWindow.getActivePage();
        if (activePage != null && (activeEditor = activePage.getActiveEditor()) == (activePart = activePage.getActivePart())) {
            return activeEditor;
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static ISelection getSelection(IWorkbenchWindow window) {
        return window.getSelectionService().getSelection();
    }

    public static String[] evaluateEnclosingProject(IWorkbenchWindow fWorkbenchWindow) {
        return Util.evaluateEnclosingProject(Util.getSelection(fWorkbenchWindow), Util.getActiveEditor(fWorkbenchWindow));
    }

    public static String evaluateEnclosingProject(IAdaptable adaptable) {
        IResource resource;
        IProject project = (IProject)adaptable.getAdapter(IProject.class);
        if (project == null && (resource = (IResource)adaptable.getAdapter(IResource.class)) != null) {
            project = resource.getProject();
        }
        if (project != null && project.isAccessible()) {
            return project.getName();
        }
        return null;
    }

    public static String[] evaluateEnclosingProject(ISelection selection, IEditorPart activeEditor) {
        if (activeEditor != null) {
            String name = Util.evaluateEnclosingProject((IAdaptable)activeEditor.getEditorInput());
            if (name != null) {
                return new String[]{name};
            }
        } else if (selection instanceof IStructuredSelection) {
            HashSet<String> res = new HashSet<String>();
            for (Object curr : (IStructuredSelection)selection) {
                String name;
                if (curr instanceof IWorkingSet) {
                    int i;
                    IWorkingSet workingSet = (IWorkingSet)curr;
                    if (workingSet.isAggregateWorkingSet() && workingSet.isEmpty()) {
                        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                        i = 0;
                        while (i < projects.length) {
                            IProject proj = projects[i];
                            if (proj.isOpen()) {
                                res.add(proj.getName());
                            }
                            ++i;
                        }
                        continue;
                    }
                    IAdaptable[] elements = workingSet.getElements();
                    i = 0;
                    while (i < elements.length) {
                        String name2 = Util.evaluateEnclosingProject(elements[i]);
                        if (name2 != null) {
                            res.add(name2);
                        }
                        ++i;
                    }
                    continue;
                }
                if (!(curr instanceof IAdaptable) || (name = Util.evaluateEnclosingProject((IAdaptable)curr)) == null) continue;
                res.add(name);
            }
            if (!res.isEmpty()) {
                return res.toArray(new String[res.size()]);
            }
        }
        return new String[0];
    }

    public static String getCompositeValue(String key, CompositeMap map) {
        Set keySet = map.keySet();
        for (Object object : keySet) {
            if (!key.equalsIgnoreCase(object.toString())) continue;
            return map.getString(object);
        }
        return null;
    }

    public static Dataset findDataset(Container container) {
        if (container == null) {
            return null;
        }
        boolean useParentBM = Util.isUseParentBM(container);
        if (useParentBM) {
            return Util.findDataset(container.getParent());
        }
        Dataset dataset = container.getDataset();
        return dataset;
    }

    public static boolean isUseParentBM(Container container) {
        return !"SECTION_TYPE_QUERY".equals(container.getSectionType()) && !"SECTION_TYPE_RESULT".equals(container.getSectionType());
    }

    public static String getPrompt(CompositeMap field, String defaultValue) {
        String result;
        String endS = "";
        if (Util.isQueryName(field)) {
            CompositeMap qf = field;
            String fn = qf.getString((Object)"name", "");
            endS = Util.getQueryFieldEndString(fn);
            field = Util.findFieldMapByQueryName(field);
        }
        String string = result = field != null ? field.getString((Object)"prompt", defaultValue) : defaultValue;
        if ("_from".equals(endS)) {
            return String.valueOf(result) + "\u4ece";
        }
        if ("_to".equals(endS)) {
            return String.valueOf(result) + "\u5230";
        }
        return result;
    }

    public static String getRefFieldSourcePrompt(IProject auroraProject, CompositeMap field, String defaultValue) {
        if (!"ref-field".equals(field.getName())) {
            return null;
        }
        String relationName = Util.getValueIgnoreCase(field, "relationName");
        if (relationName == null) {
            return null;
        }
        BMCompositeMap c_bm = new BMCompositeMap(field.getRoot());
        CompositeMap relationMap = null;
        List<CompositeMap> relations = c_bm.getRelations();
        for (CompositeMap r : relations) {
            if (!relationName.equals(r.getString((Object)"name"))) continue;
            relationMap = r;
        }
        if (relationMap == null) {
            return null;
        }
        String bmPath = Util.getValueIgnoreCase(relationMap, "refmodel");
        IFile resource = ResourceUtil.getBMFile((IProject)auroraProject, (String)(bmPath == null ? "" : bmPath));
        if (resource instanceof IFile) {
            IFile file = resource;
            try {
                CompositeMap map = CacheManager.getWholeBMCompositeMap((IFile)file);
                BMCompositeMap bm = new BMCompositeMap(map);
                String source = Util.getValueIgnoreCase(field, "sourceField");
                CompositeMap fieldByName = bm.getFieldByName(source == null ? "" : source);
                if (fieldByName != null) {
                    return Util.getPrompt(fieldByName, defaultValue);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            catch (ApplicationException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getValueIgnoreCase(Attribute a, BuildContext bc) {
        return Util.getValueIgnoreCase(a, bc.map);
    }

    public static String getValueIgnoreCase(Attribute a, CompositeMap cMap) {
        String name = a.getName();
        return Util.getValueIgnoreCase(cMap, name);
    }

    public static String getValueIgnoreCase(CompositeMap cMap, String name) {
        Set keySet = cMap.keySet();
        for (Object object : keySet) {
            if (!(object instanceof String) || !((String)object).equalsIgnoreCase(name)) continue;
            return cMap.get(object).toString();
        }
        return null;
    }
}

