/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.editor;

import aurora.ide.api.composite.map.CommentCompositeLoader;
import aurora.ide.api.composite.map.CommentCompositeMapParser;
import aurora.ide.builder.ResourceUtil;
import aurora.ide.meta.exception.ResourceNotFoundException;
import aurora.ide.meta.gef.designer.DesignerMessages;
import aurora.ide.meta.project.AuroraMetaProject;
import freemarker.template.Template;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import uncertain.composite.CompositeLoader;
import uncertain.composite.CompositeMap;

public class LookupCodeUtil {
    public static final String SYS_CODE_FILE_NAME = DesignerMessages.sys_code_file_name;
    public static final String SYS_CODE_TEMPLATE = "create_syscode.ftl";
    private static Template tpl = null;

    public static boolean isCode(Object o) {
        if (!(o instanceof CompositeMap)) {
            return false;
        }
        CompositeMap m = (CompositeMap)o;
        return "code".equalsIgnoreCase(m.getName());
    }

    public static boolean isValue(Object o) {
        if (!(o instanceof CompositeMap)) {
            return false;
        }
        CompositeMap m = (CompositeMap)o;
        return "value".equalsIgnoreCase(m.getName());
    }

    public static String getCode(Object code) {
        if (!LookupCodeUtil.isCode(code)) {
            return "<invalid code>";
        }
        CompositeMap m = (CompositeMap)code;
        String codeName = m.getString((Object)"code");
        if (codeName == null) {
            return "<missing code name>";
        }
        return codeName.toUpperCase();
    }

    public static String getValueAsString(Object o) {
        if (!LookupCodeUtil.isValue(o)) {
            return "<invalid value>";
        }
        return String.valueOf(LookupCodeUtil.getValue(o)) + " : [" + LookupCodeUtil.getValueNameZHS(o) + "," + LookupCodeUtil.getValueNameUS(o) + "]";
    }

    public static String getValue(Object v) {
        if (!LookupCodeUtil.isValue(v)) {
            return "<invalid value>";
        }
        CompositeMap m = (CompositeMap)v;
        return m.getString((Object)"value");
    }

    public static String getValueNameZHS(Object v) {
        if (!LookupCodeUtil.isValue(v)) {
            return "<invalid value>";
        }
        CompositeMap m = (CompositeMap)v;
        return m.getString((Object)"zhs");
    }

    public static String getValueNameUS(Object v) {
        if (!LookupCodeUtil.isValue(v)) {
            return "<invalid value>";
        }
        CompositeMap m = (CompositeMap)v;
        return m.getString((Object)"us");
    }

    public static CompositeMap getCodeRoot(Object o) {
        if (LookupCodeUtil.isCode(o)) {
            return (CompositeMap)o;
        }
        if (LookupCodeUtil.isValue(o)) {
            return ((CompositeMap)o).getParent();
        }
        return null;
    }

    public static CompositeMap load(IProject metaProject) throws ResourceNotFoundException {
        CompositeMap codemap;
        AuroraMetaProject amp = new AuroraMetaProject(metaProject);
        IFolder mf = amp.getModelFolder();
        IFile file = mf.getFile(SYS_CODE_FILE_NAME);
        if (file == null || !file.exists()) {
            throw new RuntimeException(String.valueOf(DesignerMessages.LookupCodeDialog_3) + "\nfile not exists.");
        }
        CommentCompositeLoader loader = new CommentCompositeLoader();
        CommentCompositeMapParser parser = new CommentCompositeMapParser((CompositeLoader)loader);
        try {
            codemap = parser.parseStream(file.getContents(true));
        }
        catch (Exception e) {
            String errorMessage = DesignerMessages.LookupCodeDialog_3;
            errorMessage = String.valueOf(errorMessage) + "\n" + e.getMessage();
            throw new RuntimeException(errorMessage);
        }
        return codemap;
    }

    public static boolean isSyscodeFile(IFile f) {
        if (f == null || !f.exists()) {
            return false;
        }
        if (!f.getName().equals(SYS_CODE_FILE_NAME)) {
            return false;
        }
        if (!ResourceUtil.isAuroraMetaProject((IProject)f.getProject())) {
            return false;
        }
        AuroraMetaProject amp = new AuroraMetaProject(f.getProject());
        try {
            IFolder folder = amp.getModelFolder();
            return folder.getFullPath().isPrefixOf(f.getFullPath());
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return false;
        }
    }

    public static Template getSourceTemplate() {
        if (tpl == null) {
            InputStream is = LookupCodeUtil.class.getResourceAsStream(SYS_CODE_TEMPLATE);
            try {
                InputStreamReader reader = new InputStreamReader(is, "UTF-8");
                tpl = new Template("code_template", (Reader)reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return tpl;
    }
}

