/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.editor;

import aurora.ide.meta.gef.designer.editor.LookupCodeUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import uncertain.composite.CompositeMap;

public class LookupCodeViewer
extends TreeViewer {
    private Tree tree;

    public LookupCodeViewer(Composite parent) {
        super(parent);
        this.init(parent);
    }

    public LookupCodeViewer(Composite parent, int style) {
        super(parent, style);
        this.init(parent);
    }

    private void init(Composite parent) {
        this.tree = this.getTree();
        this.setContentProvider((IContentProvider)new TreeConentProvider());
        this.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
    }

    public void select(String code) {
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            ti.getStyle();
            if (LookupCodeUtil.getCode(ti.getData()).equalsIgnoreCase(code)) {
                this.setSelection((ISelection)new StructuredSelection(ti.getData()));
                break;
            }
            ++n2;
        }
    }

    class TreeConentProvider
    implements ITreeContentProvider {
        TreeConentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            CompositeMap codemap = (CompositeMap)inputElement;
            return codemap.getChildsNotNull().toArray();
        }

        public Object[] getChildren(Object parentElement) {
            CompositeMap m = (CompositeMap)parentElement;
            return m.getChildsNotNull().toArray();
        }

        public Object getParent(Object element) {
            CompositeMap m = (CompositeMap)element;
            return m.getParent();
        }

        public boolean hasChildren(Object element) {
            if ((LookupCodeViewer.this.tree.getStyle() & 0x20) != 0) {
                return false;
            }
            return LookupCodeUtil.isCode(element);
        }
    }

    class TreeLabelProvider
    extends LabelProvider
    implements IColorProvider {
        TreeLabelProvider() {
        }

        public String getText(Object element) {
            if (LookupCodeUtil.isCode(element)) {
                String code = LookupCodeUtil.getCode(element);
                Boolean b = ((CompositeMap)element).getBoolean((Object)"exists");
                if (b != null && b.booleanValue()) {
                    code = String.valueOf(code) + "    (exists)";
                }
                return code;
            }
            return LookupCodeUtil.getValueAsString(element);
        }

        public Color getForeground(Object element) {
            String t = this.getText(element);
            if (t.contains("<")) {
                return new Color(null, 255, 0, 0);
            }
            if (LookupCodeUtil.isValue(element)) {
                return new Color(null, 128, 128, 128);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }
}

