/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.gen;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.meta.gef.designer.gen.DuplicateException;
import java.util.HashMap;
import uncertain.composite.CompositeMap;

public abstract class AbstractBmGenerator {
    public static final String xml_header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n";
    public static final String bm_ns_pre = "bm";
    public static final String bm_ns_uri = "http://www.aurora-framework.org/schema/bm";
    public static final String f_ns_pre = "f";
    public static final String f_ns_uri = "aurora.database.features";
    public static final String o_ns_pre = "o";
    public static final String o_ns_uri = "aurora.database.local.oracle";
    private HashMap<String, String> nsMapping = new HashMap();

    protected String getBmName() {
        return "model";
    }

    protected String getBaseTable() {
        return null;
    }

    protected String getExtend() {
        return null;
    }

    protected String getExtendMode() {
        return null;
    }

    protected String getAlias() {
        return "e";
    }

    public CompositeMap gen() throws DuplicateException {
        CompositeMap modelMap = this.newModelMap();
        this.setUpModelMap(modelMap);
        for (String uri : this.nsMapping.keySet()) {
            modelMap.put((Object)("xmlns:" + this.nsMapping.get(uri)), (Object)uri);
        }
        return modelMap;
    }

    protected abstract void setUpModelMap(CompositeMap var1) throws DuplicateException;

    protected CompositeMap newModelMap() {
        CompositeMap modelMap = this.newCompositeMap(this.getBmName());
        modelMap.setNamespaceMapping(this.nsMapping);
        modelMap.put((Object)"alias", (Object)this.getAlias());
        modelMap.put((Object)"baseTable", (Object)this.getBaseTable());
        modelMap.put((Object)"extend", (Object)this.getExtend());
        modelMap.put((Object)"extendMode", (Object)this.getExtendMode());
        return modelMap;
    }

    protected CompositeMap newCompositeMap(String nodeName) {
        return this.newCompositeMap(nodeName, bm_ns_pre);
    }

    protected CompositeMap newCompositeMap(String nodeName, String prefix) {
        CommentCompositeMap map = new CommentCompositeMap(nodeName);
        map.setPrefix(prefix);
        if (bm_ns_pre.equals(prefix)) {
            this.nsMapping.put(bm_ns_uri, bm_ns_pre);
        } else if (f_ns_pre.equals(prefix)) {
            this.nsMapping.put(f_ns_uri, f_ns_pre);
        } else if (o_ns_pre.equals(prefix)) {
            this.nsMapping.put(o_ns_uri, o_ns_pre);
        }
        return map;
    }
}

