/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.designer.wizard;

import aurora.ide.meta.gef.designer.DesignerUtil;
import aurora.ide.meta.gef.designer.IDesignerConst;
import aurora.ide.meta.gef.designer.editor.SimpleBMModelViewer;
import aurora.ide.meta.gef.designer.model.BMModel;
import aurora.ide.meta.gef.designer.model.Record;
import aurora.ide.meta.gef.designer.wizard.BaseInfoWizardPage;
import aurora.ide.meta.gef.designer.wizard.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ExtensionWizardPage
extends WizardPage
implements SelectionListener {
    private String[] infos = new String[]{Messages.ExtensionWizardPage_1, Messages.ExtensionWizardPage_0, Messages.ExtensionWizardPage_2};
    private String[] defaultSelection = new String[0];
    private BMModel model;
    private TabFolder tabFolder;
    private Button[] checkBoxs;
    private SimpleBMModelViewer[] viewers = new SimpleBMModelViewer[3];

    public ExtensionWizardPage() {
        super("ExtensionWizardPage");
        this.setTitle(Messages.ExtensionWizardPage_6);
        this.setDescription("Wizard Page description");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(2, false));
        List<String> list = Arrays.asList(this.defaultSelection);
        Composite com = new Composite(container, 0);
        com.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 2));
        com.setLayout((Layout)new GridLayout(1, true));
        this.checkBoxs = new Button[IDesignerConst.AE_TYPES.length];
        int i = 0;
        while (i < this.checkBoxs.length) {
            this.checkBoxs[i] = new Button(com, 32);
            this.checkBoxs[i].setText("generate _for_" + IDesignerConst.AE_TYPES[i] + ".bm");
            this.checkBoxs[i].setData((Object)IDesignerConst.AE_TYPES[i]);
            this.checkBoxs[i].setSelection(list.indexOf(IDesignerConst.AE_TYPES[i]) != -1);
            this.checkBoxs[i].setToolTipText(this.infos[i]);
            ++i;
        }
        this.createTopRight(container);
        this.createBottom(container);
    }

    private void createTopRight(Composite container) {
        Button btnSelectAll = new Button(container, 0);
        btnSelectAll.setLayoutData((Object)new GridData(4, 1024, false, false, 1, 1));
        btnSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button[] buttonArray = ExtensionWizardPage.this.checkBoxs;
                int n = buttonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Button b = buttonArray[n2];
                    b.setSelection(true);
                    ++n2;
                }
            }
        });
        btnSelectAll.setText("Select All");
        Button btnDesselectAll = new Button(container, 0);
        btnDesselectAll.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnDesselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button[] buttonArray = ExtensionWizardPage.this.checkBoxs;
                int n = buttonArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Button b = buttonArray[n2];
                    b.setSelection(false);
                    ++n2;
                }
            }
        });
        btnDesselectAll.setText("Deselect All");
    }

    private void createBottom(Composite container) {
        this.tabFolder = new TabFolder(container, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        int i = 0;
        while (i < this.viewers.length) {
            TabItem ti = new TabItem(this.tabFolder, 0);
            this.viewers[i] = new SimpleBMModelViewer((Composite)this.tabFolder, 0);
            this.viewers[i].setDisplayMode((String)this.checkBoxs[i].getData());
            ti.setControl(this.viewers[i].getControl());
            ti.setText(IDesignerConst.AE_TYPES[i]);
            ++i;
        }
        this.tabFolder.addSelectionListener((SelectionListener)this);
        this.widgetSelected(null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.synModel();
    }

    private void synModel() {
        BaseInfoWizardPage prePage = (BaseInfoWizardPage)this.getPreviousPage();
        if (prePage == null) {
            return;
        }
        String shortName = prePage.getShortName();
        this.model.setTitle(shortName);
        String pre = shortName;
        if (pre.length() > 3) {
            pre = pre.substring(0, 3);
        }
        this.model.setNamePrefix(String.valueOf(pre) + "_c");
        this.model.getPkRecord().setName(String.valueOf(shortName) + "_pk");
        String[] preInput = prePage.getPreInput();
        ArrayList<Record> list = this.model.getRecordList();
        int i = 0;
        while (i < list.size()) {
            block9: {
                String p = ((Record)list.get(i)).getPrompt();
                String[] stringArray = preInput;
                int n = preInput.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (!p.equals(s)) {
                        ++n2;
                        continue;
                    }
                    break block9;
                }
                list.remove(i--);
            }
            ++i;
        }
        String[] stringArray = preInput;
        int n = preInput.length;
        int n3 = 0;
        while (n3 < n) {
            block10: {
                String s = stringArray[n3];
                for (Record r : this.model.getRecordList()) {
                    if (!r.getPrompt().equals(s)) {
                        continue;
                    }
                    break block10;
                }
                this.model.add(DesignerUtil.createRecord(s));
            }
            ++n3;
        }
        Record r = this.model.getDefaultDisplayRecord();
        if (r == null && this.model.getRecordList().size() > 0) {
            this.model.setDefaultDisplay(this.model.getRecordList().get(0).getPrompt());
        }
    }

    public void setDefaultSeletion(String[] strs) {
        this.defaultSelection = strs;
    }

    public String[] getUserSelection() {
        ArrayList<String> als = new ArrayList<String>();
        int i = 0;
        while (i < this.checkBoxs.length) {
            if (this.checkBoxs[i].getSelection()) {
                als.add((String)this.checkBoxs[i].getData());
            }
            ++i;
        }
        String[] ss = new String[als.size()];
        als.toArray(ss);
        return ss;
    }

    public void widgetSelected(SelectionEvent e) {
        SimpleBMModelViewer v = this.viewers[this.tabFolder.getSelectionIndex()];
        if (v.getInput() == null) {
            v.setInput(this.model);
        }
        v.refresh();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setModel(BMModel model) {
        this.model = model;
    }
}

