/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.layout;

import aurora.ide.meta.gef.editors.layout.BackLayout;
import aurora.ide.meta.gef.editors.layout.GraphLayoutManager;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.TabBodyPart;
import aurora.ide.meta.gef.editors.parts.TabFolderPart;
import aurora.ide.meta.gef.editors.parts.TabItemPart;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class TabFolderLayout
extends BackLayout {
    private static final Insets PADDING = new Insets(8, 16, 8, 6);

    public Rectangle layout(ComponentPart ep) {
        TabFolderPart part = (TabFolderPart)ep;
        Point pos = part.getFigure().getBounds().getTopLeft().translate(2, 2);
        Point maxSize = new Point(0, 0);
        List list = part.getChildren();
        int tabItemTotalWidth = 0;
        for (ComponentPart cp : list) {
            if (cp instanceof TabItemPart) {
                TabItemPart tip = (TabItemPart)cp;
                Rectangle bounds = tip.getModel().getBoundsCopy();
                bounds.setLocation(pos);
                pos.x += bounds.width + 2;
                tabItemTotalWidth = pos.x;
                tip.getFigure().setBounds(bounds);
                continue;
            }
            if (!(cp instanceof TabBodyPart)) continue;
            Rectangle rect = part.getFigure().getBounds().getCopy();
            rect.y += 27;
            rect.height -= 27;
            cp.getFigure().setBounds(rect);
            cp.getFigure().isVisible();
            int x = TabFolderLayout.PADDING.left;
            int y = TabFolderLayout.PADDING.top;
            for (Object obj : cp.getChildren()) {
                ComponentPart object = (ComponentPart)obj;
                Rectangle newRect = GraphLayoutManager.layout(object);
                object.getFigure().setSize(newRect.getSize());
                Dimension size = newRect.getSize();
                x = Math.max(x, size.width + TabFolderLayout.PADDING.left);
                y += size.height + TabFolderLayout.PADDING.top;
            }
            maxSize.x = Math.max(maxSize.x, x);
            maxSize.y = Math.max(maxSize.y, y);
            Dimension d = cp.getFigure().getSize();
            if (d.width >= x && d.height >= y) continue;
            cp.getFigure().setSize(Math.max(d.width, x), Math.max(d.height, y - 2));
        }
        maxSize.y += 25;
        Rectangle rect = super.layout(ep);
        rect.width = Math.max(maxSize.x, Math.max(rect.width, tabItemTotalWidth));
        rect.height = Math.max(maxSize.y, rect.height);
        return rect;
    }

    protected void applyToFigure(ComponentPart ep, Rectangle layout) {
        super.applyToFigure(ep, layout);
    }
}

