/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.commands;

import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.TabBody;
import java.util.List;
import org.eclipse.gef.commands.Command;

public class MoveRemoteChildCmpCmd
extends Command {
    private Container srcContainer;
    private Container destContainer;
    private AuroraComponent acToMove;
    private AuroraComponent acReference = null;
    private int oriIndex = -1;

    public void setComponentToMove(AuroraComponent child) {
        this.acToMove = child;
        this.srcContainer = child.getParent();
    }

    public void setReferenceComponent(AuroraComponent after) {
        this.acReference = after;
    }

    public void setTargetContainer(Container tgtContainer) {
        this.destContainer = tgtContainer;
    }

    public boolean canExecute() {
        if (this.acToMove instanceof TabBody) {
            return false;
        }
        return super.canExecute();
    }

    public boolean canUndo() {
        return super.canUndo();
    }

    public String getLabel() {
        return "Move Component";
    }

    public void execute() {
        List<AuroraComponent> srcList = this.srcContainer.getChildren();
        List<AuroraComponent> destList = this.destContainer.getChildren();
        this.oriIndex = srcList.indexOf(this.acToMove);
        this.srcContainer.removeChild(this.oriIndex);
        if (this.acReference == null) {
            this.destContainer.addChild(this.acToMove);
        } else {
            int idx = destList.indexOf(this.acReference);
            this.destContainer.addChild(this.acToMove, idx);
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        this.destContainer.removeChild(this.acToMove);
        this.srcContainer.addChild(this.acToMove, this.oriIndex);
    }
}

