/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.io;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.ButtonClicker;
import aurora.ide.meta.gef.editors.models.Toolbar;
import aurora.ide.meta.gef.editors.models.io.DefaultIOHandler;
import aurora.ide.meta.gef.editors.models.io.ModelIOContext;
import aurora.ide.meta.gef.editors.models.io.ParameterHandler;
import aurora.ide.meta.gef.editors.models.io.ReferenceDecl;
import aurora.ide.meta.gef.editors.models.io.ReferenceHandler;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import uncertain.composite.CompositeMap;

public class ButtonHandler
extends DefaultIOHandler {
    public static final String COMMENT_TARGET = "target";

    protected void storeSimpleAttribute(CompositeMap map, AuroraComponent ac) {
        Button b = (Button)ac;
        map.put((Object)"type", (Object)b.getButtonType());
        if (!b.isOnToolBar()) {
            map.put((Object)"width", (Object)b.getSize().width);
            map.put((Object)"height", (Object)b.getSize().height);
        }
        if (b.getButtonType().equals("")) {
            map.put((Object)"text", (Object)b.getText());
        }
    }

    protected void storeComplexAttribute(CompositeMap map, AuroraComponent ac) {
        Button b = (Button)ac;
        if (!b.isOnToolBar()) {
            ButtonClicker bc = b.getButtonClicker();
            if (bc == null) {
                return;
            }
            CommentCompositeMap bcMap = new CommentCompositeMap(ButtonClicker.class.getSimpleName());
            String aid = bc.getActionID();
            bcMap.put((Object)"id", (Object)bc.getActionID());
            if ("query".equals(aid) || "save".equals(aid) || "reset".equals(aid)) {
                AuroraComponent a = bc.getTargetComponent();
                if (a != null) {
                    ReferenceHandler roh = new ReferenceHandler();
                    CompositeMap tcMap = roh.toCompositeMap(a, this.mic);
                    tcMap.put((Object)"comment", (Object)COMMENT_TARGET);
                    bcMap.addChild(tcMap);
                }
            } else if ("open".equals(aid)) {
                bcMap.put((Object)"openPath", (Object)bc.getOpenPath());
            } else if ("close".equals(aid)) {
                bcMap.put((Object)"closeWindowID", (Object)bc.getCloseWindowID());
            } else if ("custom".equals(aid)) {
                CommentCompositeMap fMap = new CommentCompositeMap("function");
                fMap.setText(bc.getFunction());
                bcMap.addChild((CompositeMap)fMap);
            }
            map.addChild((CompositeMap)bcMap);
            map.addChild(this.getParameterMap(bc, this.mic));
        }
    }

    private CompositeMap getParameterMap(ButtonClicker clicker, ModelIOContext mic) {
        CommentCompositeMap pMap = new CommentCompositeMap("parameters");
        ParameterHandler ph = new ParameterHandler();
        for (Parameter p : clicker.getParameters()) {
            pMap.addChild(ph.toCompositeMap(p, mic));
        }
        return pMap;
    }

    protected void restoreSimpleAttribute(AuroraComponent ac, CompositeMap map) {
        String text;
        Button b = (Button)ac;
        b.setButtonType(map.getString((Object)"type"));
        if (!map.getParent().getName().equalsIgnoreCase(Toolbar.class.getSimpleName())) {
            b.setSize(new Dimension(map.getInt((Object)"width").intValue(), map.getInt((Object)"height").intValue()));
        }
        if (b.getButtonType().equals("") && (text = map.getString((Object)"text")) != null) {
            b.setText(text);
        }
    }

    public Button fromCompositeMap(CompositeMap map, ModelIOContext mic) {
        return (Button)super.fromCompositeMap(map, mic);
    }

    protected void restoreComplexAttribute(AuroraComponent ac, CompositeMap map) {
        Button b = (Button)ac;
        if (!map.getParent().getName().equalsIgnoreCase(Toolbar.class.getSimpleName())) {
            CompositeMap fMap;
            ButtonClicker bc = b.getButtonClicker();
            CompositeMap bcMap = map.getChild(ButtonClicker.class.getSimpleName());
            if (bc == null || bcMap == null) {
                return;
            }
            String aid = bcMap.getString((Object)"id");
            bc.setActionID(aid);
            if ("query".equals(aid) || "save".equals(aid) || "reset".equals(aid)) {
                CompositeMap tMap = this.getMap(bcMap, "ref", "comment", COMMENT_TARGET);
                if (tMap != null) {
                    String markid = tMap.getString((Object)"referenceid");
                    AuroraComponent a = this.mic.markMap.get(markid);
                    if (a != null) {
                        bc.setTargetComponent(a);
                    } else {
                        ReferenceDecl rd = new ReferenceDecl();
                        rd.markid = markid;
                        rd.methodOwner = bc;
                        rd.methodName = "setTargetComponent";
                        rd.argType = AuroraComponent.class;
                        this.mic.refDeclList.add(rd);
                    }
                }
            } else if ("open".equals(aid)) {
                bc.setOpenPath(bcMap.getString((Object)"openPath"));
            } else if ("close".equals(aid)) {
                bc.setCloseWindowID(bcMap.getString((Object)"closeWindowID"));
            } else if ("custom".equals(aid) && (fMap = bcMap.getChild("function")) != null) {
                bc.setFunction(fMap.getText());
            }
            this.restoreParameters(bc, map, this.mic);
        }
    }

    protected AuroraComponent getNewObject(CompositeMap map) {
        return new Button();
    }

    private void restoreParameters(ButtonClicker clicker, CompositeMap rMap, ModelIOContext mic) {
        CompositeMap psMap = rMap.getChild("parameters");
        if (psMap == null) {
            return;
        }
        ParameterHandler ph = new ParameterHandler();
        List list = psMap.getChildsNotNull();
        for (CompositeMap m : list) {
            Parameter p = (Parameter)ph.fromCompositeMap(m, mic);
            clicker.addParameter(p);
        }
    }
}

