/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.io;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Container;
import aurora.ide.meta.gef.editors.models.io.IOHandler;
import aurora.ide.meta.gef.editors.models.io.IOHandlerUtil;
import aurora.ide.meta.gef.editors.models.io.ModelIOContext;
import java.util.List;
import uncertain.composite.CompositeMap;

public abstract class DefaultIOHandler
implements IOHandler {
    public static final String CHILD_LIST = "CHILD_LIST";
    public static final String MARKID = "markid";
    public static final String SECTION_TYPE = "sectiontype";
    protected ModelIOContext mic;

    public CompositeMap toCompositeMap(AuroraComponent ac, ModelIOContext mic) {
        this.mic = mic;
        CommentCompositeMap map = new CommentCompositeMap();
        map.setName(ac.getClass().getSimpleName());
        map.put((Object)MARKID, (Object)ac.markid);
        map.put((Object)"name", (Object)ac.getName());
        this.storeSimpleAttribute((CompositeMap)map, ac);
        this.storeComplexAttribute((CompositeMap)map, ac);
        if (ac instanceof Container) {
            Container cont = (Container)ac;
            String sectionType = cont.getSectionType();
            if (sectionType != null) {
                map.put((Object)SECTION_TYPE, (Object)sectionType);
            }
            this.storeChildren((CompositeMap)map, cont);
        }
        return map;
    }

    protected void storeSimpleAttribute(CompositeMap map, AuroraComponent ac) {
    }

    protected void storeComplexAttribute(CompositeMap map, AuroraComponent ac) {
    }

    protected void storeChildren(CompositeMap map, Container container) {
        List<AuroraComponent> list = container.getChildren();
        if (list.size() == 0) {
            return;
        }
        CommentCompositeMap childList = new CommentCompositeMap(CHILD_LIST);
        for (AuroraComponent a : list) {
            if (!this.isStoreable(a)) continue;
            IOHandler ioh = IOHandlerUtil.getHandler(a);
            childList.addChild(ioh.toCompositeMap(a, this.mic));
        }
        map.addChild((CompositeMap)childList);
    }

    protected boolean isStoreable(AuroraComponent ac) {
        return true;
    }

    protected abstract AuroraComponent getNewObject(CompositeMap var1);

    public AuroraComponent fromCompositeMap(CompositeMap map, ModelIOContext mic) {
        this.mic = mic;
        AuroraComponent ac = this.getNewObject(map);
        ac.markid = map.getString((Object)MARKID);
        mic.markMap.put(ac.markid, ac);
        ac.setName(this.notNull(map.getString((Object)"name")));
        this.restoreSimpleAttribute(ac, map);
        this.restoreComplexAttribute(ac, map);
        if (ac instanceof Container) {
            String sectionType = map.getString((Object)SECTION_TYPE);
            Container cont = (Container)ac;
            if (sectionType != null && sectionType.length() > 0) {
                cont.setSectionType(sectionType);
            }
            this.restoreChildren(cont, map);
        }
        return ac;
    }

    protected void restoreSimpleAttribute(AuroraComponent ac, CompositeMap map) {
    }

    protected void restoreComplexAttribute(AuroraComponent ac, CompositeMap map) {
    }

    protected void restoreChildren(Container container, CompositeMap map) {
        CompositeMap childList = map.getChild(CHILD_LIST);
        if (childList == null) {
            return;
        }
        List list = childList.getChildsNotNull();
        for (CompositeMap m : list) {
            IOHandler ioh1 = IOHandlerUtil.getHandler(m);
            container.addChild(ioh1.fromCompositeMap(m, this.mic));
        }
    }

    public final CompositeMap getMap(CompositeMap parMap, String prefix, String attrName, String value) {
        CompositeMap map = parMap.getChildByAttrib((Object)attrName, (Object)value);
        if (map == null) {
            return null;
        }
        if (prefix == null ? map.getPrefix() == null : prefix.equals(map.getPrefix())) {
            return map;
        }
        return null;
    }

    private String notNull(String s) {
        return s == null ? "" : s;
    }
}

