/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.io;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Renderer;
import aurora.ide.meta.gef.editors.models.io.DefaultIOHandler;
import aurora.ide.meta.gef.editors.models.io.ModelIOContext;
import aurora.ide.meta.gef.editors.models.io.ParameterHandler;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import java.util.List;
import uncertain.composite.CompositeMap;

public class RendererHandler
extends DefaultIOHandler {
    public static final String RENDERER_TYPE = "renderertype";
    public static final String DISPLAY_TEXT = "displaytext";
    public static final String OPEN_PATH = "openpath";
    public static final String FUNCTION_NAME = "functionname";
    public static final String FUNCTION = "function";
    public static final String PARAMETERS = "parameters";

    protected void storeSimpleAttribute(CompositeMap map, AuroraComponent ac) {
        super.storeSimpleAttribute(map, ac);
        Renderer renderer = (Renderer)ac;
        map.put((Object)RENDERER_TYPE, (Object)renderer.getRendererType());
        map.put((Object)DISPLAY_TEXT, (Object)renderer.getLabelText());
        map.put((Object)OPEN_PATH, (Object)renderer.getOpenPath());
        map.put((Object)FUNCTION_NAME, (Object)renderer.getFunctionName());
    }

    protected void storeComplexAttribute(CompositeMap map, AuroraComponent ac) {
        super.storeComplexAttribute(map, ac);
        Renderer renderer = (Renderer)ac;
        CommentCompositeMap fMap = new CommentCompositeMap(FUNCTION);
        fMap.setText(renderer.getFunction());
        map.addChild((CompositeMap)fMap);
        map.addChild(this.getParameterMap(renderer, this.mic));
    }

    private CompositeMap getParameterMap(Renderer renderer, ModelIOContext mic) {
        CommentCompositeMap pMap = new CommentCompositeMap(PARAMETERS);
        ParameterHandler ph = new ParameterHandler();
        for (Parameter p : renderer.getParameters()) {
            pMap.addChild(ph.toCompositeMap(p, mic));
        }
        return pMap;
    }

    protected Renderer getNewObject(CompositeMap map) {
        return new Renderer();
    }

    protected void restoreSimpleAttribute(AuroraComponent ac, CompositeMap map) {
        super.restoreSimpleAttribute(ac, map);
        Renderer renderer = (Renderer)ac;
        renderer.setRendererType(map.getString((Object)RENDERER_TYPE));
        renderer.setLabelText(map.getString((Object)DISPLAY_TEXT));
        renderer.setOpenPath(map.getString((Object)OPEN_PATH));
        renderer.setFunctionName(map.getString((Object)FUNCTION_NAME));
    }

    protected void restoreComplexAttribute(AuroraComponent ac, CompositeMap map) {
        super.restoreComplexAttribute(ac, map);
        Renderer renderer = (Renderer)ac;
        CompositeMap fMap = map.getChild(FUNCTION);
        if (fMap != null) {
            renderer.setFunction(fMap.getText());
        }
        this.restoreParameters(renderer, map, this.mic);
    }

    private void restoreParameters(Renderer renderer, CompositeMap rMap, ModelIOContext mic) {
        CompositeMap psMap = rMap.getChild(PARAMETERS);
        if (psMap == null) {
            return;
        }
        ParameterHandler ph = new ParameterHandler();
        List list = psMap.getChildsNotNull();
        for (CompositeMap m : list) {
            Parameter p = (Parameter)ph.fromCompositeMap(m, mic);
            renderer.addParameter(p);
        }
    }
}

