/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.models.io;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.ModelQuery;
import aurora.ide.meta.gef.editors.models.io.DefaultIOHandler;
import aurora.ide.meta.gef.editors.models.io.ModelIOContext;
import aurora.ide.meta.gef.editors.models.io.ParameterHandler;
import aurora.ide.meta.gef.editors.models.io.ReferenceDecl;
import aurora.ide.meta.gef.editors.models.io.ReferenceHandler;
import aurora.ide.meta.gef.editors.models.link.Parameter;
import aurora.ide.meta.gef.editors.models.link.TabRef;
import java.util.List;
import uncertain.composite.CompositeMap;

public class TabRefHandler
extends DefaultIOHandler {
    public static final String URL = "url";
    public static final String TABITEM = "tabitem";

    protected AuroraComponent getNewObject(CompositeMap map) {
        return new TabRef();
    }

    protected void storeSimpleAttribute(CompositeMap map, AuroraComponent ac) {
        super.storeSimpleAttribute(map, ac);
        TabRef ref = (TabRef)ac;
        map.put((Object)URL, (Object)ref.getOpenPath());
    }

    protected void storeComplexAttribute(CompositeMap map, AuroraComponent ac) {
        super.storeComplexAttribute(map, ac);
        TabRef ref = (TabRef)ac;
        ModelQuery im = ref.getModelQuery();
        if (im != null) {
            ReferenceHandler rh = new ReferenceHandler();
            CompositeMap imMap = rh.toCompositeMap(im, this.mic);
            imMap.put((Object)"comment", (Object)ModelQuery.class.getSimpleName());
            map.addChild(imMap);
        }
        map.addChild(this.getParameterMap(ref, this.mic));
    }

    private CompositeMap getParameterMap(TabRef ref, ModelIOContext mic) {
        CommentCompositeMap pMap = new CommentCompositeMap("parameters");
        ParameterHandler ph = new ParameterHandler();
        for (Parameter p : ref.getParameters()) {
            pMap.addChild(ph.toCompositeMap(p, mic));
        }
        return pMap;
    }

    protected void restoreSimpleAttribute(AuroraComponent ac, CompositeMap map) {
        super.restoreSimpleAttribute(ac, map);
        TabRef ref = (TabRef)ac;
        ref.setOpenPath(map.getString((Object)URL));
    }

    protected void restoreComplexAttribute(AuroraComponent ac, CompositeMap map) {
        super.restoreComplexAttribute(ac, map);
        TabRef ref = (TabRef)ac;
        CompositeMap m = this.getMap(map, "ref", "comment", ModelQuery.class.getSimpleName());
        if (m != null) {
            String mid = m.getString((Object)"referenceid");
            ModelQuery im = (ModelQuery)this.mic.markMap.get(mid);
            if (im != null) {
                ref.setModelQuery(im);
            } else {
                ReferenceDecl rd = new ReferenceDecl(mid, ref, "setModelQuery", ModelQuery.class);
                this.mic.refDeclList.add(rd);
            }
        }
        this.restoreParameters(ref, map, this.mic);
    }

    private void restoreParameters(TabRef ref, CompositeMap map, ModelIOContext mic) {
        CompositeMap psMap = map.getChild("parameters");
        if (psMap == null) {
            return;
        }
        ParameterHandler ph = new ParameterHandler();
        List list = psMap.getChildsNotNull();
        for (CompositeMap m : list) {
            Parameter p = (Parameter)ph.fromCompositeMap(m, mic);
            ref.addParameter(p);
        }
    }
}

