/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.parts;

import aurora.ide.meta.gef.editors.EditorMode;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.CheckBox;
import aurora.ide.meta.gef.editors.models.FieldSet;
import aurora.ide.meta.gef.editors.models.Form;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.GridSelectionCol;
import aurora.ide.meta.gef.editors.models.HBox;
import aurora.ide.meta.gef.editors.models.Input;
import aurora.ide.meta.gef.editors.models.Label;
import aurora.ide.meta.gef.editors.models.Navbar;
import aurora.ide.meta.gef.editors.models.Radio;
import aurora.ide.meta.gef.editors.models.TabBody;
import aurora.ide.meta.gef.editors.models.TabFolder;
import aurora.ide.meta.gef.editors.models.TabItem;
import aurora.ide.meta.gef.editors.models.Toolbar;
import aurora.ide.meta.gef.editors.models.VBox;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.parts.BoxPart;
import aurora.ide.meta.gef.editors.parts.ButtonPart;
import aurora.ide.meta.gef.editors.parts.CheckBoxPart;
import aurora.ide.meta.gef.editors.parts.ComponentPart;
import aurora.ide.meta.gef.editors.parts.GridColumnPart;
import aurora.ide.meta.gef.editors.parts.GridPart;
import aurora.ide.meta.gef.editors.parts.GridSelectionColPart;
import aurora.ide.meta.gef.editors.parts.InputPart;
import aurora.ide.meta.gef.editors.parts.LabelPart;
import aurora.ide.meta.gef.editors.parts.NavbarPart;
import aurora.ide.meta.gef.editors.parts.RadioPart;
import aurora.ide.meta.gef.editors.parts.TabBodyPart;
import aurora.ide.meta.gef.editors.parts.TabFolderPart;
import aurora.ide.meta.gef.editors.parts.TabItemPart;
import aurora.ide.meta.gef.editors.parts.ToolbarPart;
import aurora.ide.meta.gef.editors.parts.ViewDiagramPart;
import java.util.HashMap;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

public class AuroraPartFactory
implements EditPartFactory {
    private static HashMap<Class<? extends AuroraComponent>, Class<? extends ComponentPart>> map = new HashMap(20);
    private EditorMode editorMode;

    static {
        map.put(ViewDiagram.class, ViewDiagramPart.class);
        map.put(Form.class, BoxPart.class);
        map.put(FieldSet.class, BoxPart.class);
        map.put(HBox.class, BoxPart.class);
        map.put(VBox.class, BoxPart.class);
        map.put(CheckBox.class, CheckBoxPart.class);
        map.put(Radio.class, RadioPart.class);
        map.put(Input.class, InputPart.class);
        map.put(Grid.class, GridPart.class);
        map.put(Button.class, ButtonPart.class);
        map.put(GridColumn.class, GridColumnPart.class);
        map.put(Toolbar.class, ToolbarPart.class);
        map.put(Navbar.class, NavbarPart.class);
        map.put(TabItem.class, TabItemPart.class);
        map.put(TabFolder.class, TabFolderPart.class);
        map.put(TabBody.class, TabBodyPart.class);
        map.put(GridSelectionCol.class, GridSelectionColPart.class);
        map.put(Label.class, LabelPart.class);
    }

    public AuroraPartFactory(EditorMode editorMode) {
        this.editorMode = editorMode;
    }

    public EditPart createEditPart(EditPart context, Object model) {
        ComponentPart part = null;
        Class<? extends ComponentPart> cls = map.get(model.getClass());
        if (cls != null) {
            try {
                part = cls.newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (part == null) {
            return part;
        }
        part.setParent(context);
        part.setModel(model);
        part.setEditorMode(this.editorMode);
        return part;
    }
}

