/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import aurora.ide.meta.gef.editors.property.PropertySheetEntry;
import aurora.ide.meta.gef.editors.property.PropertySheetSorter;
import aurora.ide.meta.gef.editors.property.PropertySheetViewer;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class PropertySheetPage
extends Page
implements IPropertySheetPage,
IAdaptable {
    private PropertySheetViewer viewer;
    private PropertySheetSorter sorter;
    private IPropertySheetEntry rootEntry;
    private IPropertySourceProvider provider;
    private Clipboard clipboard;
    private IWorkbenchPart sourcePart;
    private PartListener partListener = new PartListener();

    public void createControl(Composite parent) {
        this.viewer = new PropertySheetViewer(parent);
        this.viewer.setSorter(this.sorter);
        if (this.rootEntry == null) {
            PropertySheetEntry root = new PropertySheetEntry();
            if (this.provider != null) {
                root.setPropertySourceProvider(this.provider);
            }
            this.rootEntry = root;
        }
        this.viewer.setRootEntry(this.rootEntry);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PropertySheetPage.this.handleEntrySelection(event.getSelection());
            }
        });
        this.initDragAndDrop();
        this.makeActions();
    }

    public void dispose() {
        super.dispose();
        if (this.sourcePart != null) {
            this.sourcePart.getSite().getPage().removePartListener((IPartListener)this.partListener);
        }
        if (this.rootEntry != null) {
            this.rootEntry.dispose();
            this.rootEntry = null;
        }
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (ISaveablePart.class.equals((Object)adapter)) {
            return this.getSaveablePart();
        }
        return null;
    }

    protected ISaveablePart getSaveablePart() {
        if (this.sourcePart instanceof ISaveablePart) {
            return (ISaveablePart)this.sourcePart;
        }
        return null;
    }

    public Control getControl() {
        if (this.viewer == null) {
            return null;
        }
        return this.viewer.getControl();
    }

    public void handleEntrySelection(ISelection selection) {
    }

    protected void initDragAndDrop() {
        int operations = 1;
        Transfer[] transferTypes = new Transfer[]{TextTransfer.getInstance()};
        DragSourceAdapter listener = new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                PropertySheetPage.this.performDragSetData(event);
            }

            public void dragFinished(DragSourceEvent event) {
            }
        };
        DragSource dragSource = new DragSource(this.viewer.getControl(), operations);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener((DragSourceListener)listener);
    }

    void performDragSetData(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        IPropertySheetEntry entry = (IPropertySheetEntry)selection.getFirstElement();
        StringBuffer buffer = new StringBuffer();
        buffer.append(entry.getDisplayName());
        buffer.append("\t");
        buffer.append(entry.getValueAsString());
        event.data = buffer.toString();
    }

    private void makeActions() {
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
    }

    public void refresh() {
        if (this.viewer == null) {
            return;
        }
        this.viewer.setInput(this.viewer.getInput());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.viewer == null) {
            return;
        }
        if (this.sourcePart != null) {
            this.sourcePart.getSite().getPage().removePartListener((IPartListener)this.partListener);
            this.sourcePart = null;
        }
        if (selection instanceof IStructuredSelection) {
            this.sourcePart = part;
            this.viewer.setInput(((IStructuredSelection)selection).toArray());
        }
        if (this.sourcePart != null) {
            this.sourcePart.getSite().getPage().addPartListener((IPartListener)this.partListener);
        }
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void setPropertySourceProvider(IPropertySourceProvider newProvider) {
        this.provider = newProvider;
        if (this.rootEntry instanceof PropertySheetEntry) {
            ((PropertySheetEntry)this.rootEntry).setPropertySourceProvider(this.provider);
            this.viewer.setRootEntry(this.rootEntry);
        }
    }

    public void setRootEntry(IPropertySheetEntry entry) {
        this.rootEntry = entry;
        if (this.viewer != null) {
            this.viewer.setRootEntry(this.rootEntry);
        }
    }

    protected void setSorter(PropertySheetSorter sorter) {
        this.sorter = sorter;
        if (this.viewer != null) {
            this.viewer.setSorter(sorter);
            if (this.viewer.getRootEntry() != null) {
                this.viewer.setRootEntry(this.rootEntry);
            }
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (PropertySheetPage.this.sourcePart == part) {
                if (PropertySheetPage.this.sourcePart != null) {
                    PropertySheetPage.this.sourcePart.getSite().getPage().removePartListener((IPartListener)PropertySheetPage.this.partListener);
                }
                PropertySheetPage.this.sourcePart = null;
                if (PropertySheetPage.this.viewer != null && !PropertySheetPage.this.viewer.getControl().isDisposed()) {
                    PropertySheetPage.this.viewer.setInput(new Object[0]);
                }
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }
}

