/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.property;

import aurora.ide.meta.gef.editors.models.link.DeadTabRef;
import aurora.ide.meta.gef.editors.models.link.TabRef;
import aurora.ide.meta.gef.editors.wizard.CreateEditTabRefWizard;
import aurora.ide.meta.gef.editors.wizard.TabRefWizardDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TabRefCellEditor
extends CellEditor
implements SelectionListener,
MouseListener {
    private Button button;
    private CLabel label;
    private TabRef value;
    Shell shell;

    public TabRefCellEditor(Composite parent) {
        super(parent, 0);
    }

    protected Control createControl(Composite parent) {
        this.shell = parent.getShell();
        Composite com = new Composite(parent, 0);
        com.setBackground(parent.getBackground());
        com.setLayout((Layout)new SimpleLayout());
        this.label = new CLabel(com, 0);
        this.label.addMouseListener((MouseListener)this);
        this.button = new Button(com, 0x800000);
        this.button.setText("...");
        this.button.addSelectionListener((SelectionListener)this);
        return com;
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
    }

    protected void doSetValue(Object value) {
        if (value instanceof TabRef) {
            this.value = (TabRef)value;
            String url = this.value.getOpenPath();
            this.label.setText(url == null || "".equals(url) ? "" : url);
        } else {
            value = null;
        }
    }

    public void activate(ColumnViewerEditorActivationEvent activationEvent) {
        if (activationEvent.eventType != 5) {
            super.activate(activationEvent);
        }
    }

    private void showDialog() {
        try {
            CreateEditTabRefWizard w = new CreateEditTabRefWizard(this.value);
            w.setWindowTitle("Ref");
            TabRefWizardDialog wd = new TabRefWizardDialog(this.shell, w);
            if (wd.open() == 0) {
                this.value = w.isDel() ? new DeadTabRef() : w.getResult();
                this.fireApplyEditorValue();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.showDialog();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
        this.showDialog();
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    private class SimpleLayout
    extends Layout {
        private int width = 17;

        private SimpleLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return new Point(800, 20);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Point size = composite.getSize();
            TabRefCellEditor.this.label.setBounds(0, 0, size.x - this.width, size.y);
            TabRefCellEditor.this.button.setBounds(size.x - this.width, 0, this.width, size.y);
        }
    }
}

