/*
 * Decompiled with CFR 0.152.
 */
package aurora.ide.meta.gef.editors.source.gen.core;

import aurora.ide.api.composite.map.CommentCompositeMap;
import aurora.ide.meta.gef.Util;
import aurora.ide.meta.gef.designer.BMCompositeMap;
import aurora.ide.meta.gef.editors.models.AuroraComponent;
import aurora.ide.meta.gef.editors.models.BOX;
import aurora.ide.meta.gef.editors.models.Button;
import aurora.ide.meta.gef.editors.models.CheckBox;
import aurora.ide.meta.gef.editors.models.Dataset;
import aurora.ide.meta.gef.editors.models.Grid;
import aurora.ide.meta.gef.editors.models.GridColumn;
import aurora.ide.meta.gef.editors.models.GridSelectionCol;
import aurora.ide.meta.gef.editors.models.IDatasetFieldDelegate;
import aurora.ide.meta.gef.editors.models.Input;
import aurora.ide.meta.gef.editors.models.TabFolder;
import aurora.ide.meta.gef.editors.models.TabItem;
import aurora.ide.meta.gef.editors.models.Toolbar;
import aurora.ide.meta.gef.editors.models.ViewDiagram;
import aurora.ide.meta.gef.editors.source.gen.BoxMap;
import aurora.ide.meta.gef.editors.source.gen.ButtonMap;
import aurora.ide.meta.gef.editors.source.gen.CheckBoxMap;
import aurora.ide.meta.gef.editors.source.gen.DataSetFieldUtil;
import aurora.ide.meta.gef.editors.source.gen.DatasetFieldMap;
import aurora.ide.meta.gef.editors.source.gen.DatasetMap;
import aurora.ide.meta.gef.editors.source.gen.GridColumnMap;
import aurora.ide.meta.gef.editors.source.gen.GridMap;
import aurora.ide.meta.gef.editors.source.gen.InputMap;
import aurora.ide.meta.gef.editors.source.gen.TabFolderMap;
import aurora.ide.meta.gef.editors.source.gen.TabItemMap;
import aurora.ide.meta.gef.editors.source.gen.core.MapFinder;
import aurora.ide.meta.gef.editors.source.gen.core.ScreenGenerator;
import java.util.List;
import uncertain.composite.CompositeMap;

public class AuroraComponent2CompositMap {
    public static final String SCREEN_PREFIX = "a";
    private ScreenGenerator screenGenerator;

    public static CompositeMap createScreenCompositeMap() {
        CommentCompositeMap screen = new CommentCompositeMap("screen");
        screen.setNameSpace(SCREEN_PREFIX, "http://www.aurora-framework.org/application");
        return screen;
    }

    public AuroraComponent2CompositMap(ScreenGenerator screenGenerator) {
        this.screenGenerator = screenGenerator;
    }

    public static CompositeMap createChild(String name) {
        CommentCompositeMap node = new CommentCompositeMap(name);
        node.setPrefix(SCREEN_PREFIX);
        return node;
    }

    public CompositeMap toCompositMap(AuroraComponent c) {
        if (c instanceof Input) {
            return new InputMap((Input)c).toCompositMap();
        }
        if (c instanceof Button) {
            return new ButtonMap((Button)c).toCompositMap();
        }
        if (c instanceof BOX) {
            return new BoxMap((BOX)c).toCompositMap();
        }
        if (c instanceof CheckBox) {
            return new CheckBoxMap((CheckBox)c).toCompositMap();
        }
        if (c instanceof Grid) {
            return new GridMap((Grid)c).toCompositMap();
        }
        if (c instanceof GridSelectionCol) {
            return null;
        }
        if (c instanceof GridColumn) {
            return new GridColumnMap((GridColumn)c, this.screenGenerator).toCompositMap();
        }
        if (c instanceof Dataset) {
            return new DatasetMap((Dataset)c).toCompositMap();
        }
        if (c instanceof Toolbar) {
            return AuroraComponent2CompositMap.createChild("toolBar");
        }
        if (c instanceof TabItem) {
            return new TabItemMap((TabItem)c).toCompositMap();
        }
        if (c instanceof TabFolder) {
            return new TabFolderMap((TabFolder)c).toCompositMap();
        }
        if (c instanceof ViewDiagram) {
            return AuroraComponent2CompositMap.createChild("view");
        }
        return null;
    }

    public void bindDatasetField(CompositeMap dsMap, Dataset dataset, AuroraComponent ac) {
        if (ac instanceof IDatasetFieldDelegate) {
            DatasetFieldMap dfm = new DatasetFieldMap(dsMap, dataset, ac, this.screenGenerator);
            dfm.toCompositMap();
        }
    }

    public void doLovMap(Dataset ds, AuroraComponent ac, CompositeMap lovMap) {
        CompositeMap bmMap;
        if (ds == null) {
            return;
        }
        CompositeMap containerMap = lovMap.getParent();
        DataSetFieldUtil dataSetFieldUtil = new DataSetFieldUtil(this.screenGenerator.getProject(), ac.getName(), ds.getModel());
        CompositeMap optionsMap = dataSetFieldUtil.getOptionsMap();
        BMCompositeMap opb = null;
        if (optionsMap != null) {
            opb = new BMCompositeMap(optionsMap);
        }
        if ((bmMap = dataSetFieldUtil.getBmMap()) == null) {
            return;
        }
        MapFinder mf = new MapFinder();
        CompositeMap relation = mf.lookupRelation(lovMap.getString((Object)"name", ""), bmMap);
        if (relation != null) {
            String rName = relation.getString((Object)"name", "");
            List<CompositeMap> lovFields = mf.lookupLovFields(rName, bmMap);
            for (CompositeMap compositeMap : lovFields) {
                CompositeMap clone = (CompositeMap)lovMap.clone();
                String source = Util.getCompositeValue("sourceField", compositeMap);
                String name = Util.getCompositeValue("name", compositeMap);
                if (opb == null || opb.getFieldByName(source) == null || name == null || "".equals(name)) continue;
                clone.put((Object)"name", (Object)name);
                containerMap.addChild(clone);
            }
            containerMap.removeChild(lovMap);
            return;
        }
    }
}

